/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import droidninja.filepicker.FilePickerActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.models.sort.SortingTypes;
import droidninja.filepicker.utils.Orientation;
import java.util.ArrayList;

public class FilePickerBuilder {
    private final Bundle mPickerOptionsBundle = new Bundle();

    public static FilePickerBuilder getInstance() {
        return new FilePickerBuilder();
    }

    public FilePickerBuilder setMaxCount(int maxCount) {
        PickerManager.getInstance().setMaxCount(maxCount);
        return this;
    }

    public FilePickerBuilder setActivityTheme(int theme) {
        PickerManager.getInstance().setTheme(theme);
        return this;
    }

    public FilePickerBuilder setActivityTitle(String title) {
        PickerManager.getInstance().setTitle(title);
        return this;
    }

    public FilePickerBuilder setSelectedFiles(ArrayList<String> selectedPhotos) {
        this.mPickerOptionsBundle.putStringArrayList("SELECTED_PHOTOS", selectedPhotos);
        return this;
    }

    public FilePickerBuilder enableVideoPicker(boolean status) {
        PickerManager.getInstance().setShowVideos(status);
        return this;
    }

    public FilePickerBuilder enableImagePicker(boolean status) {
        PickerManager.getInstance().setShowImages(status);
        return this;
    }

    public FilePickerBuilder enableSelectAll(boolean status) {
        PickerManager.getInstance().enableSelectAll(status);
        return this;
    }

    public FilePickerBuilder setCameraPlaceholder(@DrawableRes int drawable2) {
        PickerManager.getInstance().setCameraDrawable(drawable2);
        return this;
    }

    public FilePickerBuilder showGifs(boolean status) {
        PickerManager.getInstance().setShowGif(status);
        return this;
    }

    public FilePickerBuilder showFolderView(boolean status) {
        PickerManager.getInstance().setShowFolderView(status);
        return this;
    }

    public FilePickerBuilder enableDocSupport(boolean status) {
        PickerManager.getInstance().setDocSupport(status);
        return this;
    }

    public FilePickerBuilder enableCameraSupport(boolean status) {
        PickerManager.getInstance().setEnableCamera(status);
        return this;
    }

    public FilePickerBuilder withOrientation(Orientation orientation) {
        PickerManager.getInstance().setOrientation(orientation);
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions, @DrawableRes int drawable2) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, drawable2));
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, 0));
        return this;
    }

    public FilePickerBuilder sortDocumentsBy(SortingTypes type) {
        PickerManager.getInstance().setSortingType(type);
        return this;
    }

    public void pickPhoto(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 17);
    }

    public void pickPhoto(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 17);
    }

    public void pickFile(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 18);
    }

    public void pickFile(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 18);
    }

    private void start(Activity context, int pickerType) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
            return;
        }
        PickerManager.getInstance().setProviderAuthorities(context.getApplicationContext().getPackageName() + ".droidninja.filepicker.provider");
        Intent intent = new Intent((Context)context, FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        if (pickerType == 17) {
            context.startActivityForResult(intent, 233);
        } else {
            context.startActivityForResult(intent, 234);
        }
    }

    private void start(Fragment fragment, int pickerType) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)fragment.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Toast.makeText((Context)fragment.getContext(), (CharSequence)fragment.getContext().getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
            return;
        }
        PickerManager.getInstance().setProviderAuthorities(fragment.getContext().getApplicationContext().getPackageName() + ".droidninja.filepicker.provider");
        Intent intent = new Intent((Context)fragment.getActivity(), FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        if (pickerType == 17) {
            fragment.startActivityForResult(intent, 233);
        } else {
            fragment.startActivityForResult(intent, 234);
        }
    }
}

