/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import droidninja.filepicker.BaseFilePickerActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.fragments.DocPickerFragment;
import droidninja.filepicker.fragments.MediaPickerFragment;
import droidninja.filepicker.fragments.PhotoPickerFragmentListener;
import droidninja.filepicker.utils.FragmentUtil;
import java.util.ArrayList;

public class FilePickerActivity
extends BaseFilePickerActivity
implements PhotoPickerFragmentListener,
DocFragment.DocFragmentListener,
DocPickerFragment.DocPickerFragmentListener,
MediaPickerFragment.MediaPickerFragmentListener {
    private static final String TAG = FilePickerActivity.class.getSimpleName();
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.activity_file_picker);
    }

    @Override
    protected void initView() {
        Intent intent = this.getIntent();
        if (intent != null) {
            ArrayList<String> selectedPaths = intent.getStringArrayListExtra("SELECTED_PHOTOS");
            this.type = intent.getIntExtra("EXTRA_PICKER_TYPE", 17);
            if (selectedPaths != null) {
                if (PickerManager.getInstance().getMaxCount() == 1) {
                    selectedPaths.clear();
                }
                PickerManager.getInstance().clearSelections();
                if (this.type == 17) {
                    PickerManager.getInstance().add(selectedPaths, 1);
                } else {
                    PickerManager.getInstance().add(selectedPaths, 2);
                }
            } else {
                selectedPaths = new ArrayList<String>();
            }
            this.setToolbarTitle(PickerManager.getInstance().getCurrentCount());
            this.openSpecificFragment(this.type, selectedPaths);
        }
    }

    private void setToolbarTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            int maxCount = PickerManager.getInstance().getMaxCount();
            if (maxCount == -1 && count > 0) {
                actionBar.setTitle((CharSequence)String.format(this.getString(R.string.attachments_num), count));
            } else if (maxCount > 0 && count > 0) {
                actionBar.setTitle((CharSequence)String.format(this.getString(R.string.attachments_title_text), count, maxCount));
            } else if (!TextUtils.isEmpty((CharSequence)PickerManager.getInstance().getTitle())) {
                actionBar.setTitle((CharSequence)PickerManager.getInstance().getTitle());
            } else if (this.type == 17) {
                actionBar.setTitle(R.string.select_photo_text);
            } else {
                actionBar.setTitle(R.string.select_doc_text);
            }
        }
    }

    private void openSpecificFragment(int type, @Nullable ArrayList<String> selectedPaths) {
        if (type == 17) {
            MediaPickerFragment photoFragment = MediaPickerFragment.newInstance();
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        } else {
            if (PickerManager.getInstance().isDocSupport()) {
                PickerManager.getInstance().addDocTypes();
            }
            DocPickerFragment photoFragment = DocPickerFragment.newInstance();
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.picker_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_done) {
            if (this.type == 17) {
                this.returnData(PickerManager.getInstance().getSelectedPhotos());
            } else {
                this.returnData(PickerManager.getInstance().getSelectedFiles());
            }
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        PickerManager.getInstance().reset();
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 235: {
                if (resultCode == -1) {
                    if (this.type == 17) {
                        this.returnData(PickerManager.getInstance().getSelectedPhotos());
                        break;
                    }
                    this.returnData(PickerManager.getInstance().getSelectedFiles());
                    break;
                }
                this.setToolbarTitle(PickerManager.getInstance().getCurrentCount());
            }
        }
    }

    private void returnData(ArrayList<String> paths) {
        Intent intent = new Intent();
        if (this.type == 17) {
            intent.putStringArrayListExtra("SELECTED_PHOTOS", paths);
        } else {
            intent.putStringArrayListExtra("SELECTED_DOCS", paths);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onItemSelected() {
        int currentCount = PickerManager.getInstance().getCurrentCount();
        this.setToolbarTitle(currentCount);
        if (PickerManager.getInstance().getMaxCount() == 1 && currentCount == 1) {
            this.returnData(this.type == 17 ? PickerManager.getInstance().getSelectedPhotos() : PickerManager.getInstance().getSelectedFiles());
        }
    }
}

