/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import droidninja.filepicker.PickerManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ImageCaptureManager {
    private static final String CAPTURED_PHOTO_PATH_KEY = "mCurrentPhotoPath";
    public static final int REQUEST_TAKE_PHOTO = 257;
    private String mCurrentPhotoPath;
    private Context mContext;

    public ImageCaptureManager(Context mContext) {
        this.mContext = mContext;
    }

    private File createImageFile() throws IOException {
        String imageFileName = "JPEG_" + System.currentTimeMillis() + ".jpg";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists() && !storageDir.mkdir()) {
            Log.e((String)"TAG", (String)"Throwing Errors....");
            throw new IOException();
        }
        File image = new File(storageDir, imageFileName);
        this.mCurrentPhotoPath = image.getAbsolutePath();
        return image;
    }

    public Intent dispatchTakePictureIntent(Context context) throws IOException {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                File newFile = this.createImageFile();
                takePictureIntent.addFlags(1);
                takePictureIntent.addFlags(2);
                Uri photoURI = FileProvider.getUriForFile((Context)context, (String)PickerManager.getInstance().getProviderAuthorities(), (File)newFile);
                takePictureIntent.putExtra("output", (Parcelable)photoURI);
            } else {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.createImageFile()));
            }
            return takePictureIntent;
        }
        return null;
    }

    public String galleryAddPic() {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        if (TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            return null;
        }
        File f = new File(this.mCurrentPhotoPath);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        this.mContext.sendBroadcast(mediaScanIntent);
        return this.mCurrentPhotoPath;
    }

    public final void notifyMediaStoreScanner(Context mContext, File file) {
        try {
            MediaStore.Images.Media.insertImage((ContentResolver)mContext.getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
            mContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.mCurrentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.mCurrentPhotoPath);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.mCurrentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }
}

