/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.android.internal.util.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class Utils {
    private static final int WIDTH_INDEX = 0;
    private static final int HEIGHT_INDEX = 1;

    public static <T> Collection<T> filter(Collection<T> target, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : target) {
            if (!predicate.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        try {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean contains(String[] types, String path) {
        for (String string2 : types) {
            if (!path.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static int[] getScreenSize(Context context) {
        int[] widthHeight = new int[]{0, 0};
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        widthHeight[0] = size.x;
        widthHeight[1] = size.y;
        if (!Utils.isScreenSizeRetrieved(widthHeight)) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            widthHeight[0] = metrics.widthPixels;
            widthHeight[1] = metrics.heightPixels;
        }
        if (!Utils.isScreenSizeRetrieved(widthHeight)) {
            widthHeight[0] = display.getWidth();
            widthHeight[1] = display.getHeight();
        }
        return widthHeight;
    }

    private static boolean isScreenSizeRetrieved(int[] widthHeight) {
        return widthHeight[0] != 0 && widthHeight[1] != 0;
    }
}

