/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.FileType;
import java.util.ArrayList;

public class PickerManager {
    private static PickerManager ourInstance = new PickerManager();
    private int maxCount = 9;
    private int currentCount;
    private ArrayList<String> mediaFiles;
    private ArrayList<String> docFiles;
    private ArrayList<FileType> fileTypes;
    private int theme = R.style.LibAppTheme;
    private boolean showVideos;
    private boolean showGif;
    private boolean docSupport = true;
    private boolean enableCamera = true;
    private boolean enableOrientation = false;
    private boolean showFolderView = true;
    private String providerAuthorities;

    public static PickerManager getInstance() {
        return ourInstance;
    }

    private PickerManager() {
        this.mediaFiles = new ArrayList();
        this.docFiles = new ArrayList();
        this.fileTypes = new ArrayList();
    }

    public void setMaxCount(int count) {
        this.clearSelections();
        this.maxCount = count;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public void add(String path, int type) {
        if (path != null && this.shouldAdd()) {
            if (!this.mediaFiles.contains(path) && type == 1) {
                this.mediaFiles.add(path);
            } else if (type == 2) {
                this.docFiles.add(path);
            } else {
                return;
            }
            ++this.currentCount;
        }
    }

    public void add(ArrayList<String> paths, int type) {
        for (int index = 0; index < paths.size(); ++index) {
            this.add(paths.get(index), type);
        }
    }

    public void remove(String path, int type) {
        if (type == 1 && this.mediaFiles.contains(path)) {
            this.mediaFiles.remove(path);
            --this.currentCount;
        } else if (type == 2) {
            this.docFiles.remove(path);
            --this.currentCount;
        }
    }

    public boolean shouldAdd() {
        return this.currentCount < this.maxCount;
    }

    public ArrayList<String> getSelectedPhotos() {
        return this.mediaFiles;
    }

    public ArrayList<String> getSelectedFiles() {
        return this.docFiles;
    }

    public ArrayList<String> getSelectedFilePaths(ArrayList<BaseFile> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (int index = 0; index < files.size(); ++index) {
            paths.add(files.get(index).getPath());
        }
        return paths;
    }

    public void clearSelections() {
        this.docFiles.clear();
        this.mediaFiles.clear();
        this.fileTypes.clear();
        this.currentCount = 0;
        this.maxCount = 0;
    }

    public int getTheme() {
        return this.theme;
    }

    public void setTheme(int theme) {
        this.theme = theme;
    }

    public boolean showVideo() {
        return this.showVideos;
    }

    public void setShowVideos(boolean showVideos) {
        this.showVideos = showVideos;
    }

    public boolean isShowGif() {
        return this.showGif;
    }

    public void setShowGif(boolean showGif) {
        this.showGif = showGif;
    }

    public boolean isShowFolderView() {
        return this.showFolderView;
    }

    public void setShowFolderView(boolean showFolderView) {
        this.showFolderView = showFolderView;
    }

    public void addFileType(FileType fileType) {
        this.fileTypes.add(fileType);
    }

    public void addDocTypes() {
        String[] pdfs = new String[]{"pdf"};
        this.fileTypes.add(new FileType("PDF", pdfs, R.drawable.ic_pdf));
        String[] docs = new String[]{"doc", "docx", "dot", "dotx"};
        this.fileTypes.add(new FileType("DOC", docs, R.drawable.ic_word));
        String[] ppts = new String[]{"ppt", "pptx"};
        this.fileTypes.add(new FileType("PPT", ppts, R.drawable.ic_ppt));
        String[] xlss = new String[]{"xls", "xlsx"};
        this.fileTypes.add(new FileType("XLS", xlss, R.drawable.ic_excel));
        String[] txts = new String[]{"txt"};
        this.fileTypes.add(new FileType("TXT", txts, R.drawable.ic_txt));
    }

    public ArrayList<FileType> getFileTypes() {
        return this.fileTypes;
    }

    public boolean isDocSupport() {
        return this.docSupport;
    }

    public void setDocSupport(boolean docSupport) {
        this.docSupport = docSupport;
    }

    public boolean isEnableCamera() {
        return this.enableCamera;
    }

    public void setEnableCamera(boolean enableCamera) {
        this.enableCamera = enableCamera;
    }

    public boolean isEnableOrientation() {
        return this.enableOrientation;
    }

    public void setEnableOrientation(boolean enableOrientation) {
        this.enableOrientation = enableOrientation;
    }

    public String getProviderAuthorities() {
        return this.providerAuthorities;
    }

    public void setProviderAuthorities(String providerAuthorities) {
        this.providerAuthorities = providerAuthorities;
    }
}

