/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.views.SmoothCheckBox;
import java.io.File;
import java.util.ArrayList;

public class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder, Media> {
    private final Context context;
    private final RequestManager glide;
    private final boolean showCamera;
    private final FileAdapterListener mListener;
    private int imageSize;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private View.OnClickListener cameraOnClickListener;

    public PhotoGridAdapter(Context context, RequestManager requestManager, ArrayList<Media> medias, ArrayList<String> selectedPaths, boolean showCamera, FileAdapterListener photoGridAdapterListener) {
        super(medias, selectedPaths);
        this.context = context;
        this.glide = requestManager;
        this.showCamera = showCamera;
        this.mListener = photoGridAdapterListener;
        this.setColumnNumber(context, 3);
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_photo_layout, parent, false);
        return new PhotoViewHolder(itemView);
    }

    public int getItemViewType(int position) {
        if (this.showCamera) {
            return position == 0 ? 100 : 101;
        }
        return 101;
    }

    public void onBindViewHolder(final PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            final Media media = (Media)this.getItems().get(this.showCamera ? position - 1 : position);
            if (AndroidLifecycleUtils.canLoadImage(holder.imageView.getContext())) {
                this.glide.load(new File(media.getPath())).centerCrop().dontAnimate().thumbnail(0.5f).override(this.imageSize, this.imageSize).placeholder(R.drawable.image_placeholder).into(holder.imageView);
            }
            if (media.getMediaType() == 3) {
                holder.videoIcon.setVisibility(0);
            } else {
                holder.videoIcon.setVisibility(8);
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PhotoGridAdapter.this.onItemClicked(holder, media);
                }
            });
            holder.checkBox.setVisibility(8);
            holder.checkBox.setOnCheckedChangeListener(null);
            holder.checkBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PhotoGridAdapter.this.onItemClicked(holder, media);
                }
            });
            holder.checkBox.setChecked(this.isSelected(media));
            holder.selectBg.setVisibility(this.isSelected(media) ? 0 : 8);
            holder.checkBox.setVisibility(this.isSelected(media) ? 0 : 8);
            holder.checkBox.setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(){

                @Override
                public void onCheckedChanged(SmoothCheckBox checkBox, boolean isChecked) {
                    PhotoGridAdapter.this.toggleSelection(media);
                    holder.selectBg.setVisibility(isChecked ? 0 : 8);
                    if (isChecked) {
                        holder.checkBox.setVisibility(0);
                        PickerManager.getInstance().add(media.getPath(), 1);
                    } else {
                        holder.checkBox.setVisibility(8);
                        PickerManager.getInstance().remove(media.getPath(), 1);
                    }
                    if (PhotoGridAdapter.this.mListener != null) {
                        PhotoGridAdapter.this.mListener.onItemSelected();
                    }
                }
            });
        } else {
            holder.imageView.setImageResource(R.drawable.ic_camera);
            holder.checkBox.setVisibility(8);
            holder.itemView.setOnClickListener(this.cameraOnClickListener);
            holder.videoIcon.setVisibility(8);
        }
    }

    private void onItemClicked(PhotoViewHolder holder, Media media) {
        if (PickerManager.getInstance().getMaxCount() == 1) {
            PickerManager.getInstance().add(media.getPath(), 1);
            if (this.mListener != null) {
                this.mListener.onItemSelected();
            }
        } else if (holder.checkBox.isChecked() || PickerManager.getInstance().shouldAdd()) {
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
        }
    }

    private void setColumnNumber(Context context, int columnNum) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNum;
    }

    public int getItemCount() {
        if (this.showCamera) {
            return this.getItems().size() + 1;
        }
        return this.getItems().size();
    }

    public void setCameraListener(View.OnClickListener onClickListener) {
        this.cameraOnClickListener = onClickListener;
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        SmoothCheckBox checkBox;
        ImageView imageView;
        ImageView videoIcon;
        View selectBg;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
            this.imageView = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.videoIcon = (ImageView)itemView.findViewById(R.id.video_icon);
            this.selectBg = itemView.findViewById(R.id.transparent_bg);
        }
    }
}

