/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.cursors.loadercallbacks;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.cursors.PhotoDirectoryLoader;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.models.PhotoDirectory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PhotoDirLoaderCallbacks
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final int INDEX_ALL_PHOTOS = 0;
    private WeakReference<Context> context;
    private FileResultCallback<PhotoDirectory> resultCallback;

    public PhotoDirLoaderCallbacks(Context context, FileResultCallback<PhotoDirectory> resultCallback) {
        this.context = new WeakReference<Context>(context);
        this.resultCallback = resultCallback;
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        return new PhotoDirectoryLoader((Context)this.context.get(), args);
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (data == null) {
            return;
        }
        ArrayList<PhotoDirectory> directories = new ArrayList<PhotoDirectory>();
        while (data.moveToNext()) {
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String bucketId = data.getString(data.getColumnIndexOrThrow("bucket_id"));
            String name = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            String fileName = data.getString(data.getColumnIndexOrThrow("title"));
            int mediaType = data.getInt(data.getColumnIndexOrThrow("media_type"));
            PhotoDirectory photoDirectory = new PhotoDirectory();
            photoDirectory.setBucketId(bucketId);
            photoDirectory.setName(name);
            if (!directories.contains(photoDirectory)) {
                if (path.toLowerCase().endsWith("gif")) {
                    if (PickerManager.getInstance().isShowGif()) {
                        photoDirectory.addPhoto(imageId, fileName, path, mediaType);
                    }
                } else {
                    photoDirectory.addPhoto(imageId, fileName, path, mediaType);
                }
                photoDirectory.setDateAdded(data.getLong(data.getColumnIndexOrThrow("date_added")));
                directories.add(photoDirectory);
                continue;
            }
            ((PhotoDirectory)directories.get(directories.indexOf(photoDirectory))).addPhoto(imageId, fileName, path, mediaType);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResultCallback(directories);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }
}

