/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MediaDetailsActivity
extends AppCompatActivity
implements FileAdapterListener {
    private static final int SCROLL_THRESHOLD = 30;
    private RecyclerView recyclerView;
    private TextView emptyView;
    private RequestManager mGlideRequestManager;
    private PhotoGridAdapter photoGridAdapter;
    private int fileType;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(PickerManager.getInstance().getTheme());
        this.setContentView(R.layout.activity_media_details);
        if (!PickerManager.getInstance().isEnableOrientation()) {
            this.setRequestedOrientation(1);
        }
        this.initView();
    }

    private void initView() {
        this.mGlideRequestManager = Glide.with((FragmentActivity)this);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.fileType = intent.getIntExtra("EXTRA_FILE_TYPE", 1);
            PhotoDirectory photoDirectory = (PhotoDirectory)intent.getParcelableExtra(PhotoDirectory.class.getSimpleName());
            if (photoDirectory != null) {
                this.setUpView(photoDirectory);
                if (this.getSupportActionBar() != null) {
                    this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
                    this.getSupportActionBar().setTitle((CharSequence)photoDirectory.getName());
                }
            }
        }
    }

    private void setUpView(PhotoDirectory photoDirectory) {
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)this.findViewById(R.id.empty_view);
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(3, 1);
        layoutManager.setGapStrategy(2);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > 30) {
                    MediaDetailsActivity.this.mGlideRequestManager.pauseRequests();
                } else {
                    MediaDetailsActivity.this.resumeRequestsIfNotDestroyed();
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    MediaDetailsActivity.this.resumeRequestsIfNotDestroyed();
                }
            }
        });
        this.getDataFromMedia(photoDirectory.getBucketId());
    }

    private void getDataFromMedia(String bucketId) {
        Bundle mediaStoreArgs = new Bundle();
        mediaStoreArgs.putBoolean("SHOW_GIF", false);
        mediaStoreArgs.putString("EXTRA_BUCKET_ID", bucketId);
        mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
        if (this.fileType == 1) {
            MediaStoreHelper.getPhotoDirs((FragmentActivity)this, mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaDetailsActivity.this.updateList(dirs);
                }
            });
        } else if (this.fileType == 3) {
            MediaStoreHelper.getVideoDirs((FragmentActivity)this, mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaDetailsActivity.this.updateList(dirs);
                }
            });
        }
    }

    private void updateList(List<PhotoDirectory> dirs) {
        ArrayList<Media> medias = new ArrayList<Media>();
        for (int i = 0; i < dirs.size(); ++i) {
            medias.addAll(dirs.get(i).getMedias());
        }
        Collections.sort(medias, new Comparator<Media>(){

            @Override
            public int compare(Media a, Media b) {
                return b.getId() - a.getId();
            }
        });
        if (medias.size() <= 0) {
            this.emptyView.setVisibility(0);
            this.recyclerView.setVisibility(8);
            return;
        }
        this.emptyView.setVisibility(8);
        this.recyclerView.setVisibility(0);
        if (this.photoGridAdapter != null) {
            this.photoGridAdapter.setData(medias);
            this.photoGridAdapter.notifyDataSetChanged();
        } else {
            this.photoGridAdapter = new PhotoGridAdapter((Context)this, this.mGlideRequestManager, medias, PickerManager.getInstance().getSelectedPhotos(), false, this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
        }
    }

    private void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.canLoadImage((Activity)this)) {
            return;
        }
        this.mGlideRequestManager.resumeRequests();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.picker_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_done) {
            this.setResult(-1, null);
            this.finish();
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected() {
        if (PickerManager.getInstance().getMaxCount() == 1) {
            this.setResult(-1, null);
            this.finish();
        }
    }
}

