/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileListAdapter;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import java.util.List;

public class DocFragment
extends BaseFragment {
    private static final String TAG = DocFragment.class.getSimpleName();
    RecyclerView recyclerView;
    TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private FileListAdapter fileListAdapter;
    private FileType fileType;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_photo_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public static DocFragment newInstance(FileType fileType) {
        DocFragment photoPickerFragment = new DocFragment();
        Bundle bun = new Bundle();
        bun.putParcelable("FILE_TYPE", (Parcelable)fileType);
        photoPickerFragment.setArguments(bun);
        return photoPickerFragment;
    }

    public FileType getFileType() {
        return (FileType)this.getArguments().getParcelable("FILE_TYPE");
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.fileType = (FileType)this.getArguments().getParcelable("FILE_TYPE");
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.recyclerView.setVisibility(8);
    }

    public void updateList(List<Document> dirs) {
        if (this.getView() == null) {
            return;
        }
        if (dirs.size() > 0) {
            this.recyclerView.setVisibility(0);
            this.emptyView.setVisibility(8);
            FileListAdapter fileListAdapter = (FileListAdapter)this.recyclerView.getAdapter();
            if (fileListAdapter == null) {
                fileListAdapter = new FileListAdapter((Context)this.getActivity(), dirs, PickerManager.getInstance().getSelectedFiles());
                this.recyclerView.setAdapter((RecyclerView.Adapter)fileListAdapter);
            } else {
                fileListAdapter.setData(dirs);
                fileListAdapter.notifyDataSetChanged();
            }
        } else {
            this.recyclerView.setVisibility(8);
            this.emptyView.setVisibility(0);
        }
    }

    public static interface PhotoPickerFragmentListener {
    }
}

