/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import droidninja.filepicker.FilePickerActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.models.FileType;
import java.util.ArrayList;

public class FilePickerBuilder {
    private final Bundle mPickerOptionsBundle = new Bundle();

    public static FilePickerBuilder getInstance() {
        return new FilePickerBuilder();
    }

    public FilePickerBuilder setMaxCount(int maxCount) {
        PickerManager.getInstance().setMaxCount(maxCount);
        return this;
    }

    public FilePickerBuilder setActivityTheme(int theme) {
        PickerManager.getInstance().setTheme(theme);
        return this;
    }

    public FilePickerBuilder setSelectedFiles(ArrayList<String> selectedPhotos) {
        this.mPickerOptionsBundle.putStringArrayList("SELECTED_PHOTOS", selectedPhotos);
        return this;
    }

    public FilePickerBuilder addVideoPicker() {
        PickerManager.getInstance().setShowVideos(true);
        return this;
    }

    public FilePickerBuilder showGifs(boolean status) {
        PickerManager.getInstance().setShowGif(status);
        return this;
    }

    public FilePickerBuilder showFolderView(boolean status) {
        PickerManager.getInstance().setShowFolderView(status);
        return this;
    }

    public FilePickerBuilder enableDocSupport(boolean status) {
        PickerManager.getInstance().setDocSupport(status);
        return this;
    }

    public FilePickerBuilder enableCameraSupport(boolean status) {
        PickerManager.getInstance().setEnableCamera(status);
        return this;
    }

    public FilePickerBuilder enableOrientation(boolean status) {
        PickerManager.getInstance().setEnableOrientation(status);
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions, @DrawableRes int drawable2) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, drawable2));
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, 0));
        return this;
    }

    public void pickPhoto(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 17);
    }

    public void pickPhoto(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 17);
    }

    public void pickFile(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 18);
    }

    public void pickFile(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 18);
    }

    private void start(Activity context, int pickerType) {
        PickerManager.getInstance().setProviderAuthorities(context.getApplicationContext().getPackageName() + ".droidninja.filepicker.provider");
        Intent intent = new Intent((Context)context, FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        if (pickerType == 17) {
            context.startActivityForResult(intent, 233);
        } else {
            context.startActivityForResult(intent, 234);
        }
    }

    private void start(Fragment fragment, int pickerType) {
        PickerManager.getInstance().setProviderAuthorities(fragment.getContext().getApplicationContext().getPackageName() + ".droidninja.filepicker.provider");
        Intent intent = new Intent((Context)fragment.getActivity(), FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        if (pickerType == 17) {
            fragment.startActivityForResult(intent, 233);
        } else {
            fragment.startActivityForResult(intent, 234);
        }
    }
}

