/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.cursors;

import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.provider.MediaStore;
import android.text.TextUtils;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DocScannerTask
extends AsyncTask<Void, Void, List<Document>> {
    final String[] DOC_PROJECTION = new String[]{"_id", "_data", "mime_type", "_size", "date_added", "title"};
    private final FileResultCallback<Document> resultCallback;
    private final Context context;

    public DocScannerTask(Context context, FileResultCallback<Document> fileResultCallback) {
        this.context = context;
        this.resultCallback = fileResultCallback;
    }

    protected List<Document> doInBackground(Void ... voids) {
        ArrayList<Document> documents = new ArrayList<Document>();
        String[] projection = this.DOC_PROJECTION;
        String selection = "media_type=0";
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selection, null, "date_added DESC");
        if (cursor != null) {
            documents = this.getDocumentFromCursor(cursor);
            cursor.close();
        }
        return documents;
    }

    protected void onPostExecute(List<Document> documents) {
        super.onPostExecute(documents);
        if (this.resultCallback != null) {
            this.resultCallback.onResultCallback(documents);
        }
    }

    private ArrayList<Document> getDocumentFromCursor(Cursor data) {
        ArrayList<Document> documents = new ArrayList<Document>();
        while (data.moveToNext()) {
            FileType fileType;
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            String title = data.getString(data.getColumnIndexOrThrow("title"));
            if (path == null || (fileType = this.getFileType(PickerManager.getInstance().getFileTypes(), path)) == null || new File(path).isDirectory()) continue;
            Document document = new Document(imageId, title, path);
            document.setFileType(fileType);
            String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
            if (mimeType != null && !TextUtils.isEmpty((CharSequence)mimeType)) {
                document.setMimeType(mimeType);
            } else {
                document.setMimeType("");
            }
            document.setSize(data.getString(data.getColumnIndexOrThrow("_size")));
            if (documents.contains(document)) continue;
            documents.add(document);
        }
        return documents;
    }

    private FileType getFileType(ArrayList<FileType> types, String path) {
        for (int index = 0; index < types.size(); ++index) {
            for (String string : types.get((int)index).extensions) {
                if (!path.endsWith(string)) continue;
                return types.get(index);
            }
        }
        return null;
    }
}

