/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.PickerManagerListener;
import droidninja.filepicker.R;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.fragments.DocPickerFragment;
import droidninja.filepicker.fragments.MediaDetailPickerFragment;
import droidninja.filepicker.fragments.MediaFolderPickerFragment;
import droidninja.filepicker.fragments.MediaPickerFragment;
import droidninja.filepicker.utils.FragmentUtil;
import java.util.ArrayList;

public class FilePickerActivity
extends AppCompatActivity
implements MediaDetailPickerFragment.PhotoPickerFragmentListener,
DocFragment.PhotoPickerFragmentListener,
MediaFolderPickerFragment.PhotoPickerFragmentListener,
MediaPickerFragment.MediaPickerFragmentListener,
PickerManagerListener {
    private static final String TAG = FilePickerActivity.class.getSimpleName();
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(PickerManager.getInstance().getTheme());
        this.setContentView(R.layout.activity_file_picker);
        if (!PickerManager.getInstance().isEnableOrientation()) {
            this.setRequestedOrientation(1);
        }
        this.initView();
    }

    private void initView() {
        Intent intent = this.getIntent();
        if (intent != null) {
            if (this.getSupportActionBar() != null) {
                this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            }
            ArrayList selectedPaths = intent.getStringArrayListExtra("SELECTED_PHOTOS");
            this.type = intent.getIntExtra("EXTRA_PICKER_TYPE", 17);
            this.setToolbarTitle(0);
            if (this.type == 17) {
                PickerManager.getInstance().add(selectedPaths, 1);
            } else {
                PickerManager.getInstance().add(selectedPaths, 2);
            }
            PickerManager.getInstance().setPickerManagerListener(this);
            this.openSpecificFragment(this.type, selectedPaths);
        }
    }

    private void openSpecificFragment(int type, ArrayList<String> selectedPaths) {
        if (PickerManager.getInstance().getMaxCount() == 1) {
            selectedPaths.clear();
        }
        if (type == 17) {
            MediaPickerFragment photoFragment = MediaPickerFragment.newInstance();
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        } else {
            if (PickerManager.getInstance().isDocSupport()) {
                PickerManager.getInstance().addDocTypes();
            }
            DocPickerFragment photoFragment = DocPickerFragment.newInstance(selectedPaths);
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        }
    }

    private void setToolbarTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            if (PickerManager.getInstance().getMaxCount() > 1) {
                actionBar.setTitle((CharSequence)String.format(this.getString(R.string.attachments_title_text), count, PickerManager.getInstance().getMaxCount()));
            } else if (this.type == 17) {
                actionBar.setTitle(R.string.select_photo_text);
            } else {
                actionBar.setTitle(R.string.select_doc_text);
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.picker_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_done) {
            if (this.type == 17) {
                this.returnData(PickerManager.getInstance().getSelectedPhotos());
            } else {
                this.returnData(PickerManager.getInstance().getSelectedFiles());
            }
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected(int currentCount) {
        this.setToolbarTitle(currentCount);
    }

    @Override
    public void onSingleItemSelected(ArrayList<String> paths) {
        this.returnData(paths);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 235: {
                if (resultCode != -1) break;
                if (this.type == 17) {
                    this.returnData(PickerManager.getInstance().getSelectedPhotos());
                    break;
                }
                this.returnData(PickerManager.getInstance().getSelectedFiles());
            }
        }
    }

    private void returnData(ArrayList<String> paths) {
        Intent intent = new Intent();
        if (this.type == 17) {
            intent.putStringArrayListExtra("SELECTED_PHOTOS", paths);
        } else {
            intent.putStringArrayListExtra("SELECTED_DOCS", paths);
        }
        this.setResult(-1, intent);
        this.finish();
    }
}

