/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.models;

import android.text.TextUtils;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.utils.Utils;
import java.io.File;

public class Document
extends BaseFile {
    private String mimeType;
    private String size;

    public Document(int id2, String title, String path) {
        super(id2, title, path);
    }

    public Document() {
        super(0, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.id == document.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id2) {
        this.id = id2;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getTitle() {
        return new File(this.path).getName();
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public int getTypeDrawable() {
        if (this.getFileType() == FilePickerConst.FILE_TYPE.EXCEL) {
            return R.drawable.ic_excel;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.WORD) {
            return R.drawable.ic_word;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.PPT) {
            return R.drawable.ic_ppt;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.PDF) {
            return R.drawable.ic_pdf;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.TXT) {
            return R.drawable.ic_txt;
        }
        return R.drawable.ic_txt;
    }

    public boolean isThisType(FilePickerConst.FILE_TYPE type) {
        return this.getFileType() == type;
    }

    public FilePickerConst.FILE_TYPE getFileType() {
        String fileExtension = Utils.getFileExtension(new File(this.path));
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return FilePickerConst.FILE_TYPE.UNKNOWN;
        }
        if (this.isExcelFile()) {
            return FilePickerConst.FILE_TYPE.EXCEL;
        }
        if (this.isDocFile()) {
            return FilePickerConst.FILE_TYPE.WORD;
        }
        if (this.isPPTFile()) {
            return FilePickerConst.FILE_TYPE.PPT;
        }
        if (this.isPDFFile()) {
            return FilePickerConst.FILE_TYPE.PDF;
        }
        if (this.isTxtFile()) {
            return FilePickerConst.FILE_TYPE.TXT;
        }
        return FilePickerConst.FILE_TYPE.UNKNOWN;
    }

    public boolean isExcelFile() {
        String[] types = new String[]{"xls", "xlsx"};
        return Utils.contains(types, this.path);
    }

    public boolean isDocFile() {
        String[] types = new String[]{"doc", "docx", "dot", "dotx"};
        return Utils.contains(types, this.path);
    }

    public boolean isPPTFile() {
        String[] types = new String[]{"ppt", "pptx"};
        return Utils.contains(types, this.path);
    }

    public boolean isPDFFile() {
        String[] types = new String[]{"pdf"};
        return Utils.contains(types, this.path);
    }

    public boolean isTxtFile() {
        String[] types = new String[]{"txt"};
        return Utils.contains(types, this.path);
    }
}

