/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.facebook.drawee.view.DraweeView;
import com.facebook.drawee.view.SimpleDraweeView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.Photo;
import droidninja.filepicker.utils.image.FrescoFactory;
import droidninja.filepicker.utils.image.FrescoLoader;
import droidninja.filepicker.views.SmoothCheckBox;
import java.io.File;
import java.util.ArrayList;

public class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder, Photo> {
    private final Context context;
    private int imageSize;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private View.OnClickListener cameraOnClickListener;

    public PhotoGridAdapter(Context context, ArrayList<Photo> photos, ArrayList<String> selectedPaths) {
        super(photos, selectedPaths);
        this.context = context;
        this.setColumnNumber(context, 3);
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_photo_layout, parent, false);
        return new PhotoViewHolder(itemView);
    }

    public int getItemViewType(int position) {
        return position == 0 ? 100 : 101;
    }

    public void onBindViewHolder(final PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            final Photo photo = (Photo)this.getItems().get(position - 1);
            FrescoFactory.getLoader().showImage((DraweeView)holder.imageView, Uri.fromFile((File)new File(photo.getPath())), FrescoFactory.newOption(this.imageSize, this.imageSize));
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PickerManager.getInstance().getMaxCount() == 1) {
                        PickerManager.getInstance().add(photo);
                    } else if (holder.checkBox.isChecked() || PickerManager.getInstance().shouldAdd()) {
                        holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
                    }
                }
            });
            holder.checkBox.setVisibility(8);
            holder.checkBox.setOnCheckedChangeListener(null);
            holder.checkBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (holder.checkBox.isChecked() || PickerManager.getInstance().shouldAdd()) {
                        holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
                    }
                }
            });
            holder.checkBox.setChecked(this.isSelected(photo));
            holder.selectBg.setVisibility(this.isSelected(photo) ? 0 : 8);
            holder.checkBox.setVisibility(this.isSelected(photo) ? 0 : 8);
            holder.checkBox.setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(){

                @Override
                public void onCheckedChanged(SmoothCheckBox checkBox, boolean isChecked) {
                    PhotoGridAdapter.this.toggleSelection(photo);
                    holder.selectBg.setVisibility(isChecked ? 0 : 8);
                    if (isChecked) {
                        holder.checkBox.setVisibility(0);
                        PickerManager.getInstance().add(photo);
                    } else {
                        holder.checkBox.setVisibility(8);
                        PickerManager.getInstance().remove(photo);
                    }
                }
            });
        } else {
            FrescoFactory.getLoader().showImage((DraweeView)holder.imageView, R.drawable.ic_camera, (FrescoLoader.FrescoOption)null);
            holder.checkBox.setVisibility(8);
            holder.itemView.setOnClickListener(this.cameraOnClickListener);
        }
    }

    private void setColumnNumber(Context context, int columnNum) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNum;
    }

    public int getItemCount() {
        return this.getItems().size() + 1;
    }

    public void setCameraListener(View.OnClickListener onClickListener) {
        this.cameraOnClickListener = onClickListener;
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        SmoothCheckBox checkBox;
        SimpleDraweeView imageView;
        View selectBg;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
            this.imageView = (SimpleDraweeView)itemView.findViewById(R.id.iv_photo);
            this.selectBg = itemView.findViewById(R.id.transparent_bg);
        }
    }
}

