/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.format.Formatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.views.SmoothCheckBox;
import java.util.List;

public class FileListAdapter
extends SelectableAdapter<FileViewHolder, Document> {
    private final Context context;

    public FileListAdapter(Context context, List<Document> items, List<String> selectedPaths) {
        super(items, selectedPaths);
        this.context = context;
    }

    public FileViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_doc_layout, parent, false);
        return new FileViewHolder(itemView);
    }

    public void onBindViewHolder(final FileViewHolder holder, int position) {
        final Document document = (Document)this.getItems().get(position);
        holder.imageView.setImageResource(document.getTypeDrawable());
        holder.fileNameTextView.setText((CharSequence)document.getTitle());
        holder.fileSizeTextView.setText((CharSequence)Formatter.formatShortFileSize((Context)this.context, (long)Long.parseLong(document.getSize())));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PickerManager.getInstance().getMaxCount() == 1) {
                    PickerManager.getInstance().add(document);
                } else {
                    FileListAdapter.this.onItemClicked(document, holder);
                }
            }
        });
        holder.checkBox.setOnCheckedChangeListener(null);
        holder.checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FileListAdapter.this.onItemClicked(document, holder);
            }
        });
        holder.checkBox.setChecked(this.isSelected(document));
        holder.itemView.setBackgroundResource(this.isSelected(document) ? R.color.bg_gray : 17170443);
        holder.checkBox.setVisibility(this.isSelected(document) ? 0 : 8);
        holder.checkBox.setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(){

            @Override
            public void onCheckedChanged(SmoothCheckBox checkBox, boolean isChecked) {
                FileListAdapter.this.toggleSelection(document);
                holder.itemView.setBackgroundResource(isChecked ? R.color.bg_gray : 17170443);
            }
        });
    }

    private void onItemClicked(Document document, FileViewHolder holder) {
        if (holder.checkBox.isChecked() || PickerManager.getInstance().shouldAdd()) {
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
        }
        if (holder.checkBox.isChecked()) {
            holder.checkBox.setVisibility(0);
            PickerManager.getInstance().add(document);
        } else {
            holder.checkBox.setVisibility(8);
            PickerManager.getInstance().remove(document);
        }
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public static class FileViewHolder
    extends RecyclerView.ViewHolder {
        SmoothCheckBox checkBox;
        ImageView imageView;
        TextView fileNameTextView;
        TextView fileSizeTextView;

        public FileViewHolder(View itemView) {
            super(itemView);
            this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
            this.imageView = (ImageView)itemView.findViewById(R.id.file_iv);
            this.fileNameTextView = (TextView)itemView.findViewById(R.id.file_name_tv);
            this.fileSizeTextView = (TextView)itemView.findViewById(R.id.file_size_tv);
        }
    }
}

