/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import droidninja.filepicker.PickerManagerListener;
import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import java.util.ArrayList;

public class PickerManager {
    private static PickerManager ourInstance = new PickerManager();
    private int maxCount = 9;
    private int currentCount;
    private PickerManagerListener pickerManagerListener;
    private ArrayList<String> alreadySelectedFiles;
    private ArrayList<BaseFile> imageFiles;
    private ArrayList<BaseFile> docFiles;
    private int theme = R.style.AppTheme;

    public static PickerManager getInstance() {
        return ourInstance;
    }

    private PickerManager() {
        this.imageFiles = new ArrayList();
        this.docFiles = new ArrayList();
    }

    public void setMaxCount(int count) {
        this.clearSelections();
        this.maxCount = count;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setPickerManagerListener(PickerManagerListener pickerManagerListener) {
        this.pickerManagerListener = pickerManagerListener;
    }

    public void add(BaseFile file) {
        if (file != null && this.shouldAdd()) {
            if (file.isImage() && !this.imageFiles.contains(file)) {
                this.imageFiles.add(file);
            } else {
                this.docFiles.add(file);
            }
            ++this.currentCount;
            if (this.pickerManagerListener != null) {
                this.pickerManagerListener.onItemSelected(this.currentCount);
                if (this.maxCount == 1) {
                    this.pickerManagerListener.onSingleItemSelected(file.isImage() ? this.getSelectedPhotos() : this.getSelectedFiles());
                }
            }
        }
    }

    public void remove(BaseFile file) {
        if (file.isImage() && this.imageFiles.contains(file)) {
            this.imageFiles.remove(file);
            --this.currentCount;
        } else if (this.docFiles.contains(file)) {
            this.docFiles.remove(file);
            --this.currentCount;
        }
        if (this.pickerManagerListener != null) {
            this.pickerManagerListener.onItemSelected(this.currentCount);
        }
    }

    public boolean shouldAdd() {
        return this.currentCount < this.maxCount;
    }

    public ArrayList<String> getSelectedPhotos() {
        return this.getSelectedFilePaths(this.imageFiles);
    }

    public ArrayList<String> getSelectedFiles() {
        return this.getSelectedFilePaths(this.docFiles);
    }

    public ArrayList<String> getSelectedFilePaths(ArrayList<BaseFile> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (int index = 0; index < files.size(); ++index) {
            paths.add(files.get(index).getPath());
        }
        return paths;
    }

    public void clearSelections() {
        this.docFiles.clear();
        this.imageFiles.clear();
        this.currentCount = 0;
        this.maxCount = 0;
    }

    public int getTheme() {
        return this.theme;
    }

    public void setTheme(int theme) {
        this.theme = theme;
    }
}

