/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import com.android.internal.util.Predicate;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SectionsPagerAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.utils.MediaStoreHelper;
import droidninja.filepicker.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DocPickerFragment
extends BaseFragment {
    private static final String TAG = DocPickerFragment.class.getSimpleName();
    public static final String PDF_FRAGMENT = "PDF";
    public static final String PPT_FRAGMENT = "PPT";
    public static final String WORD_FRAGMENT = "DOC";
    public static final String EXCEL_FRAGMENT = "XLS";
    public static final String TXT_FRAGMENT = "TXT";
    TabLayout tabLayout;
    ViewPager viewPager;
    private ArrayList<String> selectedPaths;
    private ProgressBar progressBar;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_doc_picker, container, false);
    }

    public static DocPickerFragment newInstance(ArrayList<String> selectedPaths) {
        DocPickerFragment docPickerFragment = new DocPickerFragment();
        docPickerFragment.selectedPaths = selectedPaths;
        return docPickerFragment;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setViews(view);
        this.initView();
    }

    private void initView() {
        this.setUpViewPager();
        this.setData();
    }

    private void setViews(View view) {
        this.tabLayout = (TabLayout)view.findViewById(R.id.tabs);
        this.viewPager = (ViewPager)view.findViewById(R.id.viewPager);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
    }

    private void setData() {
        MediaStoreHelper.getDocs(this.getActivity(), new FileResultCallback<Document>(){

            @Override
            public void onResultCallback(List<Document> files) {
                DocPickerFragment.this.progressBar.setVisibility(8);
                DocPickerFragment.this.setDataOnFragments(files);
            }
        });
    }

    private void setDataOnFragments(List<Document> files) {
        SectionsPagerAdapter sectionsPagerAdapter = (SectionsPagerAdapter)this.viewPager.getAdapter();
        if (sectionsPagerAdapter != null) {
            for (int index = 0; index < sectionsPagerAdapter.getCount(); ++index) {
                DocFragment docFragment = (DocFragment)sectionsPagerAdapter.getItem(index);
                if (docFragment == null) continue;
                if (index == 0) {
                    docFragment.updateList(this.filterDocuments(FilePickerConst.FILE_TYPE.PDF, files));
                    continue;
                }
                if (index == 1) {
                    docFragment.updateList(this.filterDocuments(FilePickerConst.FILE_TYPE.PPT, files));
                    continue;
                }
                if (index == 2) {
                    docFragment.updateList(this.filterDocuments(FilePickerConst.FILE_TYPE.WORD, files));
                    continue;
                }
                if (index == 3) {
                    docFragment.updateList(this.filterDocuments(FilePickerConst.FILE_TYPE.EXCEL, files));
                    continue;
                }
                if (index != 4) continue;
                docFragment.updateList(this.filterDocuments(FilePickerConst.FILE_TYPE.TXT, files));
            }
        }
    }

    private void setUpViewPager() {
        SectionsPagerAdapter adapter = new SectionsPagerAdapter(this.getChildFragmentManager());
        adapter.addFragment(DocFragment.newInstance(this.selectedPaths), PDF_FRAGMENT);
        adapter.addFragment(DocFragment.newInstance(this.selectedPaths), PPT_FRAGMENT);
        adapter.addFragment(DocFragment.newInstance(this.selectedPaths), WORD_FRAGMENT);
        adapter.addFragment(DocFragment.newInstance(this.selectedPaths), EXCEL_FRAGMENT);
        adapter.addFragment(DocFragment.newInstance(this.selectedPaths), TXT_FRAGMENT);
        this.viewPager.setOffscreenPageLimit(5);
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.tabLayout.setupWithViewPager(this.viewPager);
    }

    private ArrayList<Document> filterDocuments(final FilePickerConst.FILE_TYPE type, List<Document> documents) {
        Predicate<Document> docType = new Predicate<Document>(){

            public boolean apply(Document document) {
                return document.isThisType(type);
            }
        };
        return new ArrayList<Document>(Utils.filter(new HashSet<Document>(documents), docType));
    }
}

