/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import droidninja.filepicker.FilePickerActivity;
import droidninja.filepicker.PickerManager;
import java.util.ArrayList;

public class FilePickerBuilder {
    private final Bundle mPickerOptionsBundle = new Bundle();

    public static FilePickerBuilder getInstance() {
        return new FilePickerBuilder();
    }

    public FilePickerBuilder setMaxCount(int maxCount) {
        PickerManager.getInstance().setMaxCount(maxCount);
        return this;
    }

    public FilePickerBuilder setActivityTheme(int theme) {
        PickerManager.getInstance().setTheme(theme);
        return this;
    }

    public FilePickerBuilder setSelectedFiles(ArrayList<String> selectedPhotos) {
        this.mPickerOptionsBundle.putStringArrayList("SELECTED_PHOTOS", selectedPhotos);
        return this;
    }

    public void pickPhoto(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context);
    }

    public void pickPhoto(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context);
    }

    public void pickDocument(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context);
    }

    public void pickDocument(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context);
    }

    private void start(Activity context) {
        Intent intent = new Intent((Context)context, FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        context.startActivityForResult(intent, 233);
    }

    private void start(Fragment fragment) {
        Intent intent = new Intent((Context)fragment.getActivity(), FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        fragment.startActivityForResult(intent, 233);
    }
}

