/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.cursors;

import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.provider.MediaStore;
import android.text.TextUtils;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.models.Document;
import java.util.ArrayList;
import java.util.List;

public class DocScannerTask
extends AsyncTask<Void, Void, List<Document>> {
    final String[] DOC_PROJECTION = new String[]{"_id", "_data", "mime_type", "_size", "date_added", "title"};
    private final FileResultCallback<Document> resultCallback;
    String[] selectionArgs = new String[]{".pdf", ".ppt", ".pptx", ".xlsx", ".xls", ".doc", ".docx", ".txt"};
    private final Context context;

    public DocScannerTask(Context context, FileResultCallback<Document> fileResultCallback) {
        this.context = context;
        this.resultCallback = fileResultCallback;
    }

    protected List<Document> doInBackground(Void ... voids) {
        ArrayList<Document> documents = new ArrayList<Document>();
        String[] projection = this.DOC_PROJECTION;
        Cursor cursor = this.context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, null, null, "date_added DESC");
        if (cursor != null) {
            documents = this.getDocumentFromCursor(cursor);
            cursor.close();
        }
        return documents;
    }

    protected void onPostExecute(List<Document> documents) {
        super.onPostExecute(documents);
        if (this.resultCallback != null) {
            this.resultCallback.onResultCallback(documents);
        }
    }

    private ArrayList<Document> getDocumentFromCursor(Cursor data) {
        ArrayList<Document> documents = new ArrayList<Document>();
        while (data.moveToNext()) {
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            String title = data.getString(data.getColumnIndexOrThrow("title"));
            if (path == null || !this.contains(this.selectionArgs, path)) continue;
            Document document = new Document(imageId, title, path);
            String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
            if (mimeType != null && !TextUtils.isEmpty((CharSequence)mimeType)) {
                document.setMimeType(mimeType);
            } else {
                document.setMimeType("");
            }
            document.setSize(data.getString(data.getColumnIndexOrThrow("_size")));
            if (documents.contains(document)) continue;
            documents.add(document);
        }
        return documents;
    }

    boolean contains(String[] types, String path) {
        for (String string : types) {
            if (!path.endsWith(string)) continue;
            return true;
        }
        return false;
    }
}

