/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import droidninja.filepicker.PickerManagerListener;
import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import java.util.ArrayList;

public class PickerManager {
    private static PickerManager ourInstance = new PickerManager();
    private int maxCount = 9;
    private int currentCount;
    private PickerManagerListener pickerManagerListener;
    private ArrayList<String> alreadySelectedFiles;
    private ArrayList<BaseFile> files;
    private int theme = R.style.AppTheme;

    public static PickerManager getInstance() {
        return ourInstance;
    }

    private PickerManager() {
        this.files = new ArrayList();
    }

    public void setMaxCount(int count) {
        this.clearSelections();
        this.maxCount = count;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setPickerManagerListener(PickerManagerListener pickerManagerListener) {
        this.pickerManagerListener = pickerManagerListener;
    }

    public void add(BaseFile file) {
        if (file != null && this.shouldAdd() && !this.files.contains(file)) {
            this.files.add(file);
            ++this.currentCount;
            if (this.pickerManagerListener != null) {
                this.pickerManagerListener.onItemSelected(this.currentCount);
            }
        }
    }

    public void remove(BaseFile file) {
        if (this.files.contains(file)) {
            this.files.remove(file);
            --this.currentCount;
            if (this.pickerManagerListener != null) {
                this.pickerManagerListener.onItemSelected(this.currentCount);
            }
        }
    }

    public boolean shouldAdd() {
        return this.currentCount < this.maxCount;
    }

    public ArrayList<BaseFile> getSelectedFiles() {
        return this.files;
    }

    public ArrayList<String> getSelectedFilePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (int index = 0; index < this.files.size(); ++index) {
            paths.add(this.files.get(index).getPath());
        }
        return paths;
    }

    public void clearSelections() {
        this.files.clear();
        this.currentCount = 0;
        this.maxCount = 0;
    }

    public int getTheme() {
        return this.theme;
    }

    public void setTheme(int theme) {
        this.theme = theme;
    }
}

