/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.PickerManagerListener;
import droidninja.filepicker.R;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.fragments.DocPickerFragment;
import droidninja.filepicker.fragments.PhotoPickerFragment;
import droidninja.filepicker.utils.FragmentUtil;
import java.util.ArrayList;

public class FilePickerActivity
extends AppCompatActivity
implements PhotoPickerFragment.PhotoPickerFragmentListener,
DocFragment.PhotoPickerFragmentListener,
PickerManagerListener {
    private static final String TAG = FilePickerActivity.class.getSimpleName();
    private int type;

    protected void onCreate(Bundle savedInstanceState) {
        this.setTheme(PickerManager.getInstance().getTheme());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_file_picker);
        if (savedInstanceState == null) {
            this.initView();
        }
    }

    private void initView() {
        Intent intent = this.getIntent();
        if (intent != null) {
            this.setUpToolbar();
            ArrayList selectedPaths = intent.getStringArrayListExtra("SELECTED_PHOTOS");
            this.type = intent.getIntExtra("EXTRA_PICKER_TYPE", 17);
            this.setToolbarTitle(0);
            PickerManager.getInstance().setPickerManagerListener(this);
            this.openSpecificFragment(this.type, selectedPaths);
        }
    }

    private void setUpToolbar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    private void openSpecificFragment(int type, ArrayList<String> selectedPaths) {
        if (type == 17) {
            PhotoPickerFragment photoFragment = PhotoPickerFragment.newInstance(selectedPaths);
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        } else {
            DocPickerFragment photoFragment = DocPickerFragment.newInstance(selectedPaths);
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        }
    }

    private void setToolbarTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            if (count > 0) {
                actionBar.setTitle((CharSequence)("Attachments (" + count + "/" + PickerManager.getInstance().getMaxCount() + ")"));
            } else if (this.type == 17) {
                actionBar.setTitle((CharSequence)"Select a photo");
            } else {
                actionBar.setTitle((CharSequence)"Select a document");
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.picker_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_done) {
            Intent intent = new Intent();
            intent.putStringArrayListExtra("SELECTED_PHOTOS", PickerManager.getInstance().getSelectedFilePaths());
            this.setResult(-1, intent);
            this.finish();
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected(int currentCount) {
        this.setToolbarTitle(currentCount);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
        this.finish();
    }
}

