/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.DraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import droidninja.filepicker.utils.image.BaseImageLoader;
import droidninja.filepicker.utils.image.ImageLoaderWrapper;
import java.util.concurrent.Executor;

public class FrescoLoader
extends BaseImageLoader<DraweeView, FrescoOption> {
    @Override
    public FrescoOption newOption(int width, int height) {
        FrescoOption option = new FrescoOption();
        option.setResizeOptions(new ResizeOptions(width, height));
        return option;
    }

    private ImageRequestBuilder getBuilder(Uri uri) {
        return ImageRequestBuilder.newBuilderWithSource((Uri)uri);
    }

    private ImageRequestBuilder getBuilder(@DrawableRes int id2) {
        return ImageRequestBuilder.newBuilderWithResourceId((int)id2);
    }

    public void showImage(DraweeView imageView, ImageRequestBuilder tBuilder, FrescoOption option) {
        ImageRequestBuilder builder = tBuilder;
        if (option != null && option.getResizeOptions() != null) {
            builder.setResizeOptions(option.getResizeOptions());
        }
        ImageRequest request = builder.build();
        AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)request)).setOldController(imageView.getController())).setAutoPlayAnimations(true)).build();
        imageView.setController((DraweeController)controller);
    }

    @Override
    public void showImage(DraweeView imageView, Uri uri, @Nullable FrescoOption option) {
        if (uri.equals((Object)Uri.EMPTY)) {
            imageView.setImageURI(null);
        } else {
            this.showImage(imageView, this.getBuilder(uri), option);
        }
    }

    @Override
    public void showImage(DraweeView imageView, @DrawableRes int id2, @Nullable FrescoOption option) {
        this.showImage(imageView, this.getBuilder(id2), option);
    }

    public static void requestImage(Context context, Uri uri, final float currentPos, final RequestCallback callback) {
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setProgressiveRenderingEnabled(true).build();
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, (Object)context);
        dataSource.subscribe((DataSubscriber)new BaseBitmapDataSubscriber(){

            public void onNewResultImpl(@Nullable Bitmap bitmap) {
                callback.onSuccessed(bitmap, currentPos);
            }

            public void onFailureImpl(DataSource dataSource) {
            }
        }, (Executor)CallerThreadExecutor.getInstance());
    }

    public static interface RequestCallback {
        public void onSuccessed(Bitmap var1, float var2);
    }

    public static class FrescoOption
    implements ImageLoaderWrapper.ImageOption {
        private ResizeOptions mResizeOptions;

        public ResizeOptions getResizeOptions() {
            return this.mResizeOptions;
        }

        public void setResizeOptions(ResizeOptions resizeOptions) {
            this.mResizeOptions = resizeOptions;
        }
    }
}

