/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.models;

import android.webkit.MimeTypeMap;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;

public class Document
extends BaseFile {
    private String mimeType;
    private String size;

    public Document(int id2, String title, String path) {
        super(id2, title, path);
    }

    public Document() {
        super(0, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.id == document.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id2) {
        this.id = id2;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getTitle() {
        return this.name;
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public int getTypeDrawable() {
        if (this.getFileType() == FilePickerConst.FILE_TYPE.EXCEL) {
            return R.drawable.ic_xls;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.WORD) {
            return R.drawable.ic_doc;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.PPT) {
            return R.drawable.icon_ppt;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.PDF) {
            return R.drawable.ic_pdf;
        }
        if (this.getFileType() == FilePickerConst.FILE_TYPE.TXT) {
            return R.drawable.ic_txt;
        }
        return R.drawable.ic_doc;
    }

    public boolean isThisType(FilePickerConst.FILE_TYPE type) {
        return this.getFileType() == type;
    }

    public FilePickerConst.FILE_TYPE getFileType() {
        if (this.mimeType == null) {
            return FilePickerConst.FILE_TYPE.UNKNOWN;
        }
        if (this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("xls")) || this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("xlsx"))) {
            return FilePickerConst.FILE_TYPE.EXCEL;
        }
        if (this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("doc")) || this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("docx")) || this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("dot")) || this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("dotx"))) {
            return FilePickerConst.FILE_TYPE.WORD;
        }
        if (this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("ppt")) || this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("pptx")) || this.mimeType.equals("application/mspowerpoint")) {
            return FilePickerConst.FILE_TYPE.PPT;
        }
        if (this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("pdf"))) {
            return FilePickerConst.FILE_TYPE.PDF;
        }
        if (this.mimeType.equals(MimeTypeMap.getSingleton().getMimeTypeFromExtension("txt"))) {
            return FilePickerConst.FILE_TYPE.TXT;
        }
        return FilePickerConst.FILE_TYPE.UNKNOWN;
    }
}

