/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileListAdapter;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.models.Document;
import java.util.ArrayList;
import java.util.List;

public class DocFragment
extends BaseFragment {
    private static final String TAG = DocFragment.class.getSimpleName();
    RecyclerView recyclerView;
    TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private FileListAdapter fileListAdapter;
    private ArrayList<String> selectedPaths;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    protected int getFragmentLayout() {
        return R.layout.fragment_photo_picker;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static DocFragment newInstance(ArrayList<String> selectedPaths) {
        DocFragment photoPickerFragment = new DocFragment();
        photoPickerFragment.selectedPaths = selectedPaths;
        return photoPickerFragment;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setView(view);
        this.initView();
    }

    private void setView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
    }

    private void initView() {
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.recyclerView.setVisibility(8);
    }

    public void updateList(List<Document> dirs) {
        if (this.getView() == null) {
            return;
        }
        if (dirs.size() > 0) {
            this.recyclerView.setVisibility(0);
            this.emptyView.setVisibility(8);
            FileListAdapter fileListAdapter = (FileListAdapter)this.recyclerView.getAdapter();
            if (fileListAdapter == null) {
                fileListAdapter = new FileListAdapter((Context)this.getActivity(), dirs, this.selectedPaths);
                this.recyclerView.setAdapter((RecyclerView.Adapter)fileListAdapter);
            } else {
                fileListAdapter.setData(dirs);
                fileListAdapter.notifyDataSetChanged();
            }
        } else {
            this.recyclerView.setVisibility(8);
            this.emptyView.setVisibility(0);
        }
    }

    public static interface PhotoPickerFragmentListener {
    }
}

