/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.models.Photo;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.ImageCaptureManager;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PhotoPickerFragment
extends BaseFragment {
    private static final String TAG = PhotoPickerFragment.class.getSimpleName();
    RecyclerView recyclerView;
    TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private PhotoGridAdapter photoGridAdapter;
    private ArrayList<String> selectedPaths;
    private ImageCaptureManager imageCaptureManager;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    protected int getFragmentLayout() {
        return R.layout.fragment_photo_picker;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static PhotoPickerFragment newInstance(ArrayList<String> selectedPaths) {
        PhotoPickerFragment photoPickerFragment = new PhotoPickerFragment();
        photoPickerFragment.selectedPaths = selectedPaths;
        return photoPickerFragment;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setViews(view);
        this.initView();
    }

    private void setViews(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
    }

    private void initView() {
        this.imageCaptureManager = new ImageCaptureManager((Context)this.getActivity());
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(3, 1);
        layoutManager.setGapStrategy(2);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.getDataFromMedia();
    }

    private void getDataFromMedia() {
        Bundle mediaStoreArgs = new Bundle();
        mediaStoreArgs.putBoolean("SHOW_GIF", false);
        MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

            @Override
            public void onResultCallback(List<PhotoDirectory> dirs) {
                PhotoPickerFragment.this.updateList(dirs);
            }
        });
    }

    private void updateList(List<PhotoDirectory> dirs) {
        ArrayList<Photo> photos = new ArrayList<Photo>();
        for (int i = 0; i < dirs.size(); ++i) {
            photos.addAll(dirs.get(i).getPhotos());
        }
        if (photos.size() > 0) {
            this.emptyView.setVisibility(8);
        } else {
            this.emptyView.setVisibility(0);
        }
        if (this.photoGridAdapter != null) {
            this.photoGridAdapter.setData(photos);
            this.photoGridAdapter.notifyDataSetChanged();
        } else {
            this.photoGridAdapter = new PhotoGridAdapter((Context)this.getActivity(), photos, this.selectedPaths);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            this.photoGridAdapter.setCameraListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        Intent intent = PhotoPickerFragment.this.imageCaptureManager.dispatchTakePictureIntent();
                        PhotoPickerFragment.this.startActivityForResult(intent, 257);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 257: {
                if (resultCode != -1) break;
                this.imageCaptureManager.galleryAddPic((Context)this.getActivity());
                this.getDataFromMedia();
            }
        }
    }

    public static interface PhotoPickerFragmentListener {
    }
}

