/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.parsers;

import com.github.mauricio.async.db.exceptions.ParserNotAvailableException;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.AuthenticationStartupParser$;
import com.github.mauricio.async.db.postgresql.parsers.BackendKeyDataParser$;
import com.github.mauricio.async.db.postgresql.parsers.CommandCompleteParser;
import com.github.mauricio.async.db.postgresql.parsers.DataRowParser$;
import com.github.mauricio.async.db.postgresql.parsers.ErrorParser;
import com.github.mauricio.async.db.postgresql.parsers.MessageParser;
import com.github.mauricio.async.db.postgresql.parsers.NoticeParser;
import com.github.mauricio.async.db.postgresql.parsers.NotificationResponseParser;
import com.github.mauricio.async.db.postgresql.parsers.ParameterStatusParser;
import com.github.mauricio.async.db.postgresql.parsers.ReadyForQueryParser$;
import com.github.mauricio.async.db.postgresql.parsers.ReturningMessageParser$;
import com.github.mauricio.async.db.postgresql.parsers.RowDescriptionParser;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001#\t1R*Z:tC\u001e,\u0007+\u0019:tKJ\u001c(+Z4jgR\u0014\u0018P\u0003\u0002\u0004\t\u00059\u0001/\u0019:tKJ\u001c(BA\u0003\u0007\u0003)\u0001xn\u001d;he\u0016\u001c\u0018\u000f\u001c\u0006\u0003\u000f!\t!\u0001\u001a2\u000b\u0005%Q\u0011!B1ts:\u001c'BA\u0006\r\u0003!i\u0017-\u001e:jG&|'BA\u0007\u000f\u0003\u00199\u0017\u000e\u001e5vE*\tq\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\bG\"\f'o]3u!\tY\u0012%D\u0001\u001d\u0015\tIRD\u0003\u0002\u001f?\u0005\u0019a.[8\u000b\u0003\u0001\nAA[1wC&\u0011!\u0005\b\u0002\b\u0007\"\f'o]3u\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011A\u0001\u0005\u00063\r\u0002\rA\u0007\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003U\u0019w.\\7b]\u0012\u001cu.\u001c9mKR,\u0007+\u0019:tKJ,\u0012\u0001\f\t\u0003O5J!A\f\u0002\u0003+\r{W.\\1oI\u000e{W\u000e\u001d7fi\u0016\u0004\u0016M]:fe\"1\u0001\u0007\u0001Q\u0001\n1\nacY8n[\u0006tGmQ8na2,G/\u001a)beN,'\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u00034\u0003-)'O]8s!\u0006\u00148/\u001a:\u0016\u0003Q\u0002\"aJ\u001b\n\u0005Y\u0012!aC#se>\u0014\b+\u0019:tKJDa\u0001\u000f\u0001!\u0002\u0013!\u0014\u0001D3se>\u0014\b+\u0019:tKJ\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%IaO\u0001\r]>$\u0018nY3QCJ\u001cXM]\u000b\u0002yA\u0011q%P\u0005\u0003}\t\u0011ABT8uS\u000e,\u0007+\u0019:tKJDa\u0001\u0011\u0001!\u0002\u0013a\u0014!\u00048pi&\u001cW\rU1sg\u0016\u0014\b\u0005C\u0004C\u0001\t\u0007I\u0011B\"\u0002+A\f'/Y7fi\u0016\u00148\u000b^1ukN\u0004\u0016M]:feV\tA\t\u0005\u0002(\u000b&\u0011aI\u0001\u0002\u0016!\u0006\u0014\u0018-\\3uKJ\u001cF/\u0019;vgB\u000b'o]3s\u0011\u0019A\u0005\u0001)A\u0005\t\u00061\u0002/\u0019:b[\u0016$XM]*uCR,8\u000fU1sg\u0016\u0014\b\u0005C\u0004K\u0001\t\u0007I\u0011B&\u0002)I|w\u000fR3tGJL\u0007\u000f^5p]B\u000b'o]3s+\u0005a\u0005CA\u0014N\u0013\tq%A\u0001\u000bS_^$Um]2sSB$\u0018n\u001c8QCJ\u001cXM\u001d\u0005\u0007!\u0002\u0001\u000b\u0011\u0002'\u0002+I|w\u000fR3tGJL\u0007\u000f^5p]B\u000b'o]3sA!9!\u000b\u0001b\u0001\n\u0013\u0019\u0016A\u00078pi&4\u0017nY1uS>t'+Z:q_:\u001cX\rU1sg\u0016\u0014X#\u0001+\u0011\u0005\u001d*\u0016B\u0001,\u0003\u0005iqu\u000e^5gS\u000e\fG/[8o%\u0016\u001c\bo\u001c8tKB\u000b'o]3s\u0011\u0019A\u0006\u0001)A\u0005)\u0006Ybn\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016\u0004\u0016M]:fe\u0002BQA\u0017\u0001\u0005\nm\u000b\u0011\u0002]1sg\u0016\u0014hi\u001c:\u0015\u0005q{\u0006CA\u0014^\u0013\tq&AA\u0007NKN\u001c\u0018mZ3QCJ\u001cXM\u001d\u0005\u0006Af\u0003\r!Y\u0001\u0002iB\u00111CY\u0005\u0003GR\u0011AAQ=uK\")Q\r\u0001C\u0001M\u0006)\u0001/\u0019:tKR\u0019qm\u001c9\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017a\u00022bG.,g\u000e\u001a\u0006\u0003Y\u0012\t\u0001\"\\3tg\u0006<Wm]\u0005\u0003]&\u0014QbU3sm\u0016\u0014X*Z:tC\u001e,\u0007\"\u00021e\u0001\u0004\t\u0007\"B9e\u0001\u0004\u0011\u0018!\u00012\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018A\u00022vM\u001a,'O\u0003\u0002xq\u0006)a.\u001a;us*\t\u00110\u0001\u0002j_&\u00111\u0010\u001e\u0002\b\u0005f$XMQ;g\u0001")
public class MessageParsersRegistry {
    private final CommandCompleteParser commandCompleteParser;
    private final ErrorParser errorParser;
    private final NoticeParser noticeParser;
    private final ParameterStatusParser parameterStatusParser;
    private final RowDescriptionParser rowDescriptionParser;
    private final NotificationResponseParser notificationResponseParser;

    private CommandCompleteParser commandCompleteParser() {
        return this.commandCompleteParser;
    }

    private ErrorParser errorParser() {
        return this.errorParser;
    }

    private NoticeParser noticeParser() {
        return this.noticeParser;
    }

    private ParameterStatusParser parameterStatusParser() {
        return this.parameterStatusParser;
    }

    private RowDescriptionParser rowDescriptionParser() {
        return this.rowDescriptionParser;
    }

    private NotificationResponseParser notificationResponseParser() {
        return this.notificationResponseParser;
    }

    private MessageParser parserFor(byte t) {
        MessageParser messageParser;
        byte by = t;
        switch (by) {
            default: {
                throw new ParserNotAvailableException(t);
            }
            case 90: {
                messageParser = ReadyForQueryParser$.MODULE$;
                break;
            }
            case 84: {
                messageParser = this.rowDescriptionParser();
                break;
            }
            case 49: {
                messageParser = ReturningMessageParser$.MODULE$.ParseCompleteMessageParser();
                break;
            }
            case 83: {
                messageParser = this.parameterStatusParser();
                break;
            }
            case 65: {
                messageParser = this.notificationResponseParser();
                break;
            }
            case 78: {
                messageParser = this.noticeParser();
                break;
            }
            case 110: {
                messageParser = ReturningMessageParser$.MODULE$.NoDataMessageParser();
                break;
            }
            case 73: {
                messageParser = ReturningMessageParser$.MODULE$.EmptyQueryStringMessageParser();
                break;
            }
            case 69: {
                messageParser = this.errorParser();
                break;
            }
            case 68: {
                messageParser = DataRowParser$.MODULE$;
                break;
            }
            case 67: {
                messageParser = this.commandCompleteParser();
                break;
            }
            case 51: {
                messageParser = ReturningMessageParser$.MODULE$.CloseCompleteMessageParser();
                break;
            }
            case 50: {
                messageParser = ReturningMessageParser$.MODULE$.BindCompleteMessageParser();
                break;
            }
            case 75: {
                messageParser = BackendKeyDataParser$.MODULE$;
                break;
            }
            case 82: {
                messageParser = AuthenticationStartupParser$.MODULE$;
            }
        }
        return messageParser;
    }

    public ServerMessage parse(byte t, ByteBuf b) {
        return this.parserFor(t).parseMessage(b);
    }

    public MessageParsersRegistry(Charset charset) {
        this.commandCompleteParser = new CommandCompleteParser(charset);
        this.errorParser = new ErrorParser(charset);
        this.noticeParser = new NoticeParser(charset);
        this.parameterStatusParser = new ParameterStatusParser(charset);
        this.rowDescriptionParser = new RowDescriptionParser(charset);
        this.notificationResponseParser = new NotificationResponseParser(charset);
    }
}

