/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.util;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Configuration$;
import com.github.mauricio.async.db.SSLConfiguration;
import com.github.mauricio.async.db.SSLConfiguration$;
import com.github.mauricio.async.db.util.AbstractURIParser;
import com.github.mauricio.async.db.util.AbstractURIParser$;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import java.net.URI;
import java.nio.charset.Charset;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.util.matching.Regex;

public final class URLParser$
extends AbstractURIParser {
    public static final URLParser$ MODULE$;
    private final String PGPORT;
    private final String PGDBNAME;
    private final String PGHOST;
    private final String PGUSERNAME;
    private final String PGPASSWORD;
    private final String DEFAULT_PORT;
    private final Configuration DEFAULT;
    private final Regex SCHEME;
    private final Regex simplePGDB;

    static {
        new URLParser$();
    }

    public String PGPORT() {
        return this.PGPORT;
    }

    public String PGDBNAME() {
        return this.PGDBNAME;
    }

    public String PGHOST() {
        return this.PGHOST;
    }

    public String PGUSERNAME() {
        return this.PGUSERNAME;
    }

    public String PGPASSWORD() {
        return this.PGPASSWORD;
    }

    public String DEFAULT_PORT() {
        return this.DEFAULT_PORT;
    }

    public Configuration DEFAULT() {
        return this.DEFAULT;
    }

    public Regex SCHEME() {
        return this.SCHEME;
    }

    private Regex simplePGDB() {
        return this.simplePGDB;
    }

    public Map<String, String> handleJDBC(URI uri) {
        Map map;
        String string = uri.getSchemeSpecificPart();
        Option option = this.simplePGDB().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String db = (String)((LinearSeqOptimized)option.get()).apply(0);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AbstractURIParser$.MODULE$.DBNAME()), (Object)db)}));
        } else {
            map = this.parse(new URI(string));
        }
        return map;
    }

    public Configuration assembleConfiguration(Map<String, String> properties, Charset charset) {
        Configuration qual$1 = super.assembleConfiguration(properties, charset);
        SSLConfiguration x$1 = SSLConfiguration$.MODULE$.apply(properties);
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        int x$4 = qual$1.copy$default$3();
        Option x$5 = qual$1.copy$default$4();
        Option x$6 = qual$1.copy$default$5();
        Charset x$7 = qual$1.copy$default$7();
        int x$8 = qual$1.copy$default$8();
        ByteBufAllocator x$9 = qual$1.copy$default$9();
        Duration x$10 = qual$1.copy$default$10();
        Duration x$11 = qual$1.copy$default$11();
        int x$12 = qual$1.copy$default$12();
        Duration x$13 = qual$1.copy$default$13();
        EventLoopGroup x$14 = qual$1.copy$default$14();
        Class x$15 = qual$1.copy$default$15();
        Option x$16 = qual$1.copy$default$16();
        return qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    private URLParser$() {
        MODULE$ = this;
        this.PGPORT = AbstractURIParser$.MODULE$.PORT();
        this.PGDBNAME = AbstractURIParser$.MODULE$.DBNAME();
        this.PGHOST = AbstractURIParser$.MODULE$.HOST();
        this.PGUSERNAME = AbstractURIParser$.MODULE$.USERNAME();
        this.PGPASSWORD = AbstractURIParser$.MODULE$.PASSWORD();
        this.DEFAULT_PORT = "5432";
        this.DEFAULT = new Configuration("postgres", "localhost", 5432, (Option)None$.MODULE$, (Option)None$.MODULE$, new SSLConfiguration(SSLConfiguration$.MODULE$.apply$default$1(), SSLConfiguration$.MODULE$.apply$default$2()), Configuration$.MODULE$.apply$default$7(), Configuration$.MODULE$.apply$default$8(), Configuration$.MODULE$.apply$default$9(), Configuration$.MODULE$.apply$default$10(), Configuration$.MODULE$.apply$default$11(), Configuration$.MODULE$.apply$default$12(), Configuration$.MODULE$.apply$default$13(), Configuration$.MODULE$.apply$default$14(), Configuration$.MODULE$.apply$default$15(), Configuration$.MODULE$.apply$default$16());
        this.SCHEME = new StringOps(Predef$.MODULE$.augmentString("^postgres(?:ql)?$")).r();
        this.simplePGDB = new StringOps(Predef$.MODULE$.augmentString("^postgresql:(\\w+)$")).r();
    }
}

