/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.codec;

import com.github.mauricio.async.db.KindedMessage;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.EncoderNotAvailableException;
import com.github.mauricio.async.db.postgresql.codec.MessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.CloseMessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.CredentialEncoder;
import com.github.mauricio.async.db.postgresql.encoders.Encoder;
import com.github.mauricio.async.db.postgresql.encoders.ExecutePreparedStatementEncoder;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementOpeningEncoder;
import com.github.mauricio.async.db.postgresql.encoders.QueryMessageEncoder;
import com.github.mauricio.async.db.postgresql.encoders.SSLMessageEncoder$;
import com.github.mauricio.async.db.postgresql.encoders.StartupMessageEncoder;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.SSLRequestMessage$;
import com.github.mauricio.async.db.postgresql.messages.frontend.StartupMessage;
import com.github.mauricio.async.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ur!B\u0001\u0003\u0011\u0003\t\u0012AD'fgN\fw-Z#oG>$WM\u001d\u0006\u0003\u0007\u0011\tQaY8eK\u000eT!!\u0002\u0004\u0002\u0015A|7\u000f^4sKN\fHN\u0003\u0002\b\u0011\u0005\u0011AM\u0019\u0006\u0003\u0013)\tQ!Y:z]\u000eT!a\u0003\u0007\u0002\u00115\fWO]5dS>T!!\u0004\b\u0002\r\u001dLG\u000f[;c\u0015\u0005y\u0011aA2p[\u000e\u0001\u0001C\u0001\n\u0014\u001b\u0005\u0011a!\u0002\u000b\u0003\u0011\u0003)\"AD'fgN\fw-Z#oG>$WM]\n\u0003'Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007\"B\u000f\u0014\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\u0012\u0011\u001d\u00013C1A\u0005\u0002\u0005\n1\u0001\\8h+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0007\u0019><w-\u001a:\t\r-\u001a\u0002\u0015!\u0003#\u0003\u0011awn\u001a\u0011\u0007\tQ\u0011\u0001!L\n\u0003Y9\u00022aL\u001c:\u001b\u0005\u0001$BA\u00022\u0015\t\u00114'A\u0004iC:$G.\u001a:\u000b\u0005Q*\u0014!\u00028fiRL(\"\u0001\u001c\u0002\u0005%|\u0017B\u0001\u001d1\u0005]iUm]:bO\u0016$v.T3tg\u0006<W-\u00128d_\u0012,'\u000f\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005!A.\u00198h\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\r=\u0013'.Z2u\u0011!\u0011EF!A!\u0002\u0013\u0019\u0015aB2iCJ\u001cX\r\u001e\t\u0003\t\"k\u0011!\u0012\u0006\u0003\u0005\u001aS!aR\u001f\u0002\u00079Lw.\u0003\u0002J\u000b\n91\t[1sg\u0016$\b\u0002C&-\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u001f\u0015t7m\u001c3feJ+w-[:uef\u0004\"!\u0014)\u000e\u00039S!a\u0014\u0004\u0002\r\r|G.^7o\u0013\t\tfJA\u000bD_2,XN\\#oG>$WM\u001d*fO&\u001cHO]=\t\u000buaC\u0011A*\u0015\u0007Q+f\u000b\u0005\u0002\u0013Y!)!I\u0015a\u0001\u0007\")1J\u0015a\u0001\u0019\"9\u0001\f\fb\u0001\n\u0013I\u0016AD3yK\u000e,H/Z#oG>$WM]\u000b\u00025B\u00111LX\u0007\u00029*\u0011Q\fB\u0001\tK:\u001cw\u000eZ3sg&\u0011q\f\u0018\u0002 \u000bb,7-\u001e;f!J,\u0007/\u0019:fIN#\u0018\r^3nK:$XI\\2pI\u0016\u0014\bBB1-A\u0003%!,A\bfq\u0016\u001cW\u000f^3F]\u000e|G-\u001a:!\u0011\u001d\u0019GF1A\u0005\n\u0011\f1b\u001c9f]\u0016s7m\u001c3feV\tQ\r\u0005\u0002\\M&\u0011q\r\u0018\u0002 !J,\u0007/\u0019:fIN#\u0018\r^3nK:$x\n]3oS:<WI\\2pI\u0016\u0014\bBB5-A\u0003%Q-\u0001\u0007pa\u0016tWI\\2pI\u0016\u0014\b\u0005C\u0004lY\t\u0007I\u0011\u00027\u0002\u001dM$\u0018M\u001d;va\u0016s7m\u001c3feV\tQ\u000e\u0005\u0002\\]&\u0011q\u000e\u0018\u0002\u0016'R\f'\u000f^;q\u001b\u0016\u001c8/Y4f\u000b:\u001cw\u000eZ3s\u0011\u0019\tH\u0006)A\u0005[\u0006y1\u000f^1siV\u0004XI\\2pI\u0016\u0014\b\u0005C\u0004tY\t\u0007I\u0011\u0002;\u0002\u0019E,XM]=F]\u000e|G-\u001a:\u0016\u0003U\u0004\"a\u0017<\n\u0005]d&aE)vKJLX*Z:tC\u001e,WI\\2pI\u0016\u0014\bBB=-A\u0003%Q/A\u0007rk\u0016\u0014\u00180\u00128d_\u0012,'\u000f\t\u0005\bw2\u0012\r\u0011\"\u0003}\u0003E\u0019'/\u001a3f]RL\u0017\r\\#oG>$WM]\u000b\u0002{B\u00111L`\u0005\u0003\u007fr\u0013\u0011c\u0011:fI\u0016tG/[1m\u000b:\u001cw\u000eZ3s\u0011\u001d\t\u0019\u0001\fQ\u0001\nu\f!c\u0019:fI\u0016tG/[1m\u000b:\u001cw\u000eZ3sA!9\u0011q\u0001\u0017\u0005B\u0005%\u0011AB3oG>$W\r\u0006\u0005\u0002\f\u0005E\u0011\u0011EA\u0013!\r9\u0012QB\u0005\u0004\u0003\u001fA\"\u0001B+oSRD\u0001\"a\u0005\u0002\u0006\u0001\u0007\u0011QC\u0001\u0004GRD\b\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m1'A\u0004dQ\u0006tg.\u001a7\n\t\u0005}\u0011\u0011\u0004\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u001d\t\u0019#!\u0002A\u0002Y\t1!\\:h\u0011!\t9#!\u0002A\u0002\u0005%\u0012aA8viB)\u00111FA\u0019s5\u0011\u0011Q\u0006\u0006\u0004\u0003_i\u0014\u0001B;uS2LA!a\r\u0002.\t!A*[:u\u0001")
public class MessageEncoder
extends MessageToMessageEncoder<Object> {
    private final ExecutePreparedStatementEncoder executeEncoder;
    private final PreparedStatementOpeningEncoder openEncoder;
    private final StartupMessageEncoder startupEncoder;
    private final QueryMessageEncoder queryEncoder;
    private final CredentialEncoder credentialEncoder;

    public static Logger log() {
        return MessageEncoder$.MODULE$.log();
    }

    private ExecutePreparedStatementEncoder executeEncoder() {
        return this.executeEncoder;
    }

    private PreparedStatementOpeningEncoder openEncoder() {
        return this.openEncoder;
    }

    private StartupMessageEncoder startupEncoder() {
        return this.startupEncoder;
    }

    private QueryMessageEncoder queryEncoder() {
        return this.queryEncoder;
    }

    private CredentialEncoder credentialEncoder() {
        return this.credentialEncoder;
    }

    public void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        block14: {
            ByteBuf byteBuf;
            block12: {
                Encoder encoder;
                Object object;
                block13: {
                    block11: {
                        object = msg;
                        if (!SSLRequestMessage$.MODULE$.equals(object)) break block11;
                        byteBuf = SSLMessageEncoder$.MODULE$.encode();
                        break block12;
                    }
                    if (!(object instanceof StartupMessage)) break block13;
                    StartupMessage startupMessage = (StartupMessage)object;
                    byteBuf = this.startupEncoder().encode(startupMessage);
                    break block12;
                }
                if (!(object instanceof ClientMessage)) break block14;
                ClientMessage clientMessage = (ClientMessage)object;
                int n = clientMessage.kind();
                switch (n) {
                    default: {
                        throw new EncoderNotAvailableException((KindedMessage)clientMessage);
                    }
                    case 112: {
                        encoder = this.credentialEncoder();
                        break;
                    }
                    case 81: {
                        encoder = this.queryEncoder();
                        break;
                    }
                    case 80: {
                        encoder = this.openEncoder();
                        break;
                    }
                    case 69: {
                        encoder = this.executeEncoder();
                        break;
                    }
                    case 88: {
                        encoder = CloseMessageEncoder$.MODULE$;
                    }
                }
                Encoder encoder2 = encoder;
                byteBuf = encoder2.encode(clientMessage);
            }
            ByteBuf buffer = byteBuf;
            if (MessageEncoder$.MODULE$.log().isTraceEnabled()) {
                MessageEncoder$.MODULE$.log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending message ", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg.getClass().getName(), BufferDumper.dumpAsHex((ByteBuf)buffer)})));
            }
            out.add(buffer);
            return;
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Can not encode message %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
    }

    public MessageEncoder(Charset charset, ColumnEncoderRegistry encoderRegistry) {
        this.executeEncoder = new ExecutePreparedStatementEncoder(charset, encoderRegistry);
        this.openEncoder = new PreparedStatementOpeningEncoder(charset, encoderRegistry);
        this.startupEncoder = new StartupMessageEncoder(charset);
        this.queryEncoder = new QueryMessageEncoder(charset);
        this.credentialEncoder = new CredentialEncoder(charset);
    }
}

