/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.util;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ProgressBarController {
    public static final String DEFAULT_TAG = "default_tag";
    private static final Object sLock = new Object();
    private static Application.ActivityLifecycleCallbacks sLifecycleCallbacks;
    private static WeakHashMap<ProgressDialog, Tag> sDialogs;

    public static void init(Application app) {
        if (sLifecycleCallbacks != null) {
            app.unregisterActivityLifecycleCallbacks(sLifecycleCallbacks);
        }
        sLifecycleCallbacks = new OnDestroyActivityCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityDestroyed(Activity activity) {
                int hashCode = activity.hashCode();
                Object object = sLock;
                synchronized (object) {
                    List dialogs = ProgressBarController.findDialogs(hashCode);
                    for (ProgressDialog dialog : dialogs) {
                        dialog.dismiss();
                        sDialogs.remove(dialog);
                    }
                }
            }
        };
        app.registerActivityLifecycleCallbacks(sLifecycleCallbacks);
    }

    public static void release(Application app) {
        if (sLifecycleCallbacks != null) {
            app.unregisterActivityLifecycleCallbacks(sLifecycleCallbacks);
        }
        ProgressBarController.hideProgressDialogsAll();
    }

    public static void showProgressDialog(Context context) {
        ProgressBarController.showProgressDialog(context, DEFAULT_TAG, null);
    }

    public static void showProgressDialog(Context context, String message) {
        ProgressBarController.showProgressDialog(context, DEFAULT_TAG, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showProgressDialog(Context context, String tag, String message) {
        Activity activity = ProgressBarController.getActivity(context);
        if (!ProgressBarController.isAlive(activity) || activity.isFinishing()) {
            return;
        }
        if (tag == null) {
            tag = DEFAULT_TAG;
        }
        ProgressDialog dialog = null;
        Object object = sLock;
        synchronized (object) {
            dialog = ProgressBarController.findDialog(tag);
            if (!ProgressBarController.isAlive((Dialog)dialog)) {
                if (dialog != null) {
                    sDialogs.remove(dialog);
                }
                dialog = new ProgressDialog(context);
                dialog.requestWindowFeature(1);
                dialog.setCancelable(false);
                sDialogs.put(dialog, new Tag(tag, activity.hashCode()));
            }
        }
        dialog.setMessage((CharSequence)message);
        dialog.show();
    }

    public static void hideProgressDialog() {
        ProgressBarController.hideProgressDialog(DEFAULT_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideProgressDialog(String tag) {
        if (tag == null) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            ProgressDialog dialog = ProgressBarController.findDialog(tag);
            if (dialog != null) {
                if (ProgressBarController.isAlive((Dialog)dialog) && dialog.isShowing()) {
                    dialog.dismiss();
                }
                sDialogs.remove(dialog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideProgressDialogsAll() {
        Object object = sLock;
        synchronized (object) {
            for (ProgressDialog dialog : sDialogs.keySet()) {
                if (!ProgressBarController.isAlive((Dialog)dialog) || !dialog.isShowing()) continue;
                dialog.dismiss();
            }
            sDialogs.clear();
        }
    }

    private static ProgressDialog findDialog(@NonNull String tag) {
        for (Map.Entry<ProgressDialog, Tag> entry : sDialogs.entrySet()) {
            if (!tag.equals(entry.getValue().tag)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static List<ProgressDialog> findDialogs(long activityHashcode) {
        ArrayList<ProgressDialog> result = new ArrayList<ProgressDialog>();
        for (Map.Entry<ProgressDialog, Tag> entry : sDialogs.entrySet()) {
            if (activityHashcode != entry.getValue().activityHashcode) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private static Activity getActivity(Context context) {
        if (context != null) {
            Context baseContext = context;
            while (!(baseContext instanceof Activity) && baseContext instanceof ContextWrapper) {
                baseContext = ((ContextWrapper)baseContext).getBaseContext();
            }
            if (baseContext instanceof Activity) {
                return (Activity)baseContext;
            }
        }
        return null;
    }

    private static boolean isAlive(Dialog dialog) {
        return dialog != null && ProgressBarController.isAlive(ProgressBarController.getActivity(dialog.getContext()));
    }

    private static boolean isAlive(Activity activity) {
        if (activity == null) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    static {
        sDialogs = new WeakHashMap();
    }

    private static abstract class OnDestroyActivityCallback
    implements Application.ActivityLifecycleCallbacks {
        private OnDestroyActivityCallback() {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    private static class Tag {
        final String tag;
        final long activityHashcode;

        private Tag(String tag, long activityHashcode) {
            this.tag = tag;
            this.activityHashcode = activityHashcode;
        }
    }
}

