/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.util;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DebounceHelper {
    private final HashMap<String, Long> mDebounceMap = new HashMap();
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();

    public boolean checkTimeElapsed(String tag, long debounceMillis) {
        this.mLock.readLock().lock();
        Long lastCallMillis = this.mDebounceMap.get(tag);
        this.mLock.readLock().unlock();
        long nowMillis = System.currentTimeMillis();
        return lastCallMillis == null || nowMillis - lastCallMillis > debounceMillis;
    }

    public void resetTime(String tag) {
        this.mLock.writeLock().lock();
        this.mDebounceMap.put(tag, System.currentTimeMillis());
        this.mLock.writeLock().unlock();
    }

    public boolean checkTimeAndResetIfElapsed(String tag, long debounceMillis) {
        this.mLock.readLock().lock();
        Long lastCallMillis = this.mDebounceMap.get(tag);
        this.mLock.readLock().unlock();
        long nowMillis = System.currentTimeMillis();
        if (lastCallMillis == null || nowMillis - lastCallMillis > debounceMillis) {
            this.mLock.writeLock().lock();
            this.mDebounceMap.put(tag, nowMillis);
            this.mLock.writeLock().unlock();
            return true;
        }
        return false;
    }
}

