/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.drextended.actionhandler.action.Cancelable;
import com.drextended.actionhandler.action.RequestAction;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.observers.DisposableMaybeObserver;
import io.reactivex.schedulers.Schedulers;

public abstract class RxRequestAction<RM, M>
extends RequestAction<RM, M>
implements Cancelable {
    protected CompositeDisposable mDisposable;
    protected boolean mUnsubscribeOnNewRequest = true;

    public RxRequestAction() {
    }

    public RxRequestAction(boolean showProgressEnabled, boolean showDialog) {
        super(showProgressEnabled, showDialog);
    }

    public RxRequestAction(boolean showProgressEnabled, boolean showDialog, boolean unsubscribeOnNewRequest) {
        super(showProgressEnabled, showDialog);
        this.mUnsubscribeOnNewRequest = unsubscribeOnNewRequest;
    }

    @Override
    protected void onMakeRequest(final Context context, final View view, final String actionType, final M model, Object payload) {
        Maybe<RM> observableRequest = this.getRequest(context, view, actionType, model, payload);
        if (observableRequest == null) {
            if (this.mShowProgressEnabled) {
                this.hideProgressDialog();
            }
            return;
        }
        if (this.mUnsubscribeOnNewRequest) {
            this.dispose((Disposable)this.mDisposable);
        }
        if (this.mDisposable == null || this.mDisposable.isDisposed()) {
            this.mDisposable = new CompositeDisposable();
        }
        this.mDisposable.add((Disposable)observableRequest.compose(this.applySchedulers()).subscribeWith((MaybeObserver)new DisposableMaybeObserver<RM>(){
            private volatile boolean hasResponse = false;

            public void onSuccess(RM response) {
                this.hasResponse = true;
                RxRequestAction.this.onResponseSuccess(context, view, actionType, model, response);
            }

            public void onError(Throwable e) {
                RxRequestAction.this.onResponseError(context, view, actionType, model, e);
            }

            public void onComplete() {
                if (!this.hasResponse) {
                    RxRequestAction.this.onResponseSuccess(context, view, actionType, model, null);
                }
            }
        }));
    }

    @NonNull
    protected MaybeTransformer<RM, RM> applySchedulers() {
        return new MaybeTransformer<RM, RM>(){

            public MaybeSource<RM> apply(Maybe<RM> upstream) {
                return upstream.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
            }
        };
    }

    protected void dispose(Disposable disposable) {
        if (disposable != null && !disposable.isDisposed()) {
            disposable.dispose();
        }
    }

    @Override
    public void cancel() {
        this.dispose((Disposable)this.mDisposable);
    }

    @Nullable
    protected abstract Maybe<RM> getRequest(Context var1, View var2, String var3, M var4, @Nullable Object var5);
}

