/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import com.drextended.actionhandler.R;
import com.drextended.actionhandler.action.DialogAction;
import com.drextended.actionhandler.util.ProgressBarController;

public abstract class RequestAction<RM, M>
extends DialogAction<M> {
    protected boolean mShowProgressEnabled;
    protected boolean mShowDialogEnabled;
    protected String mProgressTag;

    public RequestAction() {
    }

    public RequestAction(boolean showProgressEnabled, boolean showDialogEnabled) {
        this.mShowProgressEnabled = showProgressEnabled;
        this.mShowDialogEnabled = showDialogEnabled;
        if (this.mShowProgressEnabled) {
            this.mProgressTag = this.getClass().getSimpleName();
        }
    }

    public void setShowProgressEnabled(boolean showProgressEnabled) {
        this.mShowProgressEnabled = showProgressEnabled;
        if (this.mProgressTag == null && this.mShowProgressEnabled) {
            this.mProgressTag = this.getClass().getSimpleName();
        }
    }

    public void setShowDialogEnabled(boolean showDialogEnabled) {
        this.mShowDialogEnabled = showDialogEnabled;
    }

    @Override
    public void onFireAction(Context context, @Nullable View view, String actionType, @Nullable M model) {
        if (this.mShowDialogEnabled) {
            super.onFireAction(context, view, actionType, model);
        } else {
            this.makeRequest(context, view, actionType, model, null);
        }
    }

    @Override
    protected void onDialogActionFire(Context context, View view, String actionType, M model, Object payload) {
        this.makeRequest(context, view, actionType, model, payload);
    }

    public void makeRequest(Context context, View view, String actionType, M model) {
        this.makeRequest(context, view, actionType, model, null);
    }

    public void makeRequest(Context context, View view, String actionType, M model, @Nullable Object payload) {
        this.onRequestStarted(context, view, actionType, model, payload);
        this.onMakeRequest(context, view, actionType, model, payload);
    }

    protected void onRequestStarted(Context context, View view, String actionType, M model) {
    }

    protected void onRequestStarted(Context context, View view, String actionType, M model, @Nullable Object payload) {
        if (this.mShowProgressEnabled) {
            this.showProgressDialog(context, view, actionType, model);
        }
        this.onRequestStarted(context, view, actionType, model);
    }

    protected String getProgressDialogMessage(Context context, View view, String actionType, M model) {
        return context.getString(R.string.action_handler_dialog_message_wait);
    }

    protected void onResponseSuccess(Context context, View view, String actionType, M oldModel, RM response) {
        if (this.mShowProgressEnabled) {
            this.hideProgressDialog();
        }
        this.notifyOnActionFired(view, actionType, oldModel, response);
    }

    public void showProgressDialog(Context context, View view, String actionType, M model) {
        ProgressBarController.showProgressDialog(context, this.mProgressTag, this.getProgressDialogMessage(context, view, actionType, model));
    }

    public void hideProgressDialog() {
        ProgressBarController.hideProgressDialog(this.mProgressTag);
    }

    protected void onResponseError(Context context, View view, String actionType, M oldModel, Throwable e) {
        if (this.mShowProgressEnabled) {
            this.hideProgressDialog();
        }
        this.notifyOnActionError(e, view, actionType, oldModel);
    }

    protected abstract void onMakeRequest(Context var1, View var2, String var3, M var4, @Nullable Object var5);
}

