/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import com.drextended.actionhandler.action.BaseAction;
import com.drextended.actionhandler.util.AcceptCondition;

public abstract class IntentAction<M>
extends BaseAction<M> {
    protected final IntentType mIntentType;

    public IntentAction() {
        this.mIntentType = IntentType.START_ACTIVITY;
    }

    public IntentAction(@NonNull IntentType intentType) {
        this.mIntentType = intentType;
    }

    @Override
    public void onFireAction(Context context, @Nullable View view, String actionType, @Nullable M model) {
        Intent intent = this.getIntent(view, context, actionType, model);
        if (intent == null) {
            return;
        }
        try {
            switch (this.mIntentType) {
                case START_ACTIVITY: {
                    this.startActivity(context, view, intent);
                    break;
                }
                case START_SERVICE: {
                    this.startService(context, intent);
                    break;
                }
                case STOP_SERVICE: {
                    this.stopService(context, intent);
                    break;
                }
                case SEND_BROADCAST: {
                    this.sendBroadcast(context, intent);
                    break;
                }
                case SEND_LOCAL_BROADCAST: {
                    this.sendLocalBroadcast(context, intent);
                }
            }
            this.notifyOnActionFired(view, actionType, model);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onError(e, view, actionType, model);
        }
    }

    protected void onError(Exception throwable, View view, String actionType, M model) {
        this.notifyOnActionError(throwable, view, actionType, model);
    }

    protected void startActivity(Context context, View view, Intent intent) throws ActivityNotFoundException {
        ActivityOptionsCompat activityOptions;
        if (Build.VERSION.SDK_INT >= 16 && (activityOptions = this.prepareTransition(context, view, intent)) != null) {
            context.startActivity(intent, activityOptions.toBundle());
            return;
        }
        context.startActivity(intent);
    }

    protected void startService(Context context, Intent intent) throws SecurityException {
        context.startService(intent);
    }

    protected void stopService(Context context, Intent intent) throws SecurityException {
        context.stopService(intent);
    }

    protected void sendBroadcast(Context context, Intent intent) {
        context.sendBroadcast(intent);
    }

    protected void sendLocalBroadcast(Context context, Intent intent) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    @Nullable
    public abstract Intent getIntent(@Nullable View var1, Context var2, String var3, M var4);

    protected ActivityOptionsCompat prepareTransition(Context context, View view, Intent intent) {
        return null;
    }

    public static IntentAction from(Intent intent, IntentType intentType, AcceptCondition acceptCondition) {
        return new SimpleIntentAction(intent, intentType, acceptCondition);
    }

    public static IntentAction from(Intent intent) {
        return new SimpleIntentAction(intent, IntentType.START_ACTIVITY, null);
    }

    public static class SimpleIntentAction
    extends IntentAction {
        protected final Intent mIntent;
        protected final AcceptCondition mAcceptCondition;

        public SimpleIntentAction(Intent intent, IntentType intentType, @Nullable AcceptCondition acceptCondition) {
            super(intentType != null ? intentType : IntentType.START_ACTIVITY);
            this.mIntent = intent;
            this.mAcceptCondition = acceptCondition;
        }

        @Override
        public boolean isModelAccepted(Object model) {
            return this.mAcceptCondition == null || this.mAcceptCondition.isModelAccepted(model);
        }

        @Nullable
        public Intent getIntent(@Nullable View view, Context context, String actionType, Object model) {
            return this.mIntent;
        }
    }

    public static enum IntentType {
        START_ACTIVITY,
        START_SERVICE,
        STOP_SERVICE,
        SEND_BROADCAST,
        SEND_LOCAL_BROADCAST;

    }
}

