/*
 * Decompiled with CFR 0.152.
 */
package com.drextended.actionhandler.action;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.view.View;
import com.drextended.actionhandler.action.Action;
import com.drextended.actionhandler.action.BaseAction;
import com.drextended.actionhandler.listener.ActionFireInterceptor;
import com.drextended.actionhandler.listener.OnActionDismissListener;
import com.drextended.actionhandler.listener.OnActionErrorListener;
import com.drextended.actionhandler.listener.OnActionFiredListener;

public abstract class DialogAction<M>
extends BaseAction<M> {
    @Override
    public void onFireAction(Context context, @Nullable View view, String actionType, @Nullable M model) {
        Dialog dialog = this.createDialog(context, view, actionType, model);
        dialog.show();
    }

    protected Dialog createDialog(final Context context, final @Nullable View view, final String actionType, final @Nullable M model) {
        String title = this.getDialogTitle(context, actionType, model);
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        if (title != null) {
            builder.setTitle((CharSequence)title);
        }
        builder.setMessage((CharSequence)this.getDialogMessage(context, actionType, model)).setNegativeButton(this.getNegativeButtonTitleResId(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DialogAction.this.notifyOnActionDismiss("Dialog cancelled", view, actionType, model);
            }
        }).setPositiveButton(this.getPositiveButtonTitleResId(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DialogAction.this.onDialogActionFire(context, view, actionType, model, null);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DialogAction.this.notifyOnActionDismiss("Dialog cancelled", view, actionType, model);
            }
        });
        return builder.create();
    }

    protected String getDialogTitle(Context context, String actionType, M model) {
        return null;
    }

    protected abstract String getDialogMessage(Context var1, String var2, M var3);

    protected int getPositiveButtonTitleResId() {
        return 17039370;
    }

    protected int getNegativeButtonTitleResId() {
        return 0x1040000;
    }

    protected void onDialogActionFire(Context context, View view, String actionType, M model) {
        this.onDialogActionFire(context, view, actionType, model, null);
    }

    protected void onDialogActionFire(Context context, View view, String actionType, M model, @Nullable Object payload) {
    }

    public static <M> DialogAction<M> wrap(String dialogMessage, Action<M> action) {
        return new DialogActionWrapper<M>(dialogMessage, action);
    }

    private static class DialogActionWrapper<M>
    extends DialogAction<M> {
        private final Action<M> mAction;
        private final String mDialogMessage;

        public DialogActionWrapper(String dialogMessage, Action<M> action) {
            this.mAction = action;
            this.mDialogMessage = dialogMessage;
        }

        @Override
        protected String getDialogMessage(Context context, String actionType, M model) {
            return this.mDialogMessage;
        }

        @Override
        protected void onDialogActionFire(Context context, View view, String actionType, M model, Object payload) {
            if (this.mAction != null) {
                this.mAction.onFireAction(context, view, actionType, model);
            }
        }

        @Override
        public boolean isModelAccepted(Object model) {
            return this.mAction != null && this.mAction.isModelAccepted(model);
        }

        @Override
        public void addActionFiredListener(OnActionFiredListener listener) {
            super.addActionFiredListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).addActionFiredListener(listener);
            }
        }

        @Override
        public void addActionErrorListener(OnActionErrorListener listener) {
            super.addActionErrorListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).addActionErrorListener(listener);
            }
        }

        @Override
        public void addActionDismissListener(OnActionDismissListener listener) {
            super.addActionDismissListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).addActionDismissListener(listener);
            }
        }

        @Override
        public void addActionFireInterceptor(ActionFireInterceptor interceptor) {
            super.addActionFireInterceptor(interceptor);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).addActionFireInterceptor(interceptor);
            }
        }

        @Override
        public void removeActionFireListener(OnActionFiredListener listener) {
            super.removeActionFireListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeActionFireListener(listener);
            }
        }

        @Override
        public void removeAllActionFireListeners() {
            super.removeAllActionFireListeners();
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeAllActionFireListeners();
            }
        }

        @Override
        public void removeActionErrorListener(OnActionErrorListener listener) {
            super.removeActionErrorListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeActionErrorListener(listener);
            }
        }

        @Override
        public void removeAllActionErrorListeners() {
            super.removeAllActionErrorListeners();
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeAllActionFireListeners();
            }
        }

        @Override
        public void removeActionDismissListener(OnActionDismissListener listener) {
            super.removeActionDismissListener(listener);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeActionDismissListener(listener);
            }
        }

        @Override
        public void removeAllActionDismissListeners() {
            super.removeAllActionDismissListeners();
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeAllActionDismissListeners();
            }
        }

        @Override
        public void removeActionFireInterceptor(ActionFireInterceptor interceptor) {
            super.removeActionFireInterceptor(interceptor);
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeActionFireInterceptor(interceptor);
            }
        }

        @Override
        public void removeAllActionFireInterceptors() {
            super.removeAllActionFireInterceptors();
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeAllActionFireListeners();
            }
        }

        @Override
        public void removeAllActionListeners() {
            super.removeAllActionListeners();
            if (this.mAction instanceof BaseAction) {
                ((BaseAction)this.mAction).removeAllActionListeners();
            }
        }
    }
}

