/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader
extends SequentialReader {
    @NotNull
    private final InputStream _stream;

    public StreamReader(@NotNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        this._stream = stream;
    }

    protected byte getByte() throws IOException {
        int value = this._stream.read();
        if (value == -1) {
            throw new EOFException("End of data reached.");
        }
        return (byte)value;
    }

    @NotNull
    public byte[] getBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        int totalBytesRead = 0;
        while (totalBytesRead != count) {
            int bytesRead = this._stream.read(bytes, totalBytesRead, count - totalBytesRead);
            if (bytesRead == -1) {
                throw new EOFException("End of data reached.");
            }
            assert ((totalBytesRead += bytesRead) <= count);
        }
        return bytes;
    }

    public void skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        long skippedCount = this.skipInternal(n);
        if (skippedCount != n) {
            throw new EOFException(String.format("Unable to skip. Requested %d bytes but skipped %d.", n, skippedCount));
        }
    }

    public boolean trySkip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        return this.skipInternal(n) == n;
    }

    private long skipInternal(long n) throws IOException {
        long skippedTotal;
        long skipped;
        for (skippedTotal = 0L; skippedTotal != n; skippedTotal += skipped) {
            skipped = this._stream.skip(n - skippedTotal);
            assert (skipped >= 0L);
        }
        return skippedTotal;
    }
}

