/*
 * Decompiled with CFR 0.152.
 */
package com.drew.tools;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessAllImagesInFolderUtility {
    public static void main(String[] args) throws IOException, JpegProcessingException {
        if (args.length == 0) {
            System.err.println("Expects one or more directories as arguments.");
            System.exit(1);
        }
        ArrayList<String> directories = new ArrayList<String>();
        FileHandlerBase handler = null;
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-text")) {
                handler = new TextFileOutputHandler();
                continue;
            }
            if (arg.equalsIgnoreCase("-markdown")) {
                handler = new MarkdownTableOutputHandler();
                continue;
            }
            directories.add(arg);
        }
        if (handler == null) {
            handler = new BasicFileHandler();
        }
        long start = System.nanoTime();
        Collections.sort(directories);
        for (String directory : directories) {
            ProcessAllImagesInFolderUtility.processDirectory(new File(directory), handler);
        }
        handler.onCompleted();
        System.out.println(String.format("Completed in %d ms", (System.nanoTime() - start) / 1000000L));
    }

    private static void processDirectory(@NotNull File path, @NotNull FileHandler handler) {
        Object[] pathItems = path.list();
        if (pathItems == null) {
            return;
        }
        Arrays.sort(pathItems);
        for (Object pathItem : pathItems) {
            Metadata metadata;
            File file = new File(path, (String)pathItem);
            if (file.isDirectory()) {
                ProcessAllImagesInFolderUtility.processDirectory(file, handler);
                continue;
            }
            if (!handler.shouldProcess(file)) continue;
            handler.onProcessingStarting(file);
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Throwable t) {
                handler.onException(file, t);
                continue;
            }
            handler.onExtracted(file, metadata);
        }
    }

    static class BasicFileHandler
    extends FileHandlerBase {
        BasicFileHandler() {
        }

        public void onExtracted(@NotNull File file, @NotNull Metadata metadata) {
            super.onExtracted(file, metadata);
            for (Directory directory : metadata.getDirectories()) {
                directory.getName();
                for (Tag tag : directory.getTags()) {
                    tag.getTagName();
                    tag.getDescription();
                }
            }
        }
    }

    static class MarkdownTableOutputHandler
    extends FileHandlerBase {
        private final Map<String, String> _extensionEquivalence = new HashMap<String, String>();
        private final Map<String, List<Row>> _rowListByExtension = new HashMap<String, List<Row>>();

        public MarkdownTableOutputHandler() {
            this._extensionEquivalence.put("jpeg", "jpg");
        }

        public void onExtracted(@NotNull File file, @NotNull Metadata metadata) {
            List<Row> list;
            super.onExtracted(file, metadata);
            String extension = this.getExtension(file);
            if (extension == null) {
                return;
            }
            if (this._extensionEquivalence.containsKey(extension = extension.toLowerCase())) {
                extension = this._extensionEquivalence.get(extension);
            }
            if ((list = this._rowListByExtension.get(extension)) == null) {
                list = new ArrayList<Row>();
                this._rowListByExtension.put(extension, list);
            }
            list.add(new Row(file, metadata));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted() {
            super.onCompleted();
            FileOutputStream outputStream = null;
            PrintStream stream = null;
            try {
                outputStream = new FileOutputStream("../wiki/ImageDatabaseSummary.md", false);
                stream = new PrintStream(outputStream, false);
                this.writeOutput(stream);
                stream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void writeOutput(@NotNull PrintStream stream) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            writer.write("# Image Database Summary\n\n");
            for (String extension : this._rowListByExtension.keySet()) {
                writer.write("## " + extension.toUpperCase() + " Files\n\n");
                writer.write("File|Manufacturer|Model|Dir Count|Exif?|Makernote|Thumbnail|All Data\n");
                writer.write("----|------------|-----|---------|-----|---------|---------|--------\n");
                List<Row> rows = this._rowListByExtension.get(extension);
                Collections.sort(rows, new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        int c1 = StringUtil.compare(o1.manufacturer, o2.manufacturer);
                        return c1 != 0 ? c1 : StringUtil.compare(o1.model, o2.model);
                    }
                });
                for (Row row : rows) {
                    writer.write(String.format("[%s](http://sample-images.metadata-extractor.googlecode.com/git/%s)|%s|%s|%d|%s|%s|%s|[metadata](http://sample-images.metadata-extractor.googlecode.com/git/metadata/%s.txt)%n", row.file.getName(), StringUtil.urlEncode(row.file.getName()), row.manufacturer == null ? "" : row.manufacturer, row.model == null ? "" : row.model, row.metadata.getDirectoryCount(), row.exifVersion == null ? "" : row.exifVersion, row.makernote == null ? "" : row.makernote, row.thumbnail == null ? "" : row.thumbnail, StringUtil.urlEncode(row.file.getName()).toLowerCase()));
                }
                ((Writer)writer).write(10);
            }
            ((Writer)writer).flush();
        }

        class Row {
            final File file;
            final Metadata metadata;
            @Nullable
            private String manufacturer;
            @Nullable
            private String model;
            @Nullable
            private String exifVersion;
            @Nullable
            private String thumbnail;
            @Nullable
            private String makernote;

            Row(@NotNull File file, Metadata metadata) {
                this.file = file;
                this.metadata = metadata;
                ExifIFD0Directory ifd0Dir = metadata.getDirectory(ExifIFD0Directory.class);
                ExifSubIFDDirectory subIfdDir = metadata.getDirectory(ExifSubIFDDirectory.class);
                ExifThumbnailDirectory thumbDir = metadata.getDirectory(ExifThumbnailDirectory.class);
                if (ifd0Dir != null) {
                    this.manufacturer = ifd0Dir.getDescription(271);
                    this.model = ifd0Dir.getDescription(272);
                }
                boolean hasMakernoteData = false;
                if (subIfdDir != null) {
                    this.exifVersion = subIfdDir.getDescription(36864);
                    hasMakernoteData = subIfdDir.containsTag(37500);
                }
                if (thumbDir != null) {
                    Integer width = thumbDir.getInteger(256);
                    Integer height = thumbDir.getInteger(257);
                    this.thumbnail = width != null && height != null ? String.format("Yes (%s x %s)", width, height) : "Yes";
                }
                for (Directory directory : metadata.getDirectories()) {
                    if (!directory.getClass().getName().contains("Makernote")) continue;
                    this.makernote = directory.getName().replace("Makernote", "").trim();
                }
                if (this.makernote == null) {
                    this.makernote = hasMakernoteData ? "(Unknown)" : "N/A";
                }
            }
        }
    }

    static class TextFileOutputHandler
    extends FileHandlerBase {
        TextFileOutputHandler() {
        }

        public void onExtracted(@NotNull File file, @NotNull Metadata metadata) {
            super.onExtracted(file, metadata);
            try {
                TextFileOutputHandler.writeOutputFile(file, metadata);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeOutputFile(File file, Metadata metadata) throws IOException {
            Writer writer = null;
            try {
                File metadataDir = new File(String.format("%s/metadata", file.getParent()));
                if (!metadataDir.exists()) {
                    metadataDir.mkdir();
                }
                String outputPath = String.format("%s/metadata/%s.txt", file.getParent(), file.getName().toLowerCase());
                writer = new FileWriter(outputPath, false);
                writer.write("FILE: " + file.getName() + "\n");
                writer.write("\n");
                if (metadata.hasErrors()) {
                    for (Directory directory : metadata.getDirectories()) {
                        if (!directory.hasErrors()) continue;
                        for (String error : directory.getErrors()) {
                            writer.write(String.format("[ERROR: %s] %s\n", directory.getName(), error));
                        }
                    }
                    writer.write("\n");
                }
                for (Directory directory : metadata.getDirectories()) {
                    String directoryName = directory.getName();
                    for (Tag tag : directory.getTags()) {
                        String tagName = tag.getTagName();
                        String description = tag.getDescription();
                        writer.write(String.format("[%s - %s] %s = %s%n", directoryName, tag.getTagTypeHex(), tagName, description));
                    }
                    if (directory.getTagCount() == 0) continue;
                    writer.write("\n");
                }
            }
            finally {
                if (writer != null) {
                    writer.write("Generated using metadata-extractor\n");
                    writer.write("https://drewnoakes.com/code/exif/\n");
                    ((OutputStreamWriter)writer).flush();
                    ((OutputStreamWriter)writer).close();
                }
            }
        }
    }

    static abstract class FileHandlerBase
    implements FileHandler {
        private final Set<String> _supportedExtensions = new HashSet<String>(Arrays.asList("jpg", "jpeg", "nef", "crw", "cr2", "orf", "tif", "tiff", "png", "gif", "bmp"));
        private int _processedFileCount = 0;
        private int _exceptionCount = 0;
        private int _errorCount = 0;
        private long _processedByteCount = 0L;

        FileHandlerBase() {
        }

        public boolean shouldProcess(@NotNull File file) {
            String extension = this.getExtension(file);
            return extension != null && this._supportedExtensions.contains(extension.toLowerCase());
        }

        public void onProcessingStarting(@NotNull File file) {
            ++this._processedFileCount;
            this._processedByteCount += file.length();
        }

        public void onException(@NotNull File file, @NotNull Throwable throwable) {
            ++this._exceptionCount;
            if (throwable instanceof ImageProcessingException) {
                System.err.printf("%s: %s [Error Extracting Metadata]\n\t%s%n", throwable.getClass().getName(), file, throwable.getMessage());
            } else {
                System.err.printf("%s: %s [Error Extracting Metadata]%n", throwable.getClass().getName(), file);
                throwable.printStackTrace(System.err);
            }
        }

        public void onExtracted(@NotNull File file, @NotNull Metadata metadata) {
            if (metadata.hasErrors()) {
                System.err.println(file);
                for (Directory directory : metadata.getDirectories()) {
                    if (!directory.hasErrors()) continue;
                    for (String error : directory.getErrors()) {
                        System.err.printf("\t[%s] %s%n", directory.getName(), error);
                        ++this._errorCount;
                    }
                }
            }
        }

        public void onCompleted() {
            if (this._processedFileCount > 0) {
                System.out.println(String.format("Processed %,d files (%,d bytes) with %,d exceptions and %,d file errors", this._processedFileCount, this._processedByteCount, this._exceptionCount, this._errorCount));
            }
        }

        @Nullable
        protected String getExtension(@NotNull File file) {
            String fileName = file.getName();
            int i = fileName.lastIndexOf(46);
            if (i == -1) {
                return null;
            }
            if (i == fileName.length() - 1) {
                return null;
            }
            return fileName.substring(i + 1);
        }
    }

    static interface FileHandler {
        public boolean shouldProcess(@NotNull File var1);

        public void onException(@NotNull File var1, @NotNull Throwable var2);

        public void onExtracted(@NotNull File var1, @NotNull Metadata var2);

        public void onCompleted();

        public void onProcessingStarting(@NotNull File var1);
    }
}

