/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Arrays;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpReader
implements JpegSegmentMetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    @NotNull
    private static final String SCHEMA_XMP_PROPERTIES = "http://ns.adobe.com/xap/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(@NotNull byte[] segmentBytes, @NotNull JpegSegmentType segmentType) {
        return segmentBytes.length > 27 && SCHEMA_XMP_PROPERTIES.equalsIgnoreCase(new String(segmentBytes, 0, 28));
    }

    @Override
    public void extract(@NotNull byte[] segmentBytes, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        XmpDirectory directory = metadata.getOrCreateDirectory(XmpDirectory.class);
        int preambleLength = 29;
        if (segmentBytes.length <= 30) {
            directory.addError(String.format("Xmp data segment must contain at least %d bytes", 30));
            return;
        }
        String preamble = new String(segmentBytes, 0, 29);
        if (!"http://ns.adobe.com/xap/1.0/\u0000".equals(preamble)) {
            directory.addError("XMP data segment doesn't begin with 'http://ns.adobe.com/xap/1.0/'");
            return;
        }
        byte[] xmlBytes = new byte[segmentBytes.length - 29];
        System.arraycopy(segmentBytes, 29, xmlBytes, 0, xmlBytes.length);
        this.extract(xmlBytes, metadata);
    }

    public void extract(@NotNull byte[] xmpBytes, @NotNull Metadata metadata) {
        XmpDirectory directory = metadata.getOrCreateDirectory(XmpDirectory.class);
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer((byte[])xmpBytes);
            XmpReader.processXmpTags(directory, xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
    }

    public void extract(@NotNull String xmpString, @NotNull Metadata metadata) {
        XmpDirectory directory = metadata.getOrCreateDirectory(XmpDirectory.class);
        try {
            XMPMeta xmpMeta = XMPMetaFactory.parseFromString((String)xmpString);
            XmpReader.processXmpTags(directory, xmpMeta);
        }
        catch (XMPException e) {
            directory.addError("Error processing XMP data: " + e.getMessage());
        }
    }

    private static void processXmpTags(XmpDirectory directory, XMPMeta xmpMeta) throws XMPException {
        directory.setXMPMeta(xmpMeta);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:LensInfo", 6, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Lens", 7, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:SerialNumber", 8, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Firmware", 9, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Make", 1, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Model", 2, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureTime", 3, 1);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureProgram", 12, 3);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ApertureValue", 11, 2);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FNumber", 5, 2);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FocalLength", 10, 2);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ShutterSpeedValue", 4, 2);
        XmpReader.processXmpDateTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeOriginal", 13);
        XmpReader.processXmpDateTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeDigitized", 14);
        XmpReader.processXmpTag(xmpMeta, directory, SCHEMA_XMP_PROPERTIES, "xmp:Rating", 4097, 4);
        for (XMPPropertyInfo propInfo : xmpMeta) {
            String path = propInfo.getPath();
            String value = propInfo.getValue();
            if (path == null || value == null) continue;
            directory.addProperty(path, value);
        }
    }

    private static void processXmpTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, @NotNull String schemaNS, @NotNull String propName, int tagType, int formatCode) throws XMPException {
        String property = meta.getPropertyString(schemaNS, propName);
        if (property == null) {
            return;
        }
        switch (formatCode) {
            case 2: {
                String[] rationalParts = property.split("/", 2);
                if (rationalParts.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(rationalParts[0]), (long)Float.parseFloat(rationalParts[1]));
                        directory.setRational(tagType, rational);
                    }
                    catch (NumberFormatException ex) {
                        directory.addError(String.format("Unable to parse XMP property %s as a Rational.", propName));
                    }
                    break;
                }
                directory.addError("Error in rational format for tag " + tagType);
                break;
            }
            case 3: {
                try {
                    directory.setInt(tagType, Integer.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an int.", propName));
                }
                break;
            }
            case 4: {
                try {
                    directory.setDouble(tagType, Double.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an double.", propName));
                }
                break;
            }
            case 1: {
                directory.setString(tagType, property);
                break;
            }
            default: {
                directory.addError(String.format("Unknown format code %d for tag %d", formatCode, tagType));
            }
        }
    }

    private static void processXmpDateTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, @NotNull String schemaNS, @NotNull String propName, int tagType) throws XMPException {
        Calendar cal = meta.getPropertyCalendar(schemaNS, propName);
        if (cal != null) {
            directory.setDate(tagType, cal.getTime());
        }
    }
}

