/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.Rational;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.ExifTiffHandler;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import com.drew.metadata.iptc.IptcReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private boolean _storeThumbnailBytes = true;

    public boolean isStoreThumbnailBytes() {
        return this._storeThumbnailBytes;
    }

    public void setStoreThumbnailBytes(boolean storeThumbnailBytes) {
        this._storeThumbnailBytes = storeThumbnailBytes;
    }

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(@NotNull byte[] segmentBytes, @NotNull JpegSegmentType segmentType) {
        return segmentBytes.length >= JPEG_EXIF_SEGMENT_PREAMBLE.length() && new String(segmentBytes, 0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equalsIgnoreCase(JPEG_EXIF_SEGMENT_PREAMBLE);
    }

    @Override
    public void extract(@NotNull byte[] segmentBytes, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        if (segmentBytes == null) {
            throw new NullPointerException("segmentBytes cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        if (segmentType == null) {
            throw new NullPointerException("segmentType cannot be null");
        }
        try {
            ByteArrayReader reader = new ByteArrayReader(segmentBytes);
            try {
                if (!reader.getString(0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equals(JPEG_EXIF_SEGMENT_PREAMBLE)) {
                    System.err.println("Invalid JPEG Exif segment preamble");
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return;
            }
            new TiffReader().processTiff(reader, new ExifTiffHandler(metadata, this._storeThumbnailBytes), JPEG_EXIF_SEGMENT_PREAMBLE.length());
        }
        catch (TiffProcessingException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    @Deprecated
    public void extractTiff(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        ExifIFD0Directory directory = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
        try {
            ExifReader.extractTiff(reader, metadata, directory, 0);
        }
        catch (IOException e) {
            directory.addError("IO problem: " + e.getMessage());
        }
    }

    @Deprecated
    private static void extractTiff(@NotNull RandomAccessReader reader, @NotNull Metadata metadata, @NotNull Directory firstDirectory, int tiffHeaderOffset) throws IOException {
        String byteOrderIdentifier = reader.getString(tiffHeaderOffset, 2);
        if ("MM".equals(byteOrderIdentifier)) {
            reader.setMotorolaByteOrder(true);
        } else if ("II".equals(byteOrderIdentifier)) {
            reader.setMotorolaByteOrder(false);
        } else {
            firstDirectory.addError("Unclear distinction between Motorola/Intel byte ordering: " + byteOrderIdentifier);
            return;
        }
        int tiffMarker = reader.getUInt16(2 + tiffHeaderOffset);
        int standardTiffMarker = 42;
        int olympusRawTiffMarker = 20306;
        int panasonicRawTiffMarker = 85;
        if (tiffMarker != 42 && tiffMarker != 20306 && tiffMarker != 85) {
            firstDirectory.addError("Unexpected TIFF marker after byte order identifier: 0x" + Integer.toHexString(tiffMarker));
            return;
        }
        int firstIfdOffset = reader.getInt32(4 + tiffHeaderOffset) + tiffHeaderOffset;
        if ((long)firstIfdOffset >= reader.getLength() - 1L) {
            firstDirectory.addError("First Exif directory offset is beyond end of Exif data segment");
            firstIfdOffset = 14;
        }
        HashSet<Integer> processedIfdOffsets = new HashSet<Integer>();
        ExifReader.processIFD(firstDirectory, processedIfdOffsets, firstIfdOffset, tiffHeaderOffset, metadata, reader);
        ExifThumbnailDirectory thumbnailDirectory = metadata.getDirectory(ExifThumbnailDirectory.class);
        if (thumbnailDirectory != null && thumbnailDirectory.containsTag(259)) {
            Integer offset = thumbnailDirectory.getInteger(513);
            Integer length = thumbnailDirectory.getInteger(514);
            if (offset != null && length != null) {
                try {
                    byte[] thumbnailData = reader.getBytes(tiffHeaderOffset + offset, length);
                    thumbnailDirectory.setThumbnailData(thumbnailData);
                }
                catch (IOException ex) {
                    firstDirectory.addError("Invalid thumbnail data specification: " + ex.getMessage());
                }
            }
        }
    }

    @Deprecated
    private static void processIFD(@NotNull Directory directory, @NotNull Set<Integer> processedIfdOffsets, int ifdOffset, int tiffHeaderOffset, @NotNull Metadata metadata, @NotNull RandomAccessReader reader) throws IOException {
        if (processedIfdOffsets.contains(ifdOffset)) {
            return;
        }
        processedIfdOffsets.add(ifdOffset);
        if ((long)ifdOffset >= reader.getLength() || ifdOffset < 0) {
            directory.addError("Ignored IFD marked to start outside data segment");
            return;
        }
        int dirTagCount = reader.getUInt16(ifdOffset);
        int dirLength = 2 + 12 * dirTagCount + 4;
        if ((long)(dirLength + ifdOffset) > reader.getLength()) {
            directory.addError("Illegally sized IFD");
            return;
        }
        for (int tagNumber = 0; tagNumber < dirTagCount; ++tagNumber) {
            int subDirOffset;
            int tagValueOffset;
            int tagOffset = ExifReader.calculateTagOffset(ifdOffset, tagNumber);
            int tagType = reader.getUInt16(tagOffset);
            int formatCode = reader.getUInt16(tagOffset + 2);
            if (formatCode < 1 || formatCode > 12) {
                directory.addError("Invalid TIFF tag format code: " + formatCode);
                return;
            }
            int componentCount = reader.getInt32(tagOffset + 4);
            if (componentCount < 0) {
                directory.addError("Negative TIFF tag component count");
                continue;
            }
            int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
            if (byteCount > 4) {
                int offsetVal = reader.getInt32(tagOffset + 8);
                if ((long)(offsetVal + byteCount) > reader.getLength()) {
                    directory.addError("Illegal TIFF tag pointer offset");
                    continue;
                }
                tagValueOffset = tiffHeaderOffset + offsetVal;
            } else {
                tagValueOffset = tagOffset + 8;
            }
            if (tagValueOffset < 0 || (long)tagValueOffset > reader.getLength()) {
                directory.addError("Illegal TIFF tag pointer offset");
                continue;
            }
            if (byteCount < 0 || (long)(tagValueOffset + byteCount) > reader.getLength()) {
                directory.addError("Illegal number of bytes for TIFF tag data: " + byteCount);
                continue;
            }
            if (tagType == 34665 && directory instanceof ExifIFD0Directory) {
                if (byteCount != 4) {
                    directory.addError("Exif SubIFD Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                subDirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                ExifReader.processIFD(metadata.getOrCreateDirectory(ExifSubIFDDirectory.class), processedIfdOffsets, subDirOffset, tiffHeaderOffset, metadata, reader);
                continue;
            }
            if (tagType == 40965 && directory instanceof ExifSubIFDDirectory) {
                if (byteCount != 4) {
                    directory.addError("Exif Interop Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                subDirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                ExifReader.processIFD(metadata.getOrCreateDirectory(ExifInteropDirectory.class), processedIfdOffsets, subDirOffset, tiffHeaderOffset, metadata, reader);
                continue;
            }
            if (tagType == 34853 && directory instanceof ExifIFD0Directory) {
                if (byteCount != 4) {
                    directory.addError("Exif GPS Info Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                subDirOffset = tiffHeaderOffset + reader.getInt32(tagValueOffset);
                ExifReader.processIFD(metadata.getOrCreateDirectory(GpsDirectory.class), processedIfdOffsets, subDirOffset, tiffHeaderOffset, metadata, reader);
                continue;
            }
            if (tagType == 37500 && directory instanceof ExifSubIFDDirectory) {
                ExifReader.processMakernote(tagValueOffset, processedIfdOffsets, tiffHeaderOffset, metadata, reader);
                continue;
            }
            if (tagType == 33723 && directory instanceof ExifIFD0Directory) {
                byte[] c = reader.getBytes(tagValueOffset, byteCount);
                new IptcReader().extract(new SequentialByteArrayReader(c), metadata, c.length);
                continue;
            }
            ExifReader.processTag(directory, tagType, tagValueOffset, componentCount, formatCode, reader);
        }
        int finalTagOffset = ExifReader.calculateTagOffset(ifdOffset, dirTagCount);
        int nextDirectoryOffset = reader.getInt32(finalTagOffset);
        if (nextDirectoryOffset != 0) {
            if ((long)(nextDirectoryOffset += tiffHeaderOffset) >= reader.getLength()) {
                return;
            }
            if (nextDirectoryOffset < ifdOffset) {
                return;
            }
            ExifThumbnailDirectory nextDirectory = metadata.getOrCreateDirectory(ExifThumbnailDirectory.class);
            ExifReader.processIFD(nextDirectory, processedIfdOffsets, nextDirectoryOffset, tiffHeaderOffset, metadata, reader);
        }
    }

    @Deprecated
    private static void processMakernote(int makernoteOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull Metadata metadata, @NotNull RandomAccessReader reader) throws IOException {
        ExifIFD0Directory ifd0Directory = metadata.getDirectory(ExifIFD0Directory.class);
        if (ifd0Directory == null) {
            return;
        }
        String cameraMake = ifd0Directory.getString(271);
        String firstThreeChars = reader.getString(makernoteOffset, 3);
        String firstFourChars = reader.getString(makernoteOffset, 4);
        String firstFiveChars = reader.getString(makernoteOffset, 5);
        String firstSixChars = reader.getString(makernoteOffset, 6);
        String firstSevenChars = reader.getString(makernoteOffset, 7);
        String firstEightChars = reader.getString(makernoteOffset, 8);
        String firstTwelveChars = reader.getString(makernoteOffset, 12);
        boolean byteOrderBefore = reader.isMotorolaByteOrder();
        if ("OLYMP".equals(firstFiveChars) || "EPSON".equals(firstFiveChars) || "AGFA".equals(firstFourChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset, metadata, reader);
        } else if (cameraMake != null && cameraMake.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(firstFiveChars)) {
                switch (reader.getUInt8(makernoteOffset + 6)) {
                    case 1: {
                        ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType1MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset, metadata, reader);
                        break;
                    }
                    case 2: {
                        ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 18, makernoteOffset + 10, metadata, reader);
                        break;
                    }
                    default: {
                        ifd0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), processedIfdOffsets, makernoteOffset, tiffHeaderOffset, metadata, reader);
            }
        } else if ("SONY CAM".equals(firstEightChars) || "SONY DSC".equals(firstEightChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SonyType1MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset, metadata, reader);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(firstTwelveChars)) {
            reader.setMotorolaByteOrder(true);
            ExifReader.processIFD(metadata.getOrCreateDirectory(SonyType6MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 20, tiffHeaderOffset, metadata, reader);
        } else if ("SIGMA\u0000\u0000\u0000".equals(firstEightChars) || "FOVEON\u0000\u0000".equals(firstEightChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SigmaMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 10, tiffHeaderOffset, metadata, reader);
        } else if ("KDK".equals(firstThreeChars)) {
            reader.setMotorolaByteOrder(firstSevenChars.equals("KDK INFO"));
            ExifReader.processKodakMakernote(metadata.getOrCreateDirectory(KodakMakernoteDirectory.class), makernoteOffset, reader);
        } else if ("Canon".equalsIgnoreCase(cameraMake)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(CanonMakernoteDirectory.class), processedIfdOffsets, makernoteOffset, tiffHeaderOffset, metadata, reader);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(firstSixChars)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 6, tiffHeaderOffset, metadata, reader);
            } else {
                ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType1MakernoteDirectory.class), processedIfdOffsets, makernoteOffset, tiffHeaderOffset, metadata, reader);
            }
        } else if ("FUJIFILM".equals(firstEightChars) || "Fujifilm".equalsIgnoreCase(cameraMake)) {
            reader.setMotorolaByteOrder(false);
            int ifdStart = makernoteOffset + reader.getInt32(makernoteOffset + 8);
            ExifReader.processIFD(metadata.getOrCreateDirectory(FujifilmMakernoteDirectory.class), processedIfdOffsets, ifdStart, makernoteOffset, metadata, reader);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("MINOLTA")) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), processedIfdOffsets, makernoteOffset, tiffHeaderOffset, metadata, reader);
        } else if ("KYOCERA".equals(firstSevenChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(KyoceraMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 22, tiffHeaderOffset, metadata, reader);
        } else if ("LEICA".equals(firstFiveChars)) {
            reader.setMotorolaByteOrder(false);
            if ("Leica Camera AG".equals(cameraMake)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(LeicaMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset, metadata, reader);
            } else if ("LEICA".equals(cameraMake)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset, metadata, reader);
            }
        } else if ("Panasonic\u0000\u0000\u0000".equals(reader.getString(makernoteOffset, 12))) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset, metadata, reader);
        } else if ("AOC\u0000".equals(firstFourChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 6, makernoteOffset, metadata, reader);
        } else if (cameraMake != null && (cameraMake.toUpperCase().startsWith("PENTAX") || cameraMake.toUpperCase().startsWith("ASAHI"))) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(PentaxMakernoteDirectory.class), processedIfdOffsets, makernoteOffset, makernoteOffset, metadata, reader);
        } else if ("SANYO\u0000\u0001\u0000".equals(firstEightChars)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SanyoMakernoteDirectory.class), processedIfdOffsets, makernoteOffset + 8, makernoteOffset, metadata, reader);
        }
        reader.setMotorolaByteOrder(byteOrderBefore);
    }

    @Deprecated
    private static void processKodakMakernote(@NotNull KodakMakernoteDirectory directory, int tagValueOffset, @NotNull RandomAccessReader reader) {
        int dataOffset = tagValueOffset + 8;
        try {
            directory.setString(0, reader.getString(dataOffset, 8));
            directory.setInt(9, reader.getUInt8(dataOffset + 9));
            directory.setInt(10, reader.getUInt8(dataOffset + 10));
            directory.setInt(12, reader.getUInt16(dataOffset + 12));
            directory.setInt(14, reader.getUInt16(dataOffset + 14));
            directory.setInt(16, reader.getUInt16(dataOffset + 16));
            directory.setByteArray(18, reader.getBytes(dataOffset + 18, 2));
            directory.setByteArray(20, reader.getBytes(dataOffset + 20, 4));
            directory.setInt(24, reader.getUInt16(dataOffset + 24));
            directory.setInt(27, reader.getUInt8(dataOffset + 27));
            directory.setInt(28, reader.getUInt8(dataOffset + 28));
            directory.setInt(29, reader.getUInt8(dataOffset + 29));
            directory.setInt(30, reader.getUInt16(dataOffset + 30));
            directory.setLong(32, reader.getUInt32(dataOffset + 32));
            directory.setInt(36, reader.getInt16(dataOffset + 36));
            directory.setInt(56, reader.getUInt8(dataOffset + 56));
            directory.setInt(64, reader.getUInt8(dataOffset + 64));
            directory.setInt(92, reader.getUInt8(dataOffset + 92));
            directory.setInt(93, reader.getUInt8(dataOffset + 93));
            directory.setInt(94, reader.getUInt16(dataOffset + 94));
            directory.setInt(96, reader.getUInt16(dataOffset + 96));
            directory.setInt(98, reader.getUInt16(dataOffset + 98));
            directory.setInt(100, reader.getUInt16(dataOffset + 100));
            directory.setInt(102, reader.getUInt16(dataOffset + 102));
            directory.setInt(104, reader.getUInt16(dataOffset + 104));
            directory.setInt(107, reader.getInt8(dataOffset + 107));
        }
        catch (IOException ex) {
            directory.addError("Error processing Kodak makernote data: " + ex.getMessage());
        }
    }

    @Deprecated
    private static void processTag(@NotNull Directory directory, int tagType, int tagValueOffset, int componentCount, int formatCode, @NotNull RandomAccessReader reader) throws IOException {
        switch (formatCode) {
            case 7: {
                directory.setByteArray(tagType, reader.getBytes(tagValueOffset, componentCount));
                break;
            }
            case 2: {
                String string = reader.getNullTerminatedString(tagValueOffset, componentCount);
                directory.setString(tagType, string);
                break;
            }
            case 10: {
                if (componentCount == 1) {
                    directory.setRational(tagType, new Rational(reader.getInt32(tagValueOffset), reader.getInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational(reader.getInt32(tagValueOffset + 8 * i), reader.getInt32(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 5: {
                if (componentCount == 1) {
                    directory.setRational(tagType, new Rational(reader.getUInt32(tagValueOffset), reader.getUInt32(tagValueOffset + 4)));
                    break;
                }
                if (componentCount <= 1) break;
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational(reader.getUInt32(tagValueOffset + 8 * i), reader.getUInt32(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 11: {
                if (componentCount == 1) {
                    directory.setFloat(tagType, reader.getFloat32(tagValueOffset));
                    break;
                }
                float[] floats = new float[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    floats[i] = reader.getFloat32(tagValueOffset + i * 4);
                }
                directory.setFloatArray(tagType, floats);
                break;
            }
            case 12: {
                if (componentCount == 1) {
                    directory.setDouble(tagType, reader.getDouble64(tagValueOffset));
                    break;
                }
                double[] doubles = new double[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    doubles[i] = reader.getDouble64(tagValueOffset + i * 4);
                }
                directory.setDoubleArray(tagType, doubles);
                break;
            }
            case 6: {
                if (componentCount == 1) {
                    directory.setInt(tagType, reader.getInt8(tagValueOffset));
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = reader.getInt8(tagValueOffset + i);
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 1: {
                if (componentCount == 1) {
                    directory.setInt(tagType, reader.getUInt8(tagValueOffset));
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = reader.getUInt8(tagValueOffset + i);
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 3: {
                if (componentCount == 1) {
                    int i = reader.getUInt16(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getUInt16(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 8: {
                if (componentCount == 1) {
                    short i = reader.getInt16(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getInt16(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 4: 
            case 9: {
                if (componentCount == 1) {
                    int i = reader.getInt32(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = reader.getInt32(tagValueOffset + i * 4);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            default: {
                directory.addError("Unknown format code " + formatCode + " for tag " + tagType);
            }
        }
    }

    @Deprecated
    private static int calculateTagOffset(int ifdStartOffset, int entryNumber) {
        return ifdStartOffset + 2 + 12 * entryNumber;
    }
}

