/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngChunkReader {
    private static final byte[] PNG_SIGNATURE_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public Iterable<PngChunk> extract(@NotNull SequentialReader reader, @Nullable Set<PngChunkType> desiredChunkTypes) throws PngProcessingException, IOException {
        reader.setMotorolaByteOrder(true);
        if (!Arrays.equals(PNG_SIGNATURE_BYTES, reader.getBytes(PNG_SIGNATURE_BYTES.length))) {
            throw new PngProcessingException("PNG signature mismatch");
        }
        boolean seenImageHeader = false;
        boolean seenImageTrailer = false;
        ArrayList<PngChunk> chunks = new ArrayList<PngChunk>();
        HashSet<PngChunkType> seenChunkTypes = new HashSet<PngChunkType>();
        while (!seenImageTrailer) {
            int chunkDataLength = reader.getInt32();
            PngChunkType chunkType = new PngChunkType(reader.getBytes(4));
            byte[] chunkData = reader.getBytes(chunkDataLength);
            reader.skip(4L);
            if (seenChunkTypes.contains(chunkType) && !chunkType.areMultipleAllowed()) {
                throw new PngProcessingException(String.format("Observed multiple instances of PNG chunk '%s', for which multiples are not allowed", chunkType));
            }
            if (chunkType.equals(PngChunkType.IHDR)) {
                seenImageHeader = true;
            } else if (!seenImageHeader) {
                throw new PngProcessingException(String.format("First chunk should be '%s', but '%s' was observed", PngChunkType.IHDR, chunkType));
            }
            if (chunkType.equals(PngChunkType.IEND)) {
                seenImageTrailer = true;
            }
            if (desiredChunkTypes == null || desiredChunkTypes.contains(chunkType)) {
                chunks.add(new PngChunk(chunkType, chunkData));
            }
            seenChunkTypes.add(chunkType);
        }
        return chunks;
    }
}

