/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class ImageMetadataReader {
    private static final int JPEG_FILE_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final int PSD_MAGIC_NUMBER = 14402;
    private static final int PNG_MAGIC_NUMBER = 35152;
    private static final int BMP_MAGIC_NUMBER = 16973;
    private static final int GIF_MAGIC_NUMBER = 18249;

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws ImageProcessingException, IOException {
        InputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        int magicNumber = ImageMetadataReader.peekMagicNumber(bufferedInputStream);
        if (magicNumber == -1) {
            throw new ImageProcessingException("Could not determine file's magic number.");
        }
        if ((magicNumber & 0xFFD8) == 65496) {
            return JpegMetadataReader.readMetadata(bufferedInputStream);
        }
        if (magicNumber == 18761 || magicNumber == 19789) {
            return TiffMetadataReader.readMetadata(bufferedInputStream);
        }
        if (magicNumber == 14402) {
            return PsdMetadataReader.readMetadata(bufferedInputStream);
        }
        if (magicNumber == 35152) {
            return PngMetadataReader.readMetadata(bufferedInputStream);
        }
        if (magicNumber == 16973) {
            return BmpMetadataReader.readMetadata(bufferedInputStream);
        }
        if (magicNumber == 18249) {
            return GifMetadataReader.readMetadata(bufferedInputStream);
        }
        throw new ImageProcessingException("File format is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            Metadata metadata = ImageMetadataReader.readMetadata(inputStream);
            return metadata;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    private static int peekMagicNumber(@NotNull InputStream inputStream) throws IOException {
        inputStream.mark(2);
        int byte1 = inputStream.read();
        int byte2 = inputStream.read();
        inputStream.reset();
        if (byte1 == -1 || byte2 == -1) {
            return -1;
        }
        return byte1 << 8 | byte2;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] args) throws MetadataException, IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean thumbRequested = argList.remove("-thumb");
        boolean markdownFormat = argList.remove("-markdown");
        boolean showHex = argList.remove("-hex");
        if (argList.size() < 1) {
            String version = ImageMetadataReader.class.getPackage().getImplementationVersion();
            System.out.println("metadata-extractor version " + version);
            System.out.println();
            System.out.println(String.format("Usage: java -jar metadata-extractor-%s.jar <filename> [<filename>] [-thumb] [-markdown] [-hex]", version == null ? "a.b.c" : version));
            System.exit(1);
        }
        for (String filePath : argList) {
            long startTime = System.nanoTime();
            File file = new File(filePath);
            if (!markdownFormat && argList.size() > 1) {
                System.out.printf("\n***** PROCESSING: %s\n%n", filePath);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            long took = System.nanoTime() - startTime;
            if (!markdownFormat) {
                System.out.printf("Processed %.3f MB file in %.2f ms%n%n", (double)file.length() / 1048576.0, (double)took / 1000000.0);
            }
            if (markdownFormat) {
                String fileName = file.getName();
                String urlName = StringUtil.urlEncode(fileName);
                ExifIFD0Directory exifIFD0Directory = metadata.getDirectory(ExifIFD0Directory.class);
                String make = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(271);
                String model = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(272);
                System.out.println();
                System.out.println("---");
                System.out.println();
                System.out.printf("# %s - %s%n", make, model);
                System.out.println();
                System.out.printf("<a href=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\">%n", urlName);
                System.out.printf("<img src=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\" width=\"300\"/><br/>%n", urlName);
                System.out.println(fileName);
                System.out.println("</a>");
                System.out.println();
                System.out.println("Directory | Tag Id | Tag Name | Extracted Value");
                System.out.println(":--------:|-------:|----------|----------------");
            }
            for (Directory directory : metadata.getDirectories()) {
                String directoryName = directory.getName();
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String description = tag.getDescription();
                    if (description != null && description.length() > 1024) {
                        description = description.substring(0, 1024) + "...";
                    }
                    if (markdownFormat) {
                        System.out.printf("%s|0x%s|%s|%s%n", directoryName, Integer.toHexString(tag.getTagType()), tagName, description);
                        continue;
                    }
                    if (showHex) {
                        System.out.printf("[%s - %s] %s = %s%n", directoryName, tag.getTagTypeHex(), tagName, description);
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", directoryName, tagName, description);
                }
                for (String error : directory.getErrors()) {
                    System.err.println("ERROR: " + error);
                }
            }
            if (args.length <= 1 || !thumbRequested) continue;
            ExifThumbnailDirectory directory = metadata.getDirectory(ExifThumbnailDirectory.class);
            if (directory != null && directory.hasThumbnailData()) {
                System.out.println("Writing thumbnail...");
                directory.writeThumbnail(args[0].trim() + ".thumb.jpg");
                continue;
            }
            System.out.println("No thumbnail data exists in this image");
        }
    }
}

