/*
 * Decompiled with CFR 0.152.
 */
package com.dr.ktjsonschema;

import com.dr.ktjsonschema.JsonSchemaConfig;
import com.dr.ktjsonschema.JsonSchemaGenerator;
import com.dr.ktjsonschema.annotations.JsonSchemaDefault;
import com.dr.ktjsonschema.annotations.JsonSchemaDescription;
import com.dr.ktjsonschema.annotations.JsonSchemaFormat;
import com.dr.ktjsonschema.annotations.JsonSchemaTitle;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.Annotations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\t)*+,-./01B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013J.\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0015J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\"\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\u0003H\u0007J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator;", "", "rootObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "config", "Lcom/dr/ktjsonschema/JsonSchemaConfig;", "debug", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/dr/ktjsonschema/JsonSchemaConfig;Z)V", "getConfig", "()Lcom/dr/ktjsonschema/JsonSchemaConfig;", "getDebug", "()Z", "getRootObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "generateJsonSchema", "Lcom/fasterxml/jackson/databind/JsonNode;", "T", "clazz", "Ljava/lang/Class;", "title", "", "description", "generateTitleFromPropertyName", "propertyName", "resolvePropertyFormat", "jsonSchemaFormatAnnotation", "Lcom/dr/ktjsonschema/annotations/JsonSchemaFormat;", "rawClassName", "prop", "Lcom/fasterxml/jackson/databind/BeanProperty;", "_type", "Lcom/fasterxml/jackson/databind/JavaType;", "objectMapper", "resolveType", "propertyType", "setFormat", "", "node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "format", "Companion", "DefinitionInfo", "DefinitionsHandler", "EnumSupport", "MyJsonFormatVisitorWrapper", "MySerializerProvider", "PolymorphismInfo", "PropertyNode", "WorkInProgress", "ktjsonschema_main"})
public final class JsonSchemaGenerator {
    @org.jetbrains.annotations.NotNull
    private final ObjectMapper rootObjectMapper;
    @org.jetbrains.annotations.NotNull
    private final JsonSchemaConfig config;
    private final boolean debug;
    @org.jetbrains.annotations.NotNull
    private static final String JSON_SCHEMA_DRAFT_4_URL = "http://json-schema.org/draft-04/schema#";
    public static final Companion Companion = new Companion(null);

    private final void setFormat(ObjectNode node, String format) {
        node.put("format", format);
    }

    @org.jetbrains.annotations.NotNull
    public final String generateTitleFromPropertyName(@org.jetbrains.annotations.NotNull String propertyName) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        CharSequence charSequence = propertyName;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s|%s|%s";
        Object[] objectArray = new Object[]{"(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"};
        Object object = regex;
        Object object2 = regex;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        object(string3);
        stringCompanionObject = object2;
        string = " ";
        String s = stringCompanionObject.replace(charSequence, string);
        charSequence = s;
        int n = 0;
        int n2 = 1;
        object2 = new StringBuilder();
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = ((String)charSequence2).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        object = string4;
        charSequence = object;
        CharSequence charSequence3 = charSequence;
        if (charSequence3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = ((String)charSequence3).toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        object = string5;
        charSequence = s;
        n = 1;
        object2 = ((StringBuilder)object2).append((String)object);
        CharSequence charSequence4 = charSequence;
        if (charSequence4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = ((String)charSequence4).substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        object = string6;
        return ((StringBuilder)object2).append((String)object).toString();
    }

    @Nullable
    public final String resolvePropertyFormat(@org.jetbrains.annotations.NotNull JavaType _type, @org.jetbrains.annotations.NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)_type, (String)"_type");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        AnnotatedClass ac = AnnotatedClass.construct((JavaType)_type, (MapperConfig)((MapperConfig)objectMapper.getDeserializationConfig()));
        JsonSchemaFormat jsonSchemaFormat = (JsonSchemaFormat)ac.getAnnotation(JsonSchemaFormat.class);
        String string = _type.getRawClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"_type.rawClass.name");
        return this.resolvePropertyFormat(jsonSchemaFormat, string);
    }

    @Nullable
    public final String resolvePropertyFormat(@org.jetbrains.annotations.NotNull BeanProperty prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        JsonSchemaFormat jsonSchemaFormat = (JsonSchemaFormat)prop.getAnnotation(JsonSchemaFormat.class);
        String string = prop.getType().getRawClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prop.type.rawClass.name");
        return this.resolvePropertyFormat(jsonSchemaFormat, string);
    }

    @Nullable
    public final String resolvePropertyFormat(@Nullable JsonSchemaFormat jsonSchemaFormatAnnotation, @org.jetbrains.annotations.NotNull String rawClassName) {
        Intrinsics.checkParameterIsNotNull((Object)rawClassName, (String)"rawClassName");
        if (jsonSchemaFormatAnnotation != null) {
            return jsonSchemaFormatAnnotation.value();
        }
        return this.config.getCustomType2FormatMapping().get(rawClassName);
    }

    @org.jetbrains.annotations.NotNull
    public final JavaType resolveType(@org.jetbrains.annotations.NotNull JavaType propertyType, @Nullable BeanProperty prop, @org.jetbrains.annotations.NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)propertyType, (String)"propertyType");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        if (prop != null) {
            JsonDeserialize jsonDeserialize = (JsonDeserialize)prop.getAnnotation(JsonDeserialize.class);
            if (jsonDeserialize != null) {
                JsonDeserialize jsonDeserialize2 = jsonDeserialize;
                JsonDeserialize it = jsonDeserialize2;
                JavaType javaType = objectMapper.getTypeFactory().uncheckedSimpleType(it.contentAs());
                Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"objectMapper.typeFactory\u2026leType(it.contentAs.java)");
                return javaType;
            }
        }
        JavaType javaType = propertyType.containedType(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"propertyType.containedType(0)");
        return javaType;
    }

    @org.jetbrains.annotations.NotNull
    public final <T> JsonNode generateJsonSchema(@org.jetbrains.annotations.NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.generateJsonSchema(clazz, null, null);
    }

    @org.jetbrains.annotations.NotNull
    public final <T> JsonNode generateJsonSchema(@org.jetbrains.annotations.NotNull Class<T> clazz, @Nullable String title, @Nullable String description) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        rootNode.put("$schema", Companion.getJSON_SCHEMA_DRAFT_4_URL());
        if (title == null) {
            String string = clazz.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.simpleName");
            rootNode.put("title", this.generateTitleFromPropertyName(string));
        } else {
            rootNode.put("title", title);
        }
        String string = description;
        if (string != null) {
            String string2 = string;
            String it = string2;
            rootNode.put("description", it);
        }
        DefinitionsHandler definitionsHandler = new DefinitionsHandler();
        ObjectNode objectNode = rootNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"rootNode");
        MyJsonFormatVisitorWrapper rootVisitor = new MyJsonFormatVisitorWrapper(this, this.rootObjectMapper, 0, objectNode, definitionsHandler, null, 2, null);
        this.rootObjectMapper.acceptJsonFormatVisitor(clazz, (JsonFormatVisitorWrapper)rootVisitor);
        ObjectNode objectNode2 = definitionsHandler.getFinalDefinitionsNode();
        if (objectNode2 != null) {
            ObjectNode objectNode3 = objectNode2;
            ObjectNode it = objectNode3;
            rootNode.set("definitions", (JsonNode)it);
        }
        JsonNode jsonNode = (JsonNode)rootNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"rootNode");
        return jsonNode;
    }

    @org.jetbrains.annotations.NotNull
    public final ObjectMapper getRootObjectMapper() {
        return this.rootObjectMapper;
    }

    @org.jetbrains.annotations.NotNull
    public final JsonSchemaConfig getConfig() {
        return this.config;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    @JvmOverloads
    public JsonSchemaGenerator(@org.jetbrains.annotations.NotNull ObjectMapper rootObjectMapper, @org.jetbrains.annotations.NotNull JsonSchemaConfig config, boolean debug) {
        Intrinsics.checkParameterIsNotNull((Object)rootObjectMapper, (String)"rootObjectMapper");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.rootObjectMapper = rootObjectMapper;
        this.config = config;
        this.debug = debug;
    }

    @JvmOverloads
    public /* synthetic */ JsonSchemaGenerator(ObjectMapper objectMapper, JsonSchemaConfig jsonSchemaConfig, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jsonSchemaConfig = JsonSchemaConfig.Companion.getVanillaJsonSchemaDraft4();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(objectMapper, jsonSchemaConfig, bl);
    }

    @JvmOverloads
    public JsonSchemaGenerator(@org.jetbrains.annotations.NotNull ObjectMapper rootObjectMapper, @org.jetbrains.annotations.NotNull JsonSchemaConfig config) {
        this(rootObjectMapper, config, false, 4, null);
    }

    @JvmOverloads
    public JsonSchemaGenerator(@org.jetbrains.annotations.NotNull ObjectMapper rootObjectMapper) {
        this(rootObjectMapper, null, false, 6, null);
    }

    static {
        JSON_SCHEMA_DRAFT_4_URL = JSON_SCHEMA_DRAFT_4_URL;
    }

    @org.jetbrains.annotations.NotNull
    public static final String getJSON_SCHEMA_DRAFT_4_URL() {
        return Companion.getJSON_SCHEMA_DRAFT_4_URL();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$MySerializerProvider;", "", "()V", "_provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "get_provider", "()Lcom/fasterxml/jackson/databind/SerializerProvider;", "set_provider", "(Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "getProvider", "setProvider", "", "provider", "ktjsonschema_main"})
    public static class MySerializerProvider {
        @Nullable
        private SerializerProvider _provider;

        @Nullable
        public final SerializerProvider get_provider() {
            return this._provider;
        }

        public final void set_provider(@Nullable SerializerProvider serializerProvider) {
            this._provider = serializerProvider;
        }

        public final void setProvider(@Nullable SerializerProvider provider) {
            this._provider = provider;
        }

        @org.jetbrains.annotations.NotNull
        public final SerializerProvider getProvider() {
            SerializerProvider serializerProvider = this._provider;
            if (serializerProvider == null) {
                Intrinsics.throwNpe();
            }
            return serializerProvider;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$EnumSupport;", "", "()V", "_node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "get_node", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "enumTypes", "", "enums", "", "", "ktjsonschema_main"})
    public static abstract class EnumSupport {
        @org.jetbrains.annotations.NotNull
        public abstract ObjectNode get_node();

        public final void enumTypes(@Nullable Set<String> enums) {
            block1: {
                ArrayNode enumValuesNode = JsonNodeFactory.instance.arrayNode();
                this.get_node().set("enum", (JsonNode)enumValuesNode);
                Set<String> set = enums;
                if (set == null) break block1;
                Iterable $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    enumValuesNode.add(it);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionInfo;", "", "ref", "", "jsonObjectFormatVisitor", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;)V", "getJsonObjectFormatVisitor", "()Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "getRef", "()Ljava/lang/String;", "component1", "component2", "copy", "ktjsonschema_main"})
    public static final class DefinitionInfo {
        @Nullable
        private final String ref;
        @Nullable
        private final JsonObjectFormatVisitor jsonObjectFormatVisitor;

        @Nullable
        public final String getRef() {
            return this.ref;
        }

        @Nullable
        public final JsonObjectFormatVisitor getJsonObjectFormatVisitor() {
            return this.jsonObjectFormatVisitor;
        }

        public DefinitionInfo(@Nullable String ref, @Nullable JsonObjectFormatVisitor jsonObjectFormatVisitor) {
            this.ref = ref;
            this.jsonObjectFormatVisitor = jsonObjectFormatVisitor;
        }

        @Nullable
        public final String component1() {
            return this.ref;
        }

        @Nullable
        public final JsonObjectFormatVisitor component2() {
            return this.jsonObjectFormatVisitor;
        }

        @org.jetbrains.annotations.NotNull
        public final DefinitionInfo copy(@Nullable String ref, @Nullable JsonObjectFormatVisitor jsonObjectFormatVisitor) {
            return new DefinitionInfo(ref, jsonObjectFormatVisitor);
        }

        @org.jetbrains.annotations.NotNull
        public static /* bridge */ /* synthetic */ DefinitionInfo copy$default(DefinitionInfo definitionInfo, String string, JsonObjectFormatVisitor jsonObjectFormatVisitor, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = definitionInfo.ref;
            }
            if ((n & 2) != 0) {
                jsonObjectFormatVisitor = definitionInfo.jsonObjectFormatVisitor;
            }
            return definitionInfo.copy(string, jsonObjectFormatVisitor);
        }

        public String toString() {
            return "DefinitionInfo(ref=" + this.ref + ", jsonObjectFormatVisitor=" + this.jsonObjectFormatVisitor + ")";
        }

        public int hashCode() {
            String string = this.ref;
            JsonObjectFormatVisitor jsonObjectFormatVisitor = this.jsonObjectFormatVisitor;
            return (string != null ? string.hashCode() : 0) * 31 + (jsonObjectFormatVisitor != null ? jsonObjectFormatVisitor.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DefinitionInfo)) break block3;
                    DefinitionInfo definitionInfo = (DefinitionInfo)object;
                    if (!Intrinsics.areEqual((Object)this.ref, (Object)definitionInfo.ref) || !Intrinsics.areEqual((Object)this.jsonObjectFormatVisitor, (Object)definitionInfo.jsonObjectFormatVisitor)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$WorkInProgress;", "", "classInProgress", "Ljava/lang/Class;", "nodeInProgress", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getClassInProgress", "()Ljava/lang/Class;", "getNodeInProgress", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "component1", "component2", "copy", "ktjsonschema_main"})
    public static final class WorkInProgress {
        @org.jetbrains.annotations.NotNull
        private final Class<?> classInProgress;
        @org.jetbrains.annotations.NotNull
        private final ObjectNode nodeInProgress;

        @org.jetbrains.annotations.NotNull
        public final Class<?> getClassInProgress() {
            return this.classInProgress;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode getNodeInProgress() {
            return this.nodeInProgress;
        }

        public WorkInProgress(@org.jetbrains.annotations.NotNull Class<?> classInProgress, @org.jetbrains.annotations.NotNull ObjectNode nodeInProgress) {
            Intrinsics.checkParameterIsNotNull(classInProgress, (String)"classInProgress");
            Intrinsics.checkParameterIsNotNull((Object)nodeInProgress, (String)"nodeInProgress");
            this.classInProgress = classInProgress;
            this.nodeInProgress = nodeInProgress;
        }

        @org.jetbrains.annotations.NotNull
        public final Class<?> component1() {
            return this.classInProgress;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode component2() {
            return this.nodeInProgress;
        }

        @org.jetbrains.annotations.NotNull
        public final WorkInProgress copy(@org.jetbrains.annotations.NotNull Class<?> classInProgress, @org.jetbrains.annotations.NotNull ObjectNode nodeInProgress) {
            Intrinsics.checkParameterIsNotNull(classInProgress, (String)"classInProgress");
            Intrinsics.checkParameterIsNotNull((Object)nodeInProgress, (String)"nodeInProgress");
            return new WorkInProgress(classInProgress, nodeInProgress);
        }

        @org.jetbrains.annotations.NotNull
        public static /* bridge */ /* synthetic */ WorkInProgress copy$default(WorkInProgress workInProgress, Class clazz, ObjectNode objectNode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                clazz = workInProgress.classInProgress;
            }
            if ((n & 2) != 0) {
                objectNode = workInProgress.nodeInProgress;
            }
            return workInProgress.copy(clazz, objectNode);
        }

        public String toString() {
            return "WorkInProgress(classInProgress=" + this.classInProgress + ", nodeInProgress=" + this.nodeInProgress + ")";
        }

        public int hashCode() {
            Class<?> clazz = this.classInProgress;
            ObjectNode objectNode = this.nodeInProgress;
            return (clazz != null ? clazz.hashCode() : 0) * 31 + (objectNode != null ? objectNode.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WorkInProgress)) break block3;
                    WorkInProgress workInProgress = (WorkInProgress)object;
                    if (!Intrinsics.areEqual(this.classInProgress, workInProgress.classInProgress) || !Intrinsics.areEqual((Object)this.nodeInProgress, (Object)workInProgress.nodeInProgress)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u00062\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0005J\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ(\u0010\u0011\u001a\u00020\u00122\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00052\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionsHandler;", "", "(Lcom/dr/ktjsonschema/JsonSchemaGenerator;)V", "class2Ref", "Ljava/util/HashMap;", "Ljava/lang/Class;", "", "definitionsNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "kotlin.jvm.PlatformType", "workInProgress", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$WorkInProgress;", "workInProgressStack", "", "getDefinitionName", "clazz", "getFinalDefinitionsNode", "getOrCreateDefinition", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionInfo;", "objectDefinitionBuilder", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "popworkInProgress", "", "pushWorkInProgress", "ktjsonschema_main"})
    public final class DefinitionsHandler {
        private HashMap<Class<?>, String> class2Ref = new HashMap();
        private final ObjectNode definitionsNode = JsonNodeFactory.instance.objectNode();
        private WorkInProgress workInProgress;
        private List<WorkInProgress> workInProgressStack = CollectionsKt.mutableListOf((Object[])new WorkInProgress[0]);

        public final void pushWorkInProgress() {
            Collection collection = this.workInProgressStack;
            List<WorkInProgress> list = this.workInProgressStack;
            int n = collection.size();
            list.add(n, this.workInProgress);
            this.workInProgress = null;
        }

        public final void popworkInProgress() {
            Collection collection = this.workInProgressStack;
            int item = collection.size() - 1;
            this.workInProgress = this.workInProgressStack.remove(item);
        }

        @org.jetbrains.annotations.NotNull
        public final String getDefinitionName(@org.jetbrains.annotations.NotNull Class<?> clazz) {
            String string;
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            if (JsonSchemaGenerator.this.getConfig().getUseTypeIdForDefinitionName()) {
                String string2 = clazz.getName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"clazz.name");
            } else {
                String string3 = clazz.getSimpleName();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"clazz.simpleName");
            }
            return string;
        }

        @org.jetbrains.annotations.NotNull
        public final DefinitionInfo getOrCreateDefinition(@org.jetbrains.annotations.NotNull Class<?> clazz, @org.jetbrains.annotations.NotNull Function1<? super ObjectNode, ? extends JsonObjectFormatVisitor> objectDefinitionBuilder) {
            ObjectNode node;
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull(objectDefinitionBuilder, (String)"objectDefinitionBuilder");
            String ref = this.class2Ref.get(clazz);
            if (ref != null) {
                if (this.workInProgress != null) {
                    WorkInProgress workInProgress = this.workInProgress;
                    if (workInProgress == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual(clazz, workInProgress.getClassInProgress()) ^ true) {
                        StringBuilder stringBuilder = new StringBuilder().append("Wrong class - working on ");
                        WorkInProgress workInProgress2 = this.workInProgress;
                        if (workInProgress2 == null) {
                            Intrinsics.throwNpe();
                        }
                        throw (Throwable)new Exception(stringBuilder.append(workInProgress2.getClassInProgress()).append(" - got ").append(clazz).toString());
                    }
                    String string = null;
                    WorkInProgress workInProgress3 = this.workInProgress;
                    if (workInProgress3 == null) {
                        Intrinsics.throwNpe();
                    }
                    return new DefinitionInfo(string, (JsonObjectFormatVisitor)objectDefinitionBuilder.invoke((Object)workInProgress3.getNodeInProgress()));
                }
                return new DefinitionInfo(ref, null);
            }
            int retryCount = 0;
            String shortRef = this.getDefinitionName(clazz);
            String longRef = "#/definitions/" + shortRef;
            while (this.class2Ref.values().contains(longRef)) {
                shortRef = clazz.getSimpleName() + "_" + ++retryCount;
                longRef = "#/definitions/" + clazz.getSimpleName() + "_" + retryCount;
            }
            this.class2Ref.put(clazz, longRef);
            ObjectNode objectNode = node = JsonNodeFactory.instance.objectNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"node");
            this.workInProgress = new WorkInProgress(clazz, objectNode);
            this.definitionsNode.set(shortRef, (JsonNode)node);
            ObjectNode objectNode2 = node;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectNode2, (String)"node");
            JsonObjectFormatVisitor jsonObjectFormatVisitor = (JsonObjectFormatVisitor)objectDefinitionBuilder.invoke((Object)objectNode2);
            this.workInProgress = null;
            return new DefinitionInfo(longRef, jsonObjectFormatVisitor);
        }

        @Nullable
        public final ObjectNode getFinalDefinitionsNode() {
            if (this.class2Ref.isEmpty()) {
                return null;
            }
            return this.definitionsNode;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$PolymorphismInfo;", "", "typePropertyName", "", "subTypeName", "(Ljava/lang/String;Ljava/lang/String;)V", "getSubTypeName", "()Ljava/lang/String;", "getTypePropertyName", "component1", "component2", "copy", "ktjsonschema_main"})
    public static final class PolymorphismInfo {
        @org.jetbrains.annotations.NotNull
        private final String typePropertyName;
        @org.jetbrains.annotations.NotNull
        private final String subTypeName;

        @org.jetbrains.annotations.NotNull
        public final String getTypePropertyName() {
            return this.typePropertyName;
        }

        @org.jetbrains.annotations.NotNull
        public final String getSubTypeName() {
            return this.subTypeName;
        }

        public PolymorphismInfo(@org.jetbrains.annotations.NotNull String typePropertyName, @org.jetbrains.annotations.NotNull String subTypeName) {
            Intrinsics.checkParameterIsNotNull((Object)typePropertyName, (String)"typePropertyName");
            Intrinsics.checkParameterIsNotNull((Object)subTypeName, (String)"subTypeName");
            this.typePropertyName = typePropertyName;
            this.subTypeName = subTypeName;
        }

        @org.jetbrains.annotations.NotNull
        public final String component1() {
            return this.typePropertyName;
        }

        @org.jetbrains.annotations.NotNull
        public final String component2() {
            return this.subTypeName;
        }

        @org.jetbrains.annotations.NotNull
        public final PolymorphismInfo copy(@org.jetbrains.annotations.NotNull String typePropertyName, @org.jetbrains.annotations.NotNull String subTypeName) {
            Intrinsics.checkParameterIsNotNull((Object)typePropertyName, (String)"typePropertyName");
            Intrinsics.checkParameterIsNotNull((Object)subTypeName, (String)"subTypeName");
            return new PolymorphismInfo(typePropertyName, subTypeName);
        }

        @org.jetbrains.annotations.NotNull
        public static /* bridge */ /* synthetic */ PolymorphismInfo copy$default(PolymorphismInfo polymorphismInfo, String string, String string2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = polymorphismInfo.typePropertyName;
            }
            if ((n & 2) != 0) {
                string2 = polymorphismInfo.subTypeName;
            }
            return polymorphismInfo.copy(string, string2);
        }

        public String toString() {
            return "PolymorphismInfo(typePropertyName=" + this.typePropertyName + ", subTypeName=" + this.subTypeName + ")";
        }

        public int hashCode() {
            String string = this.typePropertyName;
            String string2 = this.subTypeName;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PolymorphismInfo)) break block3;
                    PolymorphismInfo polymorphismInfo = (PolymorphismInfo)object;
                    if (!Intrinsics.areEqual((Object)this.typePropertyName, (Object)polymorphismInfo.typePropertyName) || !Intrinsics.areEqual((Object)this.subTypeName, (Object)polymorphismInfo.subTypeName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$PropertyNode;", "", "main", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "meta", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getMain", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getMeta", "component1", "component2", "copy", "ktjsonschema_main"})
    public static final class PropertyNode {
        @org.jetbrains.annotations.NotNull
        private final ObjectNode main;
        @org.jetbrains.annotations.NotNull
        private final ObjectNode meta;

        @org.jetbrains.annotations.NotNull
        public final ObjectNode getMain() {
            return this.main;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode getMeta() {
            return this.meta;
        }

        public PropertyNode(@org.jetbrains.annotations.NotNull ObjectNode main, @org.jetbrains.annotations.NotNull ObjectNode meta) {
            Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            this.main = main;
            this.meta = meta;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode component1() {
            return this.main;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode component2() {
            return this.meta;
        }

        @org.jetbrains.annotations.NotNull
        public final PropertyNode copy(@org.jetbrains.annotations.NotNull ObjectNode main, @org.jetbrains.annotations.NotNull ObjectNode meta) {
            Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            return new PropertyNode(main, meta);
        }

        @org.jetbrains.annotations.NotNull
        public static /* bridge */ /* synthetic */ PropertyNode copy$default(PropertyNode propertyNode, ObjectNode objectNode, ObjectNode objectNode2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                objectNode = propertyNode.main;
            }
            if ((n & 2) != 0) {
                objectNode2 = propertyNode.meta;
            }
            return propertyNode.copy(objectNode, objectNode2);
        }

        public String toString() {
            return "PropertyNode(main=" + this.main + ", meta=" + this.meta + ")";
        }

        public int hashCode() {
            ObjectNode objectNode = this.main;
            ObjectNode objectNode2 = this.meta;
            return (objectNode != null ? objectNode.hashCode() : 0) * 31 + (objectNode2 != null ? objectNode2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertyNode)) break block3;
                    PropertyNode propertyNode = (PropertyNode)object;
                    if (!Intrinsics.areEqual((Object)this.main, (Object)propertyNode.main) || !Intrinsics.areEqual((Object)this.meta, (Object)propertyNode.meta)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u00019B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nR\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0019\u001a\u00060\u0000R\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\"\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010$\u001a\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010&\u001a\u00020'2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010*\u001a\u00020+2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\u001eH\u0016J\u0012\u0010.\u001a\u00020/2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\bH\u0002J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\t\u001a\u00060\nR\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006:"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$MyJsonFormatVisitorWrapper;", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper;", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$MySerializerProvider;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "level", "", "node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "definitionsHandler", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionsHandler;", "Lcom/dr/ktjsonschema/JsonSchemaGenerator;", "currentProperty", "Lcom/fasterxml/jackson/databind/BeanProperty;", "(Lcom/dr/ktjsonschema/JsonSchemaGenerator;Lcom/fasterxml/jackson/databind/ObjectMapper;ILcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionsHandler;Lcom/fasterxml/jackson/databind/BeanProperty;)V", "getCurrentProperty", "()Lcom/fasterxml/jackson/databind/BeanProperty;", "getDefinitionsHandler", "()Lcom/dr/ktjsonschema/JsonSchemaGenerator$DefinitionsHandler;", "getLevel", "()I", "getNode", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createChild", "childNode", "expectAnyFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonAnyFormatVisitor;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "expectArrayFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonArrayFormatVisitor;", "_type", "expectBooleanFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonBooleanFormatVisitor;", "expectIntegerFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonIntegerFormatVisitor;", "expectMapFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonMapFormatVisitor;", "expectNullFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonNullFormatVisitor;", "expectNumberFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonNumberFormatVisitor;", "expectObjectFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "expectStringFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonStringFormatVisitor;", "extractPolymorphismInfo", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$PolymorphismInfo;", "getRequiredArrayNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "objectNode", "l", "", "s", "", "MyJsonObjectFormatVisitor", "ktjsonschema_main"})
    public final class MyJsonFormatVisitorWrapper
    extends MySerializerProvider
    implements JsonFormatVisitorWrapper {
        @org.jetbrains.annotations.NotNull
        private final ObjectMapper objectMapper;
        private final int level;
        @org.jetbrains.annotations.NotNull
        private final ObjectNode node;
        @org.jetbrains.annotations.NotNull
        private final DefinitionsHandler definitionsHandler;
        @Nullable
        private final BeanProperty currentProperty;
        final /* synthetic */ JsonSchemaGenerator this$0;

        /*
         * WARNING - void declaration
         */
        public final void l(@org.jetbrains.annotations.NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            if (!this.this$0.getDebug()) {
                return;
            }
            String indent = "";
            int n = 0;
            int n2 = this.level;
            if (n <= n2) {
                while (true) {
                    void i;
                    indent = indent + "  ";
                    if (i == n2) break;
                    ++i;
                }
            }
            String string = indent + s;
            System.out.println((Object)string);
        }

        @org.jetbrains.annotations.NotNull
        public final MyJsonFormatVisitorWrapper createChild(@org.jetbrains.annotations.NotNull ObjectNode childNode, @Nullable BeanProperty currentProperty) {
            Intrinsics.checkParameterIsNotNull((Object)childNode, (String)"childNode");
            return new MyJsonFormatVisitorWrapper(this.this$0, this.objectMapper, this.level + 1, childNode, this.definitionsHandler, currentProperty);
        }

        @org.jetbrains.annotations.NotNull
        public JsonStringFormatVisitor expectStringFormat(@Nullable JavaType type) {
            block7: {
                Object it;
                Object object;
                this.l("expectStringFormat - _type: " + type);
                this.node.put("type", "string");
                if (this.currentProperty == null) break block7;
                Pattern pattern = (Pattern)this.currentProperty.getAnnotation(Pattern.class);
                if (pattern != null) {
                    object = pattern;
                    it = object;
                    this.node.put("pattern", it.regexp());
                }
                JsonSchemaDefault jsonSchemaDefault = (JsonSchemaDefault)this.currentProperty.getAnnotation(JsonSchemaDefault.class);
                if (jsonSchemaDefault != null) {
                    object = jsonSchemaDefault;
                    it = (JsonSchemaDefault)object;
                    this.node.put("default", it.value());
                }
                Size size = (Size)this.currentProperty.getAnnotation(Size.class);
                if (size != null) {
                    object = size;
                    it = (Size)object;
                    if (it.min() > 0) {
                        this.node.put("minLength", it.min());
                    }
                    if (it.max() != Integer.MAX_VALUE) {
                        this.node.put("maxLength", it.max());
                    }
                }
                if (this.this$0.getConfig().getUseMinLengthForNotNull() && !this.node.has("minLength") && !this.node.has("maxLength")) {
                    NotNull notNull = (NotNull)this.currentProperty.getAnnotation(NotNull.class);
                    if (notNull != null) {
                        object = notNull;
                        it = (NotNull)object;
                        this.node.put("minLength", 1);
                    }
                }
            }
            return new JsonStringFormatVisitor(this){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;

                @org.jetbrains.annotations.NotNull
                public ObjectNode get_node() {
                    return this.this$0.getNode();
                }

                public void format(@Nullable JsonValueFormat format) {
                    JsonSchemaGenerator.access$setFormat(this.this$0.this$0, this.this$0.getNode(), String.valueOf(format));
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        @org.jetbrains.annotations.NotNull
        public JsonArrayFormatVisitor expectArrayFormat(@Nullable JavaType _type) {
            this.l("expectArrayFormat - _type: " + _type);
            this.node.put("type", "array");
            String string = this.this$0.getConfig().getDefaultArrayFormat();
            if (string != null) {
                String string2 = string;
                String it = string2;
                this.this$0.setFormat(this.node, it);
            }
            ObjectNode itemsNode = JsonNodeFactory.instance.objectNode();
            this.node.set("items", (JsonNode)itemsNode);
            JavaType javaType = _type;
            if (javaType == null) {
                Intrinsics.throwNpe();
            }
            JavaType preferredElementType = javaType.getContentType();
            return new JsonArrayFormatVisitor(this, preferredElementType, itemsNode){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;
                final /* synthetic */ JavaType $preferredElementType;
                final /* synthetic */ ObjectNode $itemsNode;

                public void itemsFormat(@Nullable JsonFormatVisitable handler, @Nullable JavaType elementType) {
                    this.this$0.l("expectArrayFormat - handler: " + handler + " - elementType: " + elementType + " - preferredElementType: " + this.$preferredElementType);
                    ObjectMapper objectMapper = this.this$0.getObjectMapper();
                    JavaType javaType = this.$preferredElementType;
                    if (javaType == null) {
                        javaType = elementType;
                    }
                    ObjectNode objectNode = this.$itemsNode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"itemsNode");
                    objectMapper.acceptJsonFormatVisitor(javaType, (JsonFormatVisitorWrapper)this.this$0.createChild(objectNode, null));
                }

                public void itemsFormat(@Nullable JsonFormatTypes format) {
                    this.this$0.l("itemsFormat - format: " + format);
                    if (format != null) {
                        this.$itemsNode.put("type", format.value());
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$preferredElementType = $captured_local_variable$1;
                    this.$itemsNode = $captured_local_variable$2;
                }
            };
        }

        @org.jetbrains.annotations.NotNull
        public JsonNullFormatVisitor expectNullFormat(@Nullable JavaType type) {
            this.l("expectNullFormat - _type: " + type);
            return new JsonNullFormatVisitor(){};
        }

        @org.jetbrains.annotations.NotNull
        public JsonNumberFormatVisitor expectNumberFormat(@Nullable JavaType type) {
            block4: {
                ObjectNode objectNode;
                Object it;
                Object object;
                this.l("expectNumberFormat");
                this.node.put("type", "number");
                BeanProperty beanProperty = this.currentProperty;
                if (beanProperty == null) break block4;
                BeanProperty beanProperty2 = beanProperty;
                BeanProperty it2 = beanProperty2;
                Min min = (Min)it2.getAnnotation(Min.class);
                if (min != null) {
                    object = min;
                    it = object;
                    this.node.put("minimum", it.value());
                }
                Max max = (Max)it2.getAnnotation(Max.class);
                if (max != null) {
                    object = max;
                    it = (Max)object;
                    this.node.put("maximum", it.value());
                }
                JsonSchemaDefault jsonSchemaDefault = (JsonSchemaDefault)it2.getAnnotation(JsonSchemaDefault.class);
                if (jsonSchemaDefault != null) {
                    object = jsonSchemaDefault;
                    it = (JsonSchemaDefault)object;
                    String string = it.value();
                    String string2 = "default";
                    ObjectNode objectNode2 = this.node;
                    long l = Long.parseLong(string);
                    objectNode = objectNode2.put(string2, l);
                } else {
                    objectNode = null;
                }
            }
            return new JsonNumberFormatVisitor(this){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;

                @org.jetbrains.annotations.NotNull
                public ObjectNode get_node() {
                    return this.this$0.getNode();
                }

                public void format(@Nullable JsonValueFormat format) {
                    JsonSchemaGenerator.access$setFormat(this.this$0.this$0, this.this$0.getNode(), String.valueOf(format));
                }

                public void numberType(@Nullable JsonParser.NumberType type) {
                    this.this$0.l("JsonNumberFormatVisitor.numberType: " + type);
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        @org.jetbrains.annotations.NotNull
        public JsonAnyFormatVisitor expectAnyFormat(@Nullable JavaType type) {
            return new JsonAnyFormatVisitor(){};
        }

        @org.jetbrains.annotations.NotNull
        public JsonMapFormatVisitor expectMapFormat(@Nullable JavaType type) {
            this.l("expectMapFormat - _type: " + type);
            ObjectNode additionalPropsObject = JsonNodeFactory.instance.objectNode();
            this.node.put("type", "object");
            this.node.set("additionalProperties", (JsonNode)additionalPropsObject);
            return new JsonMapFormatVisitor(this, additionalPropsObject){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;
                final /* synthetic */ ObjectNode $additionalPropsObject;

                public void valueFormat(@Nullable JsonFormatVisitable handler, @Nullable JavaType valueType) {
                    this.this$0.l("JsonMapFormatVisitor.valueFormat handler: " + handler + " - valueType: " + valueType);
                    ObjectMapper objectMapper = this.this$0.getObjectMapper();
                    ObjectNode objectNode = this.$additionalPropsObject;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"additionalPropsObject");
                    objectMapper.acceptJsonFormatVisitor(valueType, (JsonFormatVisitorWrapper)this.this$0.createChild(objectNode, null));
                }

                public void keyFormat(@Nullable JsonFormatVisitable handler, @Nullable JavaType keyType) {
                    this.this$0.l("JsonMapFormatVisitor.keyFormat handler: " + handler + " - keyType: " + keyType);
                    if (keyType != null && !keyType.isTypeOrSubTypeOf(String.class)) {
                        this.this$0.getNode().put("additionalProperties", true);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$additionalPropsObject = $captured_local_variable$1;
                }
            };
        }

        @org.jetbrains.annotations.NotNull
        public JsonIntegerFormatVisitor expectIntegerFormat(@Nullable JavaType type) {
            block4: {
                ObjectNode objectNode;
                Object it;
                Object object;
                this.node.put("type", "integer");
                BeanProperty beanProperty = this.currentProperty;
                if (beanProperty == null) break block4;
                BeanProperty beanProperty2 = beanProperty;
                BeanProperty it2 = beanProperty2;
                Min min = (Min)it2.getAnnotation(Min.class);
                if (min != null) {
                    object = min;
                    it = object;
                    this.node.put("minimum", it.value());
                }
                Max max = (Max)it2.getAnnotation(Max.class);
                if (max != null) {
                    object = max;
                    it = (Max)object;
                    this.node.put("maximum", it.value());
                }
                JsonSchemaDefault jsonSchemaDefault = (JsonSchemaDefault)it2.getAnnotation(JsonSchemaDefault.class);
                if (jsonSchemaDefault != null) {
                    object = jsonSchemaDefault;
                    it = (JsonSchemaDefault)object;
                    String string = it.value();
                    String string2 = "default";
                    ObjectNode objectNode2 = this.node;
                    int n = Integer.parseInt(string);
                    objectNode = objectNode2.put(string2, n);
                } else {
                    objectNode = null;
                }
            }
            return new JsonIntegerFormatVisitor(this){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;

                @org.jetbrains.annotations.NotNull
                public ObjectNode get_node() {
                    return this.this$0.getNode();
                }

                public void format(@Nullable JsonValueFormat format) {
                    JsonSchemaGenerator.access$setFormat(this.this$0.this$0, this.this$0.getNode(), String.valueOf(format));
                }

                public void numberType(@Nullable JsonParser.NumberType type) {
                    this.this$0.l("JsonIntegerFormatVisitor.numberType: " + type);
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        @org.jetbrains.annotations.NotNull
        public JsonBooleanFormatVisitor expectBooleanFormat(@Nullable JavaType type) {
            block2: {
                ObjectNode objectNode;
                this.l("expectBooleanFormat");
                this.node.put("type", "boolean");
                BeanProperty beanProperty = this.currentProperty;
                if (beanProperty == null) break block2;
                BeanProperty beanProperty2 = beanProperty;
                BeanProperty it = beanProperty2;
                JsonSchemaDefault jsonSchemaDefault = (JsonSchemaDefault)it.getAnnotation(JsonSchemaDefault.class);
                if (jsonSchemaDefault != null) {
                    JsonSchemaDefault jsonSchemaDefault2 = jsonSchemaDefault;
                    JsonSchemaDefault it2 = jsonSchemaDefault2;
                    String string = it2.value();
                    String string2 = "default";
                    ObjectNode objectNode2 = this.node;
                    boolean bl = Boolean.parseBoolean(string);
                    objectNode = objectNode2.put(string2, bl);
                } else {
                    objectNode = null;
                }
            }
            return new JsonBooleanFormatVisitor(this){
                final /* synthetic */ MyJsonFormatVisitorWrapper this$0;

                @org.jetbrains.annotations.NotNull
                public ObjectNode get_node() {
                    return this.this$0.getNode();
                }

                public void format(@Nullable JsonValueFormat format) {
                    JsonSchemaGenerator.access$setFormat(this.this$0.this$0, this.this$0.getNode(), String.valueOf(format));
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        private final ArrayNode getRequiredArrayNode(ObjectNode objectNode) {
            JsonNode node;
            if (objectNode.has("required") && (node = objectNode.get("required")) instanceof ArrayNode) {
                return (ArrayNode)node;
            }
            ArrayNode rn = JsonNodeFactory.instance.arrayNode();
            objectNode.set("required", (JsonNode)rn);
            ArrayNode arrayNode = rn;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayNode, (String)"rn");
            return arrayNode;
        }

        /*
         * WARNING - void declaration
         */
        private final PolymorphismInfo extractPolymorphismInfo(JavaType _type) {
            JsonTypeInfo jsonTypeInfo;
            AnnotatedClass ac = AnnotatedClass.construct((JavaType)_type, (MapperConfig)((MapperConfig)this.objectMapper.getDeserializationConfig()));
            Annotations annotations = ac.getAnnotations();
            JsonTypeInfo jsonTypeInfo2 = jsonTypeInfo = annotations != null ? (JsonTypeInfo)annotations.get(JsonTypeInfo.class) : null;
            if (jsonTypeInfo != null) {
                Iterator<Object> iterator;
                String propertyName;
                block6: {
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    if (Intrinsics.areEqual((Object)jsonTypeInfo.include(), (Object)JsonTypeInfo.As.PROPERTY) ^ true) {
                        throw (Throwable)new Exception("We only support polymorphism using jsonTypeInfo.include() == JsonTypeInfo.As.PROPERTY");
                    }
                    if (Intrinsics.areEqual((Object)jsonTypeInfo.use(), (Object)JsonTypeInfo.Id.NAME) ^ true) {
                        throw (Throwable)new Exception("We only support polymorphism using jsonTypeInfo.use == JsonTypeInfo.Id.NAME");
                    }
                    propertyName = jsonTypeInfo.property();
                    Iterable iterable = this.objectMapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)this.objectMapper.getDeserializationConfig(), ac);
                    Iterable iterable2 = $receiver$iv;
                    Collection collection = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        NamedType it = (NamedType)element$iv$iv;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)_type.getRawClass())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable = (List)destination$iv$iv;
                    iterable2 = iterable;
                    for (Iterator<Object> iterator2 : iterable2) {
                        NamedType it = (NamedType)iterator2;
                        if (!true) continue;
                        iterator = iterator2;
                        break block6;
                    }
                    iterator = null;
                }
                NamedType namedType = (NamedType)iterator;
                String string = namedType != null ? namedType.getName() : null;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String subTypeName = string;
                return new PolymorphismInfo(propertyName, subTypeName);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public JsonObjectFormatVisitor expectObjectFormat(@org.jetbrains.annotations.NotNull JavaType _type) {
            DefinitionInfo definitionInfo;
            block5: {
                Class it;
                Collection destination$iv$iv;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)_type, (String)"_type");
                AnnotatedClass ac = AnnotatedClass.construct((JavaType)_type, (MapperConfig)((MapperConfig)this.objectMapper.getDeserializationConfig()));
                Collection resolvedSubTypes = this.objectMapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)this.objectMapper.getDeserializationConfig(), ac);
                Iterable iterable = resolvedSubTypes;
                void var6_5 = $receiver$iv;
                Object object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    NamedType namedType = (NamedType)item$iv$iv;
                    void var15_11 = destination$iv$iv;
                    Class clazz = it.getType();
                    var15_11.add(clazz);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (Class)element$iv$iv;
                    if (!(_type.getRawClass().isAssignableFrom(it) && Intrinsics.areEqual((Object)_type.getRawClass(), (Object)it) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List subTypes = (List)destination$iv$iv;
                $receiver$iv = subTypes;
                if (!$receiver$iv.isEmpty()) {
                    void $receiver$iv2;
                    ArrayNode anyOfArrayNode = JsonNodeFactory.instance.arrayNode();
                    this.node.set("oneOf", (JsonNode)anyOfArrayNode);
                    $receiver$iv$iv = subTypes;
                    for (Object element$iv : $receiver$iv2) {
                        Class it2;
                        Class subType = it2 = (Class)element$iv;
                        this.l("polymorphism - subType: " + subType);
                        Class clazz = subType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"subType");
                        DefinitionInfo definitionInfo2 = this.definitionsHandler.getOrCreateDefinition(clazz, (Function1<? super ObjectNode, ? extends JsonObjectFormatVisitor>)new Function1(subType, this, anyOfArrayNode){
                            final /* synthetic */ Class $subType;
                            final /* synthetic */ MyJsonFormatVisitorWrapper this$0;
                            final /* synthetic */ ArrayNode $anyOfArrayNode$inlined;

                            public final Void invoke(ObjectNode it) {
                                MyJsonFormatVisitorWrapper childVisitor = this.this$0.createChild(it, null);
                                this.this$0.getObjectMapper().acceptJsonFormatVisitor(this.$subType, (JsonFormatVisitorWrapper)childVisitor);
                                return null;
                            }
                            {
                                this.$subType = clazz;
                                this.this$0 = myJsonFormatVisitorWrapper;
                                this.$anyOfArrayNode$inlined = arrayNode;
                                super(1);
                            }
                        });
                        ObjectNode thisOneOfNode = JsonNodeFactory.instance.objectNode();
                        thisOneOfNode.put("$ref", definitionInfo2.getRef());
                        anyOfArrayNode.add((JsonNode)thisOneOfNode);
                    }
                    return null;
                }
                Function1 objectBuilder2 = (Function1)new Function1<ObjectNode, MyJsonObjectFormatVisitor>(this, _type){
                    final /* synthetic */ MyJsonFormatVisitorWrapper this$0;
                    final /* synthetic */ JavaType $_type;

                    @org.jetbrains.annotations.NotNull
                    public final MyJsonObjectFormatVisitor invoke(@org.jetbrains.annotations.NotNull ObjectNode thisObjectNode) {
                        Intrinsics.checkParameterIsNotNull((Object)thisObjectNode, (String)"thisObjectNode");
                        return (MyJsonObjectFormatVisitor)((Function0)new Function0<MyJsonObjectFormatVisitor>(this, thisObjectNode){
                            final /* synthetic */ expectObjectFormat.objectBuilder.1 this$0;
                            final /* synthetic */ ObjectNode $thisObjectNode;

                            @org.jetbrains.annotations.NotNull
                            public final MyJsonObjectFormatVisitor invoke() {
                                Object it;
                                Object object;
                                this.$thisObjectNode.put("type", "object");
                                this.$thisObjectNode.put("additionalProperties", false);
                                AnnotatedClass ac_i = AnnotatedClass.construct((JavaType)this.this$0.$_type, (MapperConfig)((MapperConfig)this.this$0.this$0.getObjectMapper().getDeserializationConfig()));
                                String string = this.this$0.this$0.this$0.resolvePropertyFormat(this.this$0.$_type, this.this$0.this$0.getObjectMapper());
                                if (string != null) {
                                    object = string;
                                    it = object;
                                    JsonSchemaGenerator.access$setFormat(this.this$0.this$0.this$0, this.$thisObjectNode, (String)it);
                                }
                                JsonSchemaDescription jsonSchemaDescription = (JsonSchemaDescription)ac_i.getAnnotations().get(JsonSchemaDescription.class);
                                if (jsonSchemaDescription != null) {
                                    object = jsonSchemaDescription;
                                    it = (JsonSchemaDescription)object;
                                    this.$thisObjectNode.put("description", it.value());
                                }
                                JsonPropertyDescription jsonPropertyDescription = (JsonPropertyDescription)ac_i.getAnnotations().get(JsonPropertyDescription.class);
                                if (jsonPropertyDescription != null) {
                                    object = jsonPropertyDescription;
                                    it = (JsonPropertyDescription)object;
                                    this.$thisObjectNode.put("description", it.value());
                                }
                                JsonSchemaTitle jsonSchemaTitle = (JsonSchemaTitle)ac_i.getAnnotations().get(JsonSchemaTitle.class);
                                if (jsonSchemaTitle != null) {
                                    object = jsonSchemaTitle;
                                    it = (JsonSchemaTitle)object;
                                    this.$thisObjectNode.put("title", it.value());
                                }
                                ObjectNode propertiesNode = JsonNodeFactory.instance.objectNode();
                                this.$thisObjectNode.set("properties", (JsonNode)propertiesNode);
                                PolymorphismInfo polymorphismInfo = MyJsonFormatVisitorWrapper.access$extractPolymorphismInfo(this.this$0.this$0, this.this$0.$_type);
                                if (polymorphismInfo != null) {
                                    PolymorphismInfo it2;
                                    PolymorphismInfo polymorphismInfo2 = polymorphismInfo;
                                    PolymorphismInfo pi = it2 = polymorphismInfo2;
                                    this.$thisObjectNode.put("title", pi.getSubTypeName());
                                    ArrayNode enumValuesNode = JsonNodeFactory.instance.arrayNode();
                                    enumValuesNode.add(pi.getSubTypeName());
                                    ObjectNode enumObjectNode = JsonNodeFactory.instance.objectNode();
                                    enumObjectNode.put("type", "string");
                                    enumObjectNode.set("enum", (JsonNode)enumValuesNode);
                                    enumObjectNode.put("default", pi.getSubTypeName());
                                    if (this.this$0.this$0.this$0.getConfig().getHidePolymorphismTypeProperty()) {
                                        ObjectNode optionsNode = JsonNodeFactory.instance.objectNode();
                                        enumObjectNode.set("options", (JsonNode)optionsNode);
                                        optionsNode.put("hidden", true);
                                    }
                                    propertiesNode.set(pi.getTypePropertyName(), (JsonNode)enumObjectNode);
                                    MyJsonFormatVisitorWrapper.access$getRequiredArrayNode(this.this$0.this$0, this.$thisObjectNode).add(pi.getTypePropertyName());
                                }
                                MyJsonFormatVisitorWrapper myJsonFormatVisitorWrapper = this.this$0.this$0;
                                ObjectNode objectNode = propertiesNode;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"propertiesNode");
                                return myJsonFormatVisitorWrapper.new MyJsonObjectFormatVisitor(this.$thisObjectNode, objectNode);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$thisObjectNode = objectNode;
                                super(0);
                            }
                        }).invoke();
                    }
                    {
                        this.this$0 = myJsonFormatVisitorWrapper;
                        this.$_type = javaType;
                        super(1);
                    }
                };
                if (this.level == 0) {
                    return (JsonObjectFormatVisitor)objectBuilder2.invoke((Object)this.node);
                }
                Class clazz = _type.getRawClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"_type.rawClass");
                definitionInfo = this.definitionsHandler.getOrCreateDefinition(clazz, (Function1<? super ObjectNode, ? extends JsonObjectFormatVisitor>)objectBuilder2);
                String string = definitionInfo.getRef();
                if (string == null) break block5;
                object = string;
                String it3 = (String)object;
                this.node.put("$ref", it3);
            }
            return definitionInfo.getJsonObjectFormatVisitor();
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public final int getLevel() {
            return this.level;
        }

        @org.jetbrains.annotations.NotNull
        public final ObjectNode getNode() {
            return this.node;
        }

        @org.jetbrains.annotations.NotNull
        public final DefinitionsHandler getDefinitionsHandler() {
            return this.definitionsHandler;
        }

        @Nullable
        public final BeanProperty getCurrentProperty() {
            return this.currentProperty;
        }

        public MyJsonFormatVisitorWrapper(@org.jetbrains.annotations.NotNull JsonSchemaGenerator $outer, ObjectMapper objectMapper, @org.jetbrains.annotations.NotNull int level, @org.jetbrains.annotations.NotNull ObjectNode node, @Nullable DefinitionsHandler definitionsHandler, BeanProperty currentProperty) {
            Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)definitionsHandler, (String)"definitionsHandler");
            this.this$0 = $outer;
            this.objectMapper = objectMapper;
            this.level = level;
            this.node = node;
            this.definitionsHandler = definitionsHandler;
            this.currentProperty = currentProperty;
        }

        public /* synthetic */ MyJsonFormatVisitorWrapper(JsonSchemaGenerator jsonSchemaGenerator, ObjectMapper objectMapper, int n, ObjectNode objectNode, DefinitionsHandler definitionsHandler, BeanProperty beanProperty, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                ObjectNode objectNode2 = JsonNodeFactory.instance.objectNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectNode2, (String)"JsonNodeFactory.instance.objectNode()");
                objectNode = objectNode2;
            }
            this(jsonSchemaGenerator, objectMapper, n, objectNode, definitionsHandler, beanProperty);
        }

        @Nullable
        public static final /* synthetic */ PolymorphismInfo access$extractPolymorphismInfo(MyJsonFormatVisitorWrapper $this, @org.jetbrains.annotations.NotNull JavaType _type) {
            return $this.extractPolymorphismInfo(_type);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0018H\u0016J\u0012\u0010#\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010#\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$MyJsonFormatVisitorWrapper$MyJsonObjectFormatVisitor;", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "Lcom/dr/ktjsonschema/JsonSchemaGenerator$MySerializerProvider;", "thisObjectNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "propertiesNode", "(Lcom/dr/ktjsonschema/JsonSchemaGenerator$MyJsonFormatVisitorWrapper;Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "nextPropertyOrderIndex", "", "getNextPropertyOrderIndex", "()I", "setNextPropertyOrderIndex", "(I)V", "getPropertiesNode", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "setPropertiesNode", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getThisObjectNode", "setThisObjectNode", "myPropertyHandler", "", "propertyName", "", "propertyType", "Lcom/fasterxml/jackson/databind/JavaType;", "prop", "Lcom/fasterxml/jackson/databind/BeanProperty;", "jsonPropertyRequired", "", "optionalProperty", "writer", "name", "handler", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitable;", "propertyTypeHint", "property", "ktjsonschema_main"})
        public class MyJsonObjectFormatVisitor
        extends MySerializerProvider
        implements JsonObjectFormatVisitor {
            private int nextPropertyOrderIndex;
            @org.jetbrains.annotations.NotNull
            private ObjectNode thisObjectNode;
            @org.jetbrains.annotations.NotNull
            private ObjectNode propertiesNode;

            public final int getNextPropertyOrderIndex() {
                return this.nextPropertyOrderIndex;
            }

            public final void setNextPropertyOrderIndex(int n) {
                this.nextPropertyOrderIndex = n;
            }

            /*
             * WARNING - void declaration
             */
            public final void myPropertyHandler(@org.jetbrains.annotations.NotNull String propertyName, @org.jetbrains.annotations.NotNull JavaType propertyType, @Nullable BeanProperty prop, boolean jsonPropertyRequired) {
                boolean requiredProperty;
                boolean bl;
                void elements$iv;
                Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
                Intrinsics.checkParameterIsNotNull((Object)propertyType, (String)"propertyType");
                MyJsonFormatVisitorWrapper.this.l("JsonObjectFormatVisitor - " + propertyName + ": " + propertyType);
                if (this.propertiesNode.get(propertyName) != null) {
                    return;
                }
                PropertyNode thisPropertyNode2 = (PropertyNode)((Function0)new Function0<PropertyNode>(this, propertyName, propertyType){
                    final /* synthetic */ MyJsonObjectFormatVisitor this$0;
                    final /* synthetic */ String $propertyName;
                    final /* synthetic */ JavaType $propertyType;

                    /*
                     * Enabled aggressive block sorting
                     */
                    @org.jetbrains.annotations.NotNull
                    public final PropertyNode invoke() {
                        PropertyNode propertyNode;
                        ObjectNode thisPropertyNode2 = JsonNodeFactory.instance.objectNode();
                        this.this$0.getPropertiesNode().set(this.$propertyName, (JsonNode)thisPropertyNode2);
                        if (this.this$0.MyJsonFormatVisitorWrapper.this.this$0.getConfig().getUsePropertyOrdering()) {
                            thisPropertyNode2.put("propertyOrder", this.this$0.getNextPropertyOrderIndex());
                            MyJsonObjectFormatVisitor myJsonObjectFormatVisitor = this.this$0;
                            myJsonObjectFormatVisitor.setNextPropertyOrderIndex(myJsonObjectFormatVisitor.getNextPropertyOrderIndex() + 1);
                        }
                        if (this.this$0.MyJsonFormatVisitorWrapper.this.this$0.getConfig().getUseOneOfForOption()) {
                            String[] elements$iv = new String[]{"java.util.Optional", "java8.util.Optional"};
                            if (ArraysKt.contains((Object[])elements$iv, (Object)this.$propertyType.getRawClass().getName())) {
                                ArrayNode oneOfArray = JsonNodeFactory.instance.arrayNode();
                                thisPropertyNode2.set("oneOf", (JsonNode)oneOfArray);
                                ObjectNode oneOfNull = JsonNodeFactory.instance.objectNode();
                                oneOfNull.put("type", "null");
                                oneOfNull.put("title", "Not included");
                                oneOfArray.add((JsonNode)oneOfNull);
                                ObjectNode oneOfReal = JsonNodeFactory.instance.objectNode();
                                oneOfArray.add((JsonNode)oneOfReal);
                                ObjectNode objectNode = oneOfReal;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"oneOfReal");
                                ObjectNode objectNode2 = thisPropertyNode2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectNode2, (String)"thisPropertyNode");
                                propertyNode = new PropertyNode(objectNode, objectNode2);
                                return propertyNode;
                            }
                        }
                        ObjectNode objectNode = thisPropertyNode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"thisPropertyNode");
                        ObjectNode objectNode3 = thisPropertyNode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode3, (String)"thisPropertyNode");
                        propertyNode = new PropertyNode(objectNode, objectNode3);
                        return propertyNode;
                    }
                    {
                        this.this$0 = myJsonObjectFormatVisitor;
                        this.$propertyName = string;
                        this.$propertyType = javaType;
                        super(0);
                    }
                }).invoke();
                MyJsonFormatVisitorWrapper childVisitor = MyJsonFormatVisitorWrapper.this.createChild(thisPropertyNode2.getMain(), prop);
                String[] stringArray = new String[]{"java.util.Optional", "java8.util.Optional"};
                if (ArraysKt.contains((Object[])((Object[])elements$iv), (Object)propertyType.getRawClass().getName()) && propertyType.containedTypeCount() >= 1) {
                    JavaType optionType = MyJsonFormatVisitorWrapper.this.this$0.resolveType(propertyType, prop, MyJsonFormatVisitorWrapper.this.getObjectMapper());
                    MyJsonFormatVisitorWrapper.this.getDefinitionsHandler().pushWorkInProgress();
                    MyJsonFormatVisitorWrapper.this.getObjectMapper().acceptJsonFormatVisitor(optionType, (JsonFormatVisitorWrapper)childVisitor);
                    MyJsonFormatVisitorWrapper.this.getDefinitionsHandler().popworkInProgress();
                } else {
                    MyJsonFormatVisitorWrapper.this.getDefinitionsHandler().pushWorkInProgress();
                    MyJsonFormatVisitorWrapper.this.getObjectMapper().acceptJsonFormatVisitor(propertyType, (JsonFormatVisitorWrapper)childVisitor);
                    MyJsonFormatVisitorWrapper.this.getDefinitionsHandler().popworkInProgress();
                }
                Class rawClass = propertyType.getRawClass();
                if (rawClass.isPrimitive()) {
                    bl = true;
                } else if (jsonPropertyRequired) {
                    bl = true;
                } else {
                    BeanProperty beanProperty = prop;
                    bl = requiredProperty = (beanProperty != null ? (NotNull)beanProperty.getAnnotation(NotNull.class) : null) != null;
                }
                if (requiredProperty) {
                    MyJsonFormatVisitorWrapper.this.getRequiredArrayNode(this.thisObjectNode).add(propertyName);
                }
                if (prop != null) {
                    Object it;
                    Object object;
                    String string = MyJsonFormatVisitorWrapper.this.this$0.resolvePropertyFormat(prop);
                    if (string != null) {
                        object = string;
                        it = object;
                        MyJsonFormatVisitorWrapper.this.this$0.setFormat(thisPropertyNode2.getMain(), (String)it);
                    }
                    JsonSchemaDescription jsonSchemaDescription = (JsonSchemaDescription)prop.getAnnotation(JsonSchemaDescription.class);
                    if (jsonSchemaDescription != null) {
                        object = jsonSchemaDescription;
                        it = (JsonSchemaDescription)object;
                        thisPropertyNode2.getMeta().put("description", it.value());
                    }
                    JsonPropertyDescription jsonPropertyDescription = (JsonPropertyDescription)prop.getAnnotation(JsonPropertyDescription.class);
                    if (jsonPropertyDescription != null) {
                        object = jsonPropertyDescription;
                        it = (JsonPropertyDescription)object;
                        thisPropertyNode2.getMeta().put("description", it.value());
                    }
                    JsonSchemaTitle jsonSchemaTitle = (JsonSchemaTitle)prop.getAnnotation(JsonSchemaTitle.class);
                    if (jsonSchemaTitle != null) {
                        object = jsonSchemaTitle;
                        it = (JsonSchemaTitle)object;
                        thisPropertyNode2.getMeta().put("title", it.value());
                    }
                    if (MyJsonFormatVisitorWrapper.this.this$0.getConfig().getAutoGenerateTitleForProperties() && !thisPropertyNode2.getMeta().has("title")) {
                        thisPropertyNode2.getMeta().put("title", MyJsonFormatVisitorWrapper.this.this$0.generateTitleFromPropertyName(propertyName));
                    }
                }
            }

            public void property(@Nullable BeanProperty writer) {
                MyJsonFormatVisitorWrapper.this.l("JsonObjectFormatVisitor.property: prop:" + writer);
                if (writer != null) {
                    String string = writer.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.name");
                    JavaType javaType = writer.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"writer.type");
                    this.myPropertyHandler(string, javaType, writer, true);
                }
            }

            public void property(@org.jetbrains.annotations.NotNull String name, @Nullable JsonFormatVisitable handler, @org.jetbrains.annotations.NotNull JavaType propertyTypeHint) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)propertyTypeHint, (String)"propertyTypeHint");
                MyJsonFormatVisitorWrapper.this.l("JsonObjectFormatVisitor.property: name:" + name + " handler:" + handler + " propertyTypeHint:" + propertyTypeHint);
                this.myPropertyHandler(name, propertyTypeHint, null, true);
            }

            public void optionalProperty(@Nullable BeanProperty writer) {
                MyJsonFormatVisitorWrapper.this.l("JsonObjectFormatVisitor.optionalProperty: prop:" + writer);
                if (writer != null) {
                    String string = writer.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.name");
                    JavaType javaType = writer.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"writer.type");
                    this.myPropertyHandler(string, javaType, writer, false);
                }
            }

            public void optionalProperty(@org.jetbrains.annotations.NotNull String name, @Nullable JsonFormatVisitable handler, @org.jetbrains.annotations.NotNull JavaType propertyTypeHint) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)propertyTypeHint, (String)"propertyTypeHint");
                MyJsonFormatVisitorWrapper.this.l("JsonObjectFormatVisitor.optionalProperty: name:" + name + " handler:" + handler + " propertyTypeHint:" + propertyTypeHint);
                this.myPropertyHandler(name, propertyTypeHint, null, false);
            }

            @org.jetbrains.annotations.NotNull
            public final ObjectNode getThisObjectNode() {
                return this.thisObjectNode;
            }

            public final void setThisObjectNode(@org.jetbrains.annotations.NotNull ObjectNode objectNode) {
                Intrinsics.checkParameterIsNotNull((Object)objectNode, (String)"<set-?>");
                this.thisObjectNode = objectNode;
            }

            @org.jetbrains.annotations.NotNull
            public final ObjectNode getPropertiesNode() {
                return this.propertiesNode;
            }

            public final void setPropertiesNode(@org.jetbrains.annotations.NotNull ObjectNode objectNode) {
                Intrinsics.checkParameterIsNotNull((Object)objectNode, (String)"<set-?>");
                this.propertiesNode = objectNode;
            }

            public MyJsonObjectFormatVisitor(@org.jetbrains.annotations.NotNull ObjectNode thisObjectNode, ObjectNode propertiesNode) {
                Intrinsics.checkParameterIsNotNull((Object)thisObjectNode, (String)"thisObjectNode");
                Intrinsics.checkParameterIsNotNull((Object)propertiesNode, (String)"propertiesNode");
                this.thisObjectNode = thisObjectNode;
                this.propertiesNode = propertiesNode;
                this.nextPropertyOrderIndex = 1;
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/dr/ktjsonschema/JsonSchemaGenerator$Companion;", "", "()V", "JSON_SCHEMA_DRAFT_4_URL", "", "JSON_SCHEMA_DRAFT_4_URL$annotations", "getJSON_SCHEMA_DRAFT_4_URL", "()Ljava/lang/String;", "ktjsonschema_main"})
    public static final class Companion {
        @JvmStatic
        private static final /* synthetic */ void JSON_SCHEMA_DRAFT_4_URL$annotations() {
        }

        @org.jetbrains.annotations.NotNull
        public final String getJSON_SCHEMA_DRAFT_4_URL() {
            return JSON_SCHEMA_DRAFT_4_URL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

