/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.jna.ClassUtils;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SystemTrayFixes;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class SystemTrayFixesLinux {
    private static AtomicBoolean loaded = new AtomicBoolean(false);

    public static void fix(int trayIconSize) {
        if (loaded.getAndSet(true)) {
            return;
        }
        if (OS.INSTANCE.getJavaVersion() > 8) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded("sun.awt.X11.XTrayIconPeer")) {
            throw new RuntimeException("Unable to initialize the Swing System Tray, it has already been created!");
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            String className = "sun.awt.X11.XTrayIconPeer";
            CtClass trayIconClass = pool.get(className);
            CtClass eFrameClass = null;
            CtClass iconCanvasClass = null;
            CtClass[] nestedClasses = trayIconClass.getNestedClasses();
            String xEmbedFrameName = className + "$XTrayIconEmbeddedFrame";
            String iconCanvasName = className + "$IconCanvas";
            for (CtClass nestedClass : nestedClasses) {
                String name = nestedClass.getName();
                if (name.equals(xEmbedFrameName)) {
                    eFrameClass = nestedClass;
                }
                if (!name.equals(iconCanvasName)) continue;
                iconCanvasClass = nestedClass;
            }
            if (eFrameClass == null || iconCanvasClass == null) {
                throw new RuntimeException("Unable to find required classes to fix. Unable to continue initialization.");
            }
            CtField ctField = new CtField(pool.get("java.awt.Robot"), "robot", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Color"), "color", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.image.BufferedImage"), "image", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Rectangle"), "rectangle", trayIconClass);
            ctField.setModifiers(8);
            trayIconClass.addField(ctField);
            CtClass trayPeerClass = pool.get("sun.awt.X11.XSystemTrayPeer");
            CtConstructor constructor = trayIconClass.getDeclaredConstructors()[0];
            CtMethod method1 = trayIconClass.getDeclaredMethod("getBounds");
            CtMethod method2 = trayPeerClass.getDeclaredMethod("getTrayIconSize");
            CtBehavior[] methodInfos = new CtBehavior[]{constructor, method1, method2};
            SystemTrayFixes.fixTraySize(methodInfos, 24, trayIconSize);
            constructor.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            method1.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            method2.getMethodInfo().rebuildStackMapForME(trayPeerClass.getClassPool());
            CtClass runnable = pool.makeClass("sun.awt.X11.RunnableImpl");
            runnable.addInterface(pool.get("java.lang.Runnable"));
            ctField = new CtField(pool.get(xEmbedFrameName), "frame", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Rectangle"), "size", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            ctField = new CtField(CtClass.intType, "attempts", runnable);
            ctField.setModifiers(4);
            runnable.addField(ctField);
            CtMethod method = CtNewMethod.make((String)("public void run() { java.awt.Point loc = frame.getLocationOnScreen();if (loc.x == 0 && loc.y == 0 && attempts < 10) {attempts++;java.awt.EventQueue.invokeLater(this);return;}java.awt.Rectangle rect;if (loc.x > loc.y) {rect = new java.awt.Rectangle(loc.x-1, loc.y, 1, size.height);if (loc.y < 300) {" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y + rect.height-1);} else {" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y);}} else {rect = new java.awt.Rectangle(loc.x, loc.y-1, size.width, 1);" + className + ".color = " + className + ".robot.getPixelColor(rect.x, rect.y);}" + className + ".image = " + className + ".robot.createScreenCapture(rect);" + className + ".rectangle = rect;frame.setBackground(" + className + ".color);}"), (CtClass)runnable);
            runnable.addMethod(method);
            byte[] runnableBytes = runnable.toBytecode();
            CtMethod methodVisible = CtNewMethod.make((String)("public void setVisible(boolean b) { if (b) {if (" + className + ".robot == null) {" + className + ".robot = new java.awt.Robot();sun.awt.X11.RunnableImpl r = new sun.awt.X11.RunnableImpl();r.frame = this;r.size = getBoundsPrivate();java.awt.EventQueue.invokeLater(r);}java.awt.Point loc = getPeer().getLocationOnScreen();int locX = loc.x;int locY = loc.y;if (!(locX == 0 && locY == 0)) {if (locX > 0) locX -= 1;if (locY > 0) locY -= 1;" + className + ".color = " + className + ".robot.getPixelColor(locX, locY);setBackground(" + className + ".color);}}super.setVisible(b);}"), (CtClass)eFrameClass);
            eFrameClass.addMethod(methodVisible);
            methodVisible.getMethodInfo().rebuildStackMapForME(eFrameClass.getClassPool());
            byte[] eFrameBytes = eFrameClass.toBytecode();
            CtMethod ctMethodPaint = iconCanvasClass.getDeclaredMethod("paint");
            String body = "{java.awt.Graphics g = $1;if (g != null && curW > 0 && curH > 0) {java.awt.image.BufferedImage bufImage = new java.awt.image.BufferedImage(curW, curH, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D gr = bufImage.createGraphics();if (gr != null) {try {gr.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));gr.setColor(getBackground());gr.fillRect(0, 0, curW, curH);if (" + className + ".image != null) {gr.drawImage(" + className + ".image, 0, 0, curW, curH, null);}gr.drawImage(image, 0, 0, curW, curH, observer);gr.dispose();g.drawImage(bufImage, 0, 0, curW, curH, null);} finally {g.dispose();}}}}";
            ctMethodPaint.setBody(body);
            byte[] iconCanvasBytes = iconCanvasClass.toBytecode();
            byte[] trayIconBytes = trayIconClass.toBytecode();
            byte[] trayPeerBytes = trayPeerClass.toBytecode();
            ClassUtils.defineClass((byte[])runnableBytes);
            ClassUtils.defineClass((byte[])eFrameBytes);
            ClassUtils.defineClass((byte[])iconCanvasBytes);
            ClassUtils.defineClass((byte[])trayIconBytes);
            ClassUtils.defineClass((byte[])trayPeerBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon background color");
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error setting tray icon background color", (Throwable)e);
        }
    }
}

