/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.SizeAndScalingLinux;
import dorkbox.systemTray.util.SizeAndScalingMacOS;
import dorkbox.systemTray.util.SizeAndScalingWindows;
import dorkbox.util.SwingUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class SizeAndScaling {
    public static int TRAY_SIZE = 0;
    public static int TRAY_MENU_SIZE = 0;

    public static double getDpiScaleForMouseClick(int mousePositionX, int mousePositionY) {
        if (OS.INSTANCE.isWindows()) {
            return SizeAndScalingWindows.getDpiScaleForMouseClick(mousePositionX, mousePositionY);
        }
        return 1.0;
    }

    public static int getTrayImageSize() {
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = OS.INSTANCE.isLinux() ? SizeAndScalingLinux.getTrayImageSize() : (OS.INSTANCE.isMacOsX() ? SizeAndScalingMacOS.getTrayImageSize() : (OS.INSTANCE.isWindows() ? SizeAndScalingWindows.getTrayImageSize() : 32));
        }
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = 32;
        }
        return TRAY_SIZE;
    }

    public static int getMenuImageSize(Class<? extends Tray> trayType) {
        if (TRAY_MENU_SIZE == 0) {
            TRAY_MENU_SIZE = OS.INSTANCE.isMacOsX() ? SizeAndScalingMacOS.getMenuImageSize() : (trayType == _SwingTray.class || trayType == _WindowsNativeTray.class ? (OS.INSTANCE.isWindows() ? SizeAndScalingWindows.getMenuImageSize() : SizeAndScaling.getMenuImageSizeGeneric()) : (OS.INSTANCE.isLinux() ? SizeAndScalingLinux.getMenuImageSize() : 16));
        }
        return TRAY_MENU_SIZE;
    }

    public static int getMenuImageSizeGeneric() {
        AtomicInteger iconSize = new AtomicInteger();
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            JMenuItem jMenuItem = new JMenuItem();
            if (SystemTray.SWING_UI != null) {
                jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
            }
            int height = SwingUtil.INSTANCE.getLargestIconHeightForButton((AbstractButton)jMenuItem);
            iconSize.set(height);
        });
        return iconSize.get();
    }
}

