/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.gnomeShell.AppIndicatorExtension;
import dorkbox.systemTray.gnomeShell.DummyFile;
import dorkbox.systemTray.gnomeShell.LegacyExtension;
import dorkbox.systemTray.ui.awt._AwtTray;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.ui.gtk._GtkStatusIconNativeTray;
import dorkbox.systemTray.ui.osx._OsxAwtTray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class AutoDetectTrayType {
    private static final Map<String, SystemTray> traySingletons = new HashMap<String, SystemTray>();

    public static Class<? extends Tray> selectType(SystemTray.TrayType trayType) {
        if (trayType == SystemTray.TrayType.Gtk) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.WindowsNative) {
            return _WindowsNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == SystemTray.TrayType.Osx) {
            return _OsxAwtTray.class;
        }
        if (trayType == SystemTray.TrayType.Awt) {
            return _AwtTray.class;
        }
        return null;
    }

    public static SystemTray.TrayType fromClass(Class<? extends Tray> trayClass) {
        if (trayClass == _GtkStatusIconNativeTray.class) {
            return SystemTray.TrayType.Gtk;
        }
        if (trayClass == _AppIndicatorNativeTray.class) {
            return SystemTray.TrayType.AppIndicator;
        }
        if (trayClass == _WindowsNativeTray.class) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (trayClass == _SwingTray.class) {
            return SystemTray.TrayType.Swing;
        }
        if (trayClass == _OsxAwtTray.class) {
            return SystemTray.TrayType.Osx;
        }
        if (trayClass == _AwtTray.class) {
            return SystemTray.TrayType.Awt;
        }
        return null;
    }

    public static boolean isTrayType(Class<? extends Tray> tray, SystemTray.TrayType trayType) {
        switch (trayType) {
            case Gtk: {
                return tray == _GtkStatusIconNativeTray.class;
            }
            case AppIndicator: {
                return tray == _AppIndicatorNativeTray.class;
            }
            case WindowsNative: {
                return tray == _WindowsNativeTray.class;
            }
            case Swing: {
                return tray == _SwingTray.class;
            }
            case Osx: {
                return tray == _OsxAwtTray.class;
            }
            case Awt: {
                return tray == _AwtTray.class;
            }
        }
        return false;
    }

    public static Class<? extends Tray> get(String trayName) {
        if (OS.INSTANCE.isWindows()) {
            return AutoDetectTrayType.selectType(SystemTray.TrayType.WindowsNative);
        }
        if (OS.INSTANCE.isMacOsX()) {
            return AutoDetectTrayType.selectType(SystemTray.TrayType.Osx);
        }
        if (OS.INSTANCE.isLinux() || OS.INSTANCE.isUnix()) {
            block49: {
                OS.DesktopEnv.Env de = OS.DesktopEnv.INSTANCE.getEnv();
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Currently using the '{}' desktop environment" + OS.INSTANCE.getLINE_SEPARATOR() + OS.Linux.INSTANCE.getInfo(), (Object)de);
                }
                switch (de) {
                    case Gnome: {
                        String GDM = System.getenv("GDMSESSION");
                        if (GDM == null) {
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("GDMSESSION value is not set by OS. Checking '/etc/os-release' for more info.");
                            }
                            if (OS.Linux.INSTANCE.isPop()) {
                                GDM = "ubuntu";
                                if (SystemTray.DEBUG) {
                                    SystemTray.logger.debug("Detected popOS! Using 'ubuntu' for that configuration.");
                                }
                            }
                        }
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Currently using the '{}' session type", (Object)GDM);
                        }
                        if ("gnome".equalsIgnoreCase(GDM) || "default".equalsIgnoreCase(GDM)) {
                            if (OS.Linux.INSTANCE.isUbuntu()) {
                                return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                            }
                            String gnomeVersion = OS.DesktopEnv.INSTANCE.getGnomeVersion();
                            if (gnomeVersion == null) {
                                SystemTray.logger.error("GNOME shell detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                                return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                            }
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("Gnome Version: {}", (Object)gnomeVersion);
                            }
                            int major = 0;
                            double minorAndPatch = 0.0;
                            String[] split = gnomeVersion.split("\\.", 2);
                            try {
                                major = Integer.parseInt(split[0]);
                                minorAndPatch = Double.parseDouble(split[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (major == 2) {
                                return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                            }
                            if (major == 3) {
                                if (minorAndPatch < 16.0) {
                                    SystemTray.logger.warn("SystemTray works, but will only show via SUPER+M.");
                                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                                }
                                if (minorAndPatch < 26.0) {
                                    Tray.gtkGnomeWorkaround = true;
                                    LegacyExtension.install(trayName);
                                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                                }
                                if (!AppIndicatorExtension.isInstalled()) {
                                    AppIndicatorExtension.install();
                                    SystemTray.logger.error("You must log out and then in again for system tray settings to apply.");
                                    return null;
                                }
                                return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                            }
                            SystemTray.logger.error("GNOME shell detected, but UNSUPPORTED shell version (" + gnomeVersion + "). Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if ("cinnamon".equalsIgnoreCase(GDM)) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if ("gnome-classic".equalsIgnoreCase(GDM)) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if ("gnome-fallback".equalsIgnoreCase(GDM)) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if ("awesome".equalsIgnoreCase(GDM)) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if ("ubuntu".equalsIgnoreCase(GDM)) {
                            int[] version = OS.Linux.INSTANCE.getUbuntuVersion();
                            if (version[0] == 17 && version[1] == 10) {
                                Tray.gtkGnomeWorkaround = true;
                                LegacyExtension.install(trayName);
                            } else if (version[0] >= 18) {
                                DummyFile.install();
                            }
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                        }
                        SystemTray.logger.error("GNOME shell detected, but UNKNOWN type. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    case KDE: {
                        double plasmaVersion = OS.DesktopEnv.INSTANCE.getPlasmaVersion();
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("KDE Plasma Version: {}", (Object)plasmaVersion);
                        }
                        if (plasmaVersion == 0.0) {
                            SystemTray.logger.error("KDE Plasma detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (plasmaVersion <= 5.5) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    }
                    case Unity: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    }
                    case Unity7: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    }
                    case XFCE: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    case LXDE: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    case MATE: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    case Pantheon: {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    }
                    case ChromeOS: {
                        return null;
                    }
                }
                Object bin = null;
                try {
                    File proc = new File("/proc");
                    File[] listFiles = proc.listFiles();
                    if (listFiles != null) {
                        for (File procs : listFiles) {
                            String line;
                            File status;
                            String name = procs.getName();
                            if (!Character.isDigit(name.charAt(0)) || !(status = new File(procs, "status")).canRead() || (line = FileUtil.INSTANCE.readFirstLine(status)) == null || !line.contains("indicator-app")) continue;
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!SystemTray.DEBUG) break block49;
                    SystemTray.logger.error("Error detecting gnome version", e);
                }
            }
            if (OS.INSTANCE.isLinux()) {
                if (OS.Linux.INSTANCE.isUbuntu()) {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                if (OS.Linux.INSTANCE.isFedora()) {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
            }
        }
        throw new RuntimeException("This OS is not supported. Please create an issue with the details from `SystemTray.DEBUG=true;`");
    }

    public static Runnable getShutdownHook(String trayName) {
        return () -> {
            Map<String, SystemTray> map = traySingletons;
            synchronized (map) {
                if (traySingletons.containsKey(trayName)) {
                    EventDispatch.runLater(() -> {
                        Map<String, SystemTray> map = traySingletons;
                        synchronized (map) {
                            SystemTray systemTray = traySingletons.remove(trayName);
                            if (systemTray != null) {
                                systemTray.shutdown();
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(String trayName, SystemTray systemTray) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.put(trayName, systemTray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSystemTrayHook(String trayName) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.remove(trayName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOtherTrays() {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return !traySingletons.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemTray getInstance(String trayName) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return traySingletons.get(trayName);
        }
    }
}

