/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class MenuItem
extends Entry {
    static boolean alreadyEmittedTooltipWarning = false;
    private volatile String text;
    private volatile Object unknownImage = null;
    private volatile File imageFile;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey = '\u0000';
    private volatile String tooltip;

    public MenuItem() {
    }

    public MenuItem(String text) {
        this.text = text;
    }

    public MenuItem(String text, ActionListener callback) {
        this.text = text;
        this.callback = callback;
    }

    public MenuItem(String text, String imagePath) {
        this(text, imagePath, null);
    }

    public MenuItem(String text, File imageFile) {
        this(text, imageFile, null);
    }

    public MenuItem(String text, URL imageUrl) {
        this(text, imageUrl, null);
    }

    public MenuItem(String text, InputStream imageStream) {
        this(text, imageStream, null);
    }

    public MenuItem(String text, Image image) {
        this(text, image, null);
    }

    public MenuItem(String text, String imagePath, ActionListener callback) {
        this.text = text;
        this.unknownImage = imagePath;
        this.callback = callback;
    }

    public MenuItem(String text, File imageFile, ActionListener callback) {
        this.text = text;
        this.unknownImage = imageFile;
        this.callback = callback;
    }

    public MenuItem(String text, URL imageUrl, ActionListener callback) {
        this.text = text;
        this.unknownImage = imageUrl;
        this.callback = callback;
    }

    public MenuItem(String text, InputStream inputStream, ActionListener callback) {
        this.text = text;
        this.unknownImage = inputStream;
        this.callback = callback;
    }

    public MenuItem(String text, Image image, ActionListener callback) {
        this.text = text;
        this.unknownImage = image;
        this.callback = callback;
    }

    public MenuItem(String text, ImageInputStream imageStream, ActionListener callback) {
        this.text = text;
        this.unknownImage = imageStream;
        this.callback = callback;
    }

    public MenuItem(JMenuItem jMenuItem) {
        ActionListener[] actionListeners = jMenuItem.getActionListeners();
        if (actionListeners != null) {
            if (actionListeners.length == 1) {
                this.setCallback(actionListeners[0]);
            } else {
                ActionListener actionListener = e -> {
                    for (ActionListener actionListener1 : actionListeners) {
                        actionListener1.actionPerformed(e);
                    }
                };
                this.setCallback(actionListener);
            }
        }
        this.setEnabled(jMenuItem.isEnabled());
        Icon icon = jMenuItem.getIcon();
        if (icon != null) {
            BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage(bimage);
        }
        this.setShortcut(jMenuItem.getMnemonic());
        this.setText(jMenuItem.getText());
    }

    private void realizeImageFile() {
        if (this.unknownImage instanceof String) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (String)this.unknownImage);
        } else if (this.unknownImage instanceof File) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (File)this.unknownImage);
        } else if (this.unknownImage instanceof URL) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (URL)this.unknownImage);
        } else if (this.unknownImage instanceof InputStream) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (InputStream)this.unknownImage);
        } else if (this.unknownImage instanceof Image) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (Image)this.unknownImage);
        } else if (this.unknownImage instanceof ImageInputStream) {
            this.imageFile = this.imageResizeUtil.shouldResizeOrCache(false, (ImageInputStream)this.unknownImage);
        }
        this.unknownImage = null;
    }

    public void bind(MenuItemPeer peer, Menu parent, ImageResizeUtil imageResizeUtil) {
        super.bind(peer, parent, imageResizeUtil);
        this.realizeImageFile();
        peer.setImage(this);
        peer.setEnabled(this);
        peer.setText(this);
        peer.setCallback(this);
        peer.setShortcut(this);
        peer.setTooltip(this);
    }

    protected void setImageFromTray(File imageFile) {
        this.imageFile = imageFile;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public File getImage() {
        return this.imageFile;
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setText(this);
        }
    }

    public void setImage(File imageFile) {
        this.unknownImage = imageFile;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(String imagePath) {
        this.unknownImage = imagePath;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(URL imageUrl) {
        this.unknownImage = imageUrl;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(InputStream inputStream) {
        this.unknownImage = inputStream;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(Image image) {
        this.unknownImage = image;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public void setImage(ImageInputStream imageStream) {
        this.unknownImage = imageStream;
        if (this.peer != null) {
            this.realizeImageFile();
            ((MenuItemPeer)this.peer).setImage(this);
        }
    }

    public boolean hasImage() {
        return this.imageFile != null;
    }

    public void setCallback(ActionListener callback) {
        this.callback = callback;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setCallback(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char key) {
        this.mnemonicKey = key;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int key) {
        this.mnemonicKey = SwingUtil.INSTANCE.getFromVirtualKey(key);
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setShortcut(this);
        }
    }

    public void setTooltip(String tooltipText) {
        if (tooltipText != null) {
            if (tooltipText.length() > 64) {
                throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
            }
            if (!alreadyEmittedTooltipWarning) {
                alreadyEmittedTooltipWarning = true;
                SystemTray.logger.warn("Please disable tooltips, as they are not consistent across all platforms and tray types.");
            }
        }
        this.tooltip = tooltipText;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setTooltip(this);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    protected JMenuItem asSwingComponent() {
        JMenuItem jMenuItem = new JMenuItem();
        if (this.getImage() != null) {
            jMenuItem.setIcon(new ImageIcon(this.getImage().getAbsolutePath()));
        }
        jMenuItem.setText(this.getText());
        jMenuItem.setToolTipText(this.getTooltip());
        jMenuItem.setEnabled(this.getEnabled());
        jMenuItem.setMnemonic(SwingUtil.INSTANCE.getVirtualKey(this.getShortcut()));
        jMenuItem.addActionListener(this.getCallback());
        return jMenuItem;
    }
}

