/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.swing;

import dorkbox.util.ActionHandlerLong;
import dorkbox.util.Property;
import dorkbox.util.swing.SwingActiveRender;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.util.List;

public class ActiveRenderLoop
implements Runnable {
    @Property
    public static int TARGET_FPS = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastTime = System.nanoTime();
        long OPTIMAL_TIME = 1000000000 / TARGET_FPS;
        Graphics graphics = null;
        while (SwingActiveRender.hasActiveRenders) {
            long now = System.nanoTime();
            long updateDeltaNanos = now - lastTime;
            lastTime = now;
            for (int i = 0; i < SwingActiveRender.activeRenderEvents.size(); ++i) {
                ActionHandlerLong actionHandlerLong = SwingActiveRender.activeRenderEvents.get(i);
                actionHandlerLong.handle(updateDeltaNanos);
            }
            List<Canvas> i = SwingActiveRender.activeRenders;
            synchronized (i) {
                List<Canvas> activeRenders = SwingActiveRender.activeRenders;
                for (Canvas canvas : activeRenders) {
                    if (!canvas.isDisplayable()) continue;
                    BufferStrategy buffer = canvas.getBufferStrategy();
                    try {
                        graphics = buffer.getDrawGraphics();
                        canvas.paint(graphics);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (graphics == null) continue;
                        graphics.dispose();
                        if (buffer == null || buffer.contentsLost()) continue;
                        buffer.show();
                    }
                }
            }
            Toolkit.getDefaultToolkit().sync();
            try {
                int l = (int)(lastTime - System.nanoTime() + OPTIMAL_TIME);
                int millis = l / 1000000;
                if (millis > 1) {
                    Thread.sleep(millis);
                    continue;
                }
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

