/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 L2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002LMB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\nJ\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u000e\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005J\u0016\u0010(\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u0002H\u0002J\b\u00101\u001a\u00020)H\u0016J\u000e\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u0005J\u0011\u00103\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0002H\u0096\u0002J\u0016\u00104\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\u000e\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u0005J\u0013\u00107\u001a\u00020\f2\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\u0006\u0010:\u001a\u00020\u0002J\u0018\u0010;\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u0005H\u0016J\b\u0010>\u001a\u00020\fH\u0016J\t\u0010?\u001a\u00020\u0012H\u0096\u0002J\u0010\u0010@\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0002H\u0002J\u0006\u0010A\u001a\u00020\fJ\u0010\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0002H\u0004J\u0010\u0010D\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u0016\u0010E\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\u0010\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020\u0005H\u0002J\u0016\u0010H\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\u000e\u0010I\u001a\u00020)2\u0006\u00102\u001a\u00020\u0005J\b\u0010J\u001a\u00020KH\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0014\u0010\"\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001cR\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Ldorkbox/collections/LongSet;", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/LongSet;)V", "hasZeroValue", "", "getHasZeroValue", "()Z", "setHasZeroValue", "(Z)V", "iterator1", "Ldorkbox/collections/LongSet$LongSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[J", "setKeyTable", "([J)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "add", "element", "addAll", "", "array", "offset", "length", "elements", "", "addResize", "key", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "", "first", "get", "(J)Ljava/lang/Long;", "hashCode", "isEmpty", "iterator", "locateKey", "notEmpty", "place", "item", "remove", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "Companion", "LongSetIterator", "Collections"})
@SourceDebugExtension(value={"SMAP\nLongSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongSet.kt\ndorkbox/collections/LongSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,584:1\n1855#2,2:585\n1855#2,2:588\n1855#2,2:592\n1#3:587\n13607#4,2:590\n*S KotlinDebug\n*F\n+ 1 LongSet.kt\ndorkbox/collections/LongSet\n*L\n195#1:585,2\n326#1:588,2\n476#1:592,2\n465#1:590,2\n*E\n"})
public final class LongSet
implements Set<Long>,
KMutableSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    @NotNull
    private long[] keyTable;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient LongSetIterator iterator1;
    @Nullable
    private transient LongSetIterator iterator2;
    @NotNull
    public static final String version = "2.4";

    @NotNull
    public final long[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.keyTable = lArray;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public LongSet() {
        this(51, 0.8f);
    }

    public LongSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
    }

    public /* synthetic */ LongSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public LongSet(@NotNull LongSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this((int)((float)set.keyTable.length * set.loadFactor), set.loadFactor);
        System.arraycopy(set.keyTable, 0, this.keyTable, 0, set.keyTable.length);
        this.size_ = set.size_;
        this.hasZeroValue = set.hasZeroValue;
    }

    public int getSize() {
        return this.size_;
    }

    protected final int place(long item) {
        return (int)(item * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Nullable
    public final Long get(long key) {
        int i = this.locateKey(key);
        return i < 0 ? null : Long.valueOf(this.keyTable[i]);
    }

    @Override
    public boolean add(long element) {
        if (element == 0L) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            int n = this.size_;
            this.size_ = n + 1;
            return true;
        }
        int i = this.locateKey(element);
        if (i >= 0) {
            return false;
        }
        i = -(i + 1);
        this.keyTable[i] = element;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Long> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean added = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            added = this.add(it) || added;
        }
        return added;
    }

    public final void addAll(@NotNull long[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.addAll(array, 0, array.length);
    }

    public final void addAll(@NotNull long[] array, int offset, int length) {
        int i;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (offset + length > array.length) {
            throw new StateException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.length);
        }
        this.ensureCapacity(length);
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
    }

    public final void addAll(@NotNull LongSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this.ensureCapacity(set.size_);
        if (set.hasZeroValue) {
            this.add(0L);
        }
        for (long key : set.keyTable) {
            if (key == 0L) continue;
            this.add(key);
        }
    }

    private final void addResize(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public boolean remove(long element) {
        if (element == 0L) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            int n = this.size_;
            this.size_ = n + -1;
            return true;
        }
        int i = this.locateKey(element);
        if (i < 0) {
            return false;
        }
        long[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        long k = 0L;
        while (true) {
            long l;
            long it = l = keyTable[next];
            boolean bl = false;
            k = it;
            if (l == 0L) break;
            int placement = this.place(k);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        int n = this.size_;
        this.size_ = n + -1;
        return true;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public final void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public final void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0L);
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            if (this.contains((Object)it)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(long element) {
        return element == 0L ? this.hasZeroValue : this.locateKey(element) >= 0;
    }

    public final long first() {
        if (this.hasZeroValue) {
            return 0L;
        }
        long[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0L) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("LongSet is empty.");
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.size_ + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] oldKeyTable = this.keyTable;
        this.keyTable = new long[newSize];
        if (this.size_ > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.addResize(key);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size_;
        for (long key : this.keyTable) {
            if (key == 0L) continue;
            h += (int)key;
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LongSet)) {
            return false;
        }
        if (((LongSet)other).size_ != this.size_) {
            return false;
        }
        if (((LongSet)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        long[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0L || ((LongSet)other).contains((Object)keyTable[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        long key;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        long[] keyTable = this.keyTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0");
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0L) continue;
                buffer.append(key);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(", ");
            buffer.append(key);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public LongSetIterator iterator() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new LongSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new LongSetIterator(this);
            this.iterator2 = new LongSetIterator(this);
        }
        LongSetIterator longSetIterator = this.iterator1;
        Intrinsics.checkNotNull((Object)longSetIterator);
        if (!longSetIterator.getValid()) {
            LongSetIterator longSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator2);
            longSetIterator2.reset();
            LongSetIterator longSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator3);
            longSetIterator3.setValid(true);
            LongSetIterator longSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull((Object)longSetIterator4);
            longSetIterator4.setValid(false);
            LongSetIterator longSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull((Object)longSetIterator5);
            return longSetIterator5;
        }
        LongSetIterator longSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator6);
        longSetIterator6.reset();
        LongSetIterator longSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator7);
        longSetIterator7.setValid(true);
        LongSetIterator longSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull((Object)longSetIterator8);
        longSetIterator8.setValid(false);
        LongSetIterator longSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull((Object)longSetIterator9);
        return longSetIterator9;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        long[] $this$forEach$iv = this.keyTable;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (elements.contains(it)) continue;
            this.remove((Object)it);
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            removed = this.remove((Object)it) || removed;
        }
        return removed;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011\u00a8\u0006$"}, d2={"Ldorkbox/collections/LongSet$LongSetIterator;", "", "", "set", "Ldorkbox/collections/LongSet;", "(Ldorkbox/collections/LongSet;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/LongSet;", "valid", "getValid", "setValid", "findNextIndex", "", "next", "()Ljava/lang/Long;", "remove", "reset", "toArray", "", "array", "Companion", "Collections"})
    @SourceDebugExtension(value={"SMAP\nLongSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongSet.kt\ndorkbox/collections/LongSet$LongSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1#2:585\n*E\n"})
    public static final class LongSetIterator
    implements Iterator<Long>,
    KMutableIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LongSet set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;

        public LongSetIterator(@NotNull LongSet set) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            this.set = set;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final LongSet getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                long[] keyTable = this.set.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == 0L);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.set.getHasZeroValue()) {
                this.set.setHasZeroValue(false);
            } else {
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] keyTable = this.set.getKeyTable();
                int mask = this.set.getMask();
                int next = i + 1 & mask;
                long key = 0L;
                while (true) {
                    long l;
                    long it = l = keyTable[next];
                    boolean bl = false;
                    key = it;
                    if (l == 0L) break;
                    int placement = this.set.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0L;
                if (i != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                LongSet longSet = this.set;
                int n = longSet.size_;
                longSet.size_ = n + -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NotNull
        public Long next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long key = this.nextIndex == -1 ? 0L : this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        @NotNull
        public final long[] toArray() {
            long[] array = new long[this.set.size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @NotNull
        public final long[] toArray(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.hasNext) {
                array[index++] = this.next();
            }
            return array;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/LongSet$LongSetIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/collections/LongSet$Companion;", "", "()V", "version", "", "with", "Ldorkbox/collections/LongSet;", "array", "", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongSet with(long ... array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            LongSet set = new LongSet();
            set.addAll(array);
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

