/*
 * Decompiled with CFR 0.152.
 */
package com.don11995.log;

import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.don11995.log.Group;
import com.don11995.log.LogProcessor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class SimpleLog {
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_VERBOSE = 4;
    public static final int LOG_LEVEL_ASSERT = 5;
    private static final int MAX_LOG_CHUNK_SIZE = 4000;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int CALL_STACK_INDEX = 2;
    private static final Set<Integer> sLogLevels;
    private static char sDividerChar;
    private static int sDividerBlockSize;
    private static List<LogProcessor> sLogProcessorList;
    private static boolean sPrintReferences;

    private SimpleLog() {
    }

    public static void disableAllLogs() {
        sLogLevels.clear();
    }

    public static void enableAllLogs() {
        sLogLevels.add(0);
        sLogLevels.add(1);
        sLogLevels.add(2);
        sLogLevels.add(3);
        sLogLevels.add(4);
        sLogLevels.add(5);
    }

    public static void setLogLevelEnabled(int logLevel, boolean enabled) {
        if (enabled) {
            sLogLevels.add(logLevel);
        } else {
            sLogLevels.remove(logLevel);
        }
    }

    public static boolean isLogLevelEnabled(int logLevel) {
        return sLogLevels.contains(logLevel);
    }

    public static void setDividerChar(char divider) {
        sDividerChar = divider;
    }

    public static void setDividerBlockSize(@IntRange(from=1L) int dividerBlockSize) {
        sDividerBlockSize = dividerBlockSize;
    }

    private static String formatText(String text, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)text) || args == null || args.length == 0) {
            return text;
        }
        return String.format(Locale.getDefault(), text, args);
    }

    private static String formatText(Group group) {
        String format = group.getText();
        String groupName = group.getGroupName();
        if (groupName == null) {
            groupName = "";
        }
        char[] buffer = new char[sDividerBlockSize];
        Arrays.fill(buffer, sDividerChar);
        String divider = new String(buffer);
        format = divider + groupName + divider + "\n\t" + format;
        buffer = new char[groupName.length()];
        Arrays.fill(buffer, sDividerChar);
        format = format + "\n\t" + divider + divider + new String(buffer);
        return format;
    }

    @Nullable
    private static String getTagFromObject(@Nullable Object object) {
        if (object instanceof Group) {
            return ((Group)object).getTag();
        }
        return null;
    }

    @Nullable
    private static String getMessageFromObject(@Nullable Object object) {
        if (object instanceof Group) {
            return SimpleLog.formatText((Group)object);
        }
        if (object instanceof Throwable) {
            StringWriter errors = new StringWriter();
            ((Throwable)object).printStackTrace(new PrintWriter(errors));
            return errors.toString();
        }
        return object != null ? object.toString() : null;
    }

    private static boolean isGroupObject(@Nullable Object object) {
        return object instanceof Group;
    }

    public static void fd() {
        SimpleLog.printLog(1, null, true, null, null, false);
    }

    public static void fe() {
        SimpleLog.printLog(0, null, true, null, null, false);
    }

    public static void fi() {
        SimpleLog.printLog(3, null, true, null, null, false);
    }

    public static void fv() {
        SimpleLog.printLog(4, null, true, null, null, false);
    }

    public static void fw() {
        SimpleLog.printLog(2, null, true, null, null, false);
    }

    public static void fwtf() {
        SimpleLog.printLog(5, null, true, null, null, false);
    }

    public static void tfd(String tag) {
        SimpleLog.printLog(1, null, true, tag, null, false);
    }

    public static void tfe(String tag) {
        SimpleLog.printLog(0, null, true, tag, null, false);
    }

    public static void tfi(String tag) {
        SimpleLog.printLog(3, null, true, tag, null, false);
    }

    public static void tfv(String tag) {
        SimpleLog.printLog(4, null, true, tag, null, false);
    }

    public static void tfw(String tag) {
        SimpleLog.printLog(2, null, true, tag, null, false);
    }

    public static void tfwtf(String tag) {
        SimpleLog.printLog(5, null, true, tag, null, false);
    }

    public static void d(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void e(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void i(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void v(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void w(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void wtf(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void td(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void te(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void ti(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tv(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tw(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void twtf(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), false, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fd(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fe(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fi(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fv(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fw(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void fwtf(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfd(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfe(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfi(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfv(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfw(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void tfwtf(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), true, tag, object instanceof Throwable ? (Throwable)object : null, isGroup);
    }

    public static void d(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void e(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void i(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void v(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void w(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void wtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, args), false, null, null, false);
    }

    public static void td(String tag, String format, Object ... objects) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void te(String tag, String format, Object ... objects) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void ti(String tag, String format, Object ... objects) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void tv(String tag, String format, Object ... objects) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void tw(String tag, String format, Object ... objects) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void twtf(String tag, String format, Object ... objects) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, objects), false, tag, null, false);
    }

    public static void fd(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void fe(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void fi(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void fv(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void fw(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void fwtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, args), true, null, null, false);
    }

    public static void tfd(String tag, String format, Object ... objects) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void tfe(String tag, String format, Object ... objects) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void tfi(String tag, String format, Object ... objects) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void tfv(String tag, String format, Object ... objects) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void tfw(String tag, String format, Object ... objects) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void tfwtf(String tag, String format, Object ... objects) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, objects), true, tag, null, false);
    }

    public static void addLogProcessor(@NonNull LogProcessor logProcessor) {
        sLogProcessorList.add(logProcessor);
    }

    public static void removeLogProcessor(@NonNull LogProcessor logProcessor) {
        sLogProcessorList.remove(logProcessor);
    }

    public static void setPrintReferences(boolean enabled) {
        sPrintReferences = enabled;
    }

    private static String detectClassName(String origClassName) {
        int firstDollar;
        if (TextUtils.isEmpty((CharSequence)origClassName)) {
            return origClassName;
        }
        String className = origClassName;
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            className = className.substring(lastDot + 1);
        }
        if ((firstDollar = className.indexOf(36)) > 0) {
            className = className.substring(0, firstDollar);
        }
        return className;
    }

    private static void printLog(int logLevel, @Nullable String inMessage, boolean printMethodName, @Nullable String inTag, @Nullable Throwable e, boolean isGroup) {
        if (!sLogLevels.contains(logLevel)) {
            return;
        }
        String message = inMessage;
        String tag = inTag;
        if (message == null) {
            message = "";
        }
        StackTraceElement element = new Throwable().getStackTrace()[2];
        String className = SimpleLog.detectClassName(element.getClassName());
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = className;
        }
        if (tag.length() > 23 && Build.VERSION.SDK_INT < 24) {
            tag = tag.substring(0, 23);
        }
        message = message.replaceAll("\r", "").replaceAll("\n+", "\n").trim();
        if (printMethodName) {
            String method = element.getMethodName();
            message = message.isEmpty() ? method + "()" : method + "() -> " + (isGroup ? "\n\t" : "") + message;
        }
        if (sPrintReferences && e == null) {
            message = '(' + className + ".java:" + element.getLineNumber() + ')' + (isGroup ? "\n\t" : Character.valueOf(' ')) + message;
            message = message.trim();
        }
        if (message.isEmpty()) {
            return;
        }
        ArrayList<String> logs = new ArrayList<String>();
        while (message.length() > 4000) {
            String temp = message.substring(0, 4000);
            int nextStartIndex = temp.lastIndexOf(10);
            if (nextStartIndex <= 0) {
                nextStartIndex = 4000;
            }
            temp = temp.substring(0, nextStartIndex).trim();
            logs.add(temp);
            message = message.substring(nextStartIndex).trim();
        }
        logs.add(message);
        for (String s : logs) {
            switch (logLevel) {
                case 1: {
                    Log.d((String)tag, (String)s);
                    break;
                }
                case 0: {
                    Log.e((String)tag, (String)s);
                    break;
                }
                case 3: {
                    Log.i((String)tag, (String)s);
                    break;
                }
                case 4: {
                    Log.v((String)tag, (String)s);
                    break;
                }
                case 2: {
                    Log.w((String)tag, (String)s);
                    break;
                }
                case 5: {
                    Log.wtf((String)tag, (String)s);
                    break;
                }
            }
        }
        for (LogProcessor logProcessor : sLogProcessorList) {
            logProcessor.handleProcessLog(tag, message, logLevel, e);
        }
    }

    static {
        sDividerChar = (char)45;
        sDividerBlockSize = 8;
        sPrintReferences = false;
        sLogLevels = new HashSet<Integer>();
        sLogProcessorList = new ArrayList<LogProcessor>();
        SimpleLog.enableAllLogs();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

