/*
 * Decompiled with CFR 0.152.
 */
package com.don11995.log;

import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.don11995.log.Group;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class SimpleLog {
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_VERBOSE = 4;
    public static final int LOG_LEVEL_ASSERT = 5;
    private static final int MAX_LOG_CHUNK_SIZE = 4000;
    private static final int MAX_TAG_LENGTH = 23;
    private static final int CALL_STACK_INDEX = 2;
    private static final Set<Integer> mLogLevels;
    private static char sDividerChar;
    private static int sDividerBlockSize;

    private SimpleLog() {
    }

    public static void disableAllLogs() {
        mLogLevels.clear();
    }

    public static void enableAllLogs() {
        mLogLevels.add(0);
        mLogLevels.add(1);
        mLogLevels.add(2);
        mLogLevels.add(3);
        mLogLevels.add(4);
        mLogLevels.add(5);
    }

    public static void setLogLevelEnabled(int logLevel, boolean enabled) {
        if (enabled) {
            mLogLevels.add(logLevel);
        } else {
            mLogLevels.remove(logLevel);
        }
    }

    public static boolean isLogLevelEnabled(int logLevel) {
        return mLogLevels.contains(logLevel);
    }

    public static void setDividerChar(char divider) {
        sDividerChar = divider;
    }

    public static void setDividerBlockSize(@IntRange(from=1L) int dividerBlockSize) {
        sDividerBlockSize = dividerBlockSize;
    }

    private static String formatText(String text, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)text) || args == null || args.length == 0) {
            return text;
        }
        return String.format(Locale.getDefault(), text, args);
    }

    private static String formatText(Group group) {
        String format = group.getText();
        String groupName = group.getGroupName();
        if (groupName == null) {
            groupName = "";
        }
        char[] buffer = new char[sDividerBlockSize];
        Arrays.fill(buffer, sDividerChar);
        String divider = new String(buffer);
        format = divider + groupName + divider + "\n" + format;
        buffer = new char[groupName.length()];
        Arrays.fill(buffer, sDividerChar);
        format = format + "\n" + divider + divider + new String(buffer);
        return format;
    }

    @Nullable
    private static String getTagFromObject(@Nullable Object object) {
        if (object instanceof Group) {
            return ((Group)object).getTag();
        }
        return null;
    }

    @Nullable
    private static String getMessageFromObject(@Nullable Object object) {
        if (object instanceof Group) {
            return SimpleLog.formatText((Group)object);
        }
        if (object instanceof Throwable) {
            StringWriter errors = new StringWriter();
            ((Throwable)object).printStackTrace(new PrintWriter(errors));
            return errors.toString();
        }
        return object != null ? object.toString() : null;
    }

    private static boolean isGroupObject(@Nullable Object object) {
        return object instanceof Group;
    }

    public static void fd() {
        SimpleLog.printLog(1, null, true, null, false);
    }

    public static void fe() {
        SimpleLog.printLog(0, null, true, null, false);
    }

    public static void fi() {
        SimpleLog.printLog(3, null, true, null, false);
    }

    public static void fv() {
        SimpleLog.printLog(4, null, true, null, false);
    }

    public static void fw() {
        SimpleLog.printLog(2, null, true, null, false);
    }

    public static void fwtf() {
        SimpleLog.printLog(5, null, true, null, false);
    }

    public static void tfd(String tag) {
        SimpleLog.printLog(1, null, true, tag, false);
    }

    public static void tfe(String tag) {
        SimpleLog.printLog(0, null, true, tag, false);
    }

    public static void tfi(String tag) {
        SimpleLog.printLog(3, null, true, tag, false);
    }

    public static void tfv(String tag) {
        SimpleLog.printLog(4, null, true, tag, false);
    }

    public static void tfw(String tag) {
        SimpleLog.printLog(2, null, true, tag, false);
    }

    public static void tfwtf(String tag) {
        SimpleLog.printLog(5, null, true, tag, false);
    }

    public static void d(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void e(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void i(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void v(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void w(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void wtf(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), false, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void td(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void te(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void ti(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void tv(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void tw(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void twtf(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), false, tag, isGroup);
    }

    public static void fd(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void fe(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void fi(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void fv(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void fw(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void fwtf(Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), true, SimpleLog.getTagFromObject(object), isGroup);
    }

    public static void tfd(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(1, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void tfe(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void tfi(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(3, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void tfv(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(4, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void tfw(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(2, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void tfwtf(String tag, Object object) {
        boolean isGroup = SimpleLog.isGroupObject(object);
        SimpleLog.printLog(5, SimpleLog.getMessageFromObject(object), true, tag, isGroup);
    }

    public static void d(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void e(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void i(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void v(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void w(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void wtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, args), false, null, false);
    }

    public static void fd(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void fe(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void fi(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void fv(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void fw(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void fwtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatText(format, args), true, null, false);
    }

    public static void e(Throwable throwable) {
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(throwable), false, null, false);
    }

    public static void te(String tag, Throwable throwable) {
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(throwable), false, tag, false);
    }

    public static void fe(Throwable throwable) {
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(throwable), true, null, false);
    }

    public static void tfe(String tag, Throwable throwable) {
        SimpleLog.printLog(0, SimpleLog.getMessageFromObject(throwable), true, tag, false);
    }

    private static void printLog(int logLevel, @Nullable String inMessage, boolean printMethodName, @Nullable String inTag, boolean isGroup) {
        int firstDollar;
        int lastDot;
        if (!mLogLevels.contains(logLevel)) {
            return;
        }
        String message = inMessage;
        String tag = inTag;
        if (message == null) {
            message = "";
        }
        StackTraceElement element = new Throwable().getStackTrace()[2];
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = element.getClassName();
        }
        if ((lastDot = tag.lastIndexOf(46)) >= 0) {
            tag = tag.substring(lastDot + 1);
        }
        if ((firstDollar = tag.indexOf(36)) > 0) {
            tag = tag.substring(0, firstDollar);
        }
        if (tag.length() > 23 && Build.VERSION.SDK_INT < 24) {
            tag = tag.substring(0, 23);
        }
        message = message.replaceAll("\r", "").replaceAll("\n+", "\n").trim();
        if (printMethodName) {
            String method = element.getMethodName();
            message = message.isEmpty() ? method + "()" : method + "() -> " + (isGroup ? "\n" : "") + message;
        }
        if (message.isEmpty()) {
            return;
        }
        ArrayList<String> logs = new ArrayList<String>();
        while (message.length() > 4000) {
            String temp = message.substring(0, 4000);
            int nextStartIndex = temp.lastIndexOf(10);
            if (nextStartIndex <= 0) {
                nextStartIndex = 4000;
            }
            temp = temp.substring(0, nextStartIndex).trim();
            logs.add(temp);
            message = message.substring(nextStartIndex).trim();
        }
        logs.add(message);
        for (String s : logs) {
            switch (logLevel) {
                case 1: {
                    Log.d((String)tag, (String)s);
                    break;
                }
                case 0: {
                    Log.e((String)tag, (String)s);
                    break;
                }
                case 3: {
                    Log.i((String)tag, (String)s);
                    break;
                }
                case 4: {
                    Log.v((String)tag, (String)s);
                    break;
                }
                case 2: {
                    Log.w((String)tag, (String)s);
                    break;
                }
                case 5: {
                    Log.wtf((String)tag, (String)s);
                    break;
                }
            }
        }
    }

    static {
        sDividerChar = (char)45;
        sDividerBlockSize = 8;
        mLogLevels = new HashSet<Integer>();
        SimpleLog.enableAllLogs();
    }
}

