/*
 * Decompiled with CFR 0.152.
 */
package com.don11995.log;

import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.don11995.log.Group;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class SimpleLog {
    public static final int LOG_LEVEL_NONE = -1;
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_VERBOSE = 4;
    public static final int LOG_LEVEL_ALL = 5;
    private static final int MAX_LOG_CHUNK_SIZE = 4000;
    private static int mLogLevel = 5;
    private static char sDividerChar = (char)45;
    private static int sDividerBlockSize = 8;

    public static void setLogLevel(int logLevel) {
        mLogLevel = logLevel;
    }

    public static void setDividerChar(char divider) {
        sDividerChar = divider;
    }

    public static void setDividerBlockSize(@IntRange(from=1L) int dividerBlockSize) {
        sDividerBlockSize = dividerBlockSize;
    }

    private static String formatGroup(String text, Object ... args) {
        if (TextUtils.isEmpty((CharSequence)text) || args == null || args.length == 0) {
            return text;
        }
        return String.format(text, args);
    }

    private static String formatGroup(Group group) {
        String format = group.getText();
        String groupName = group.getGroupName();
        if (groupName == null) {
            groupName = "";
        }
        char[] buffer = new char[sDividerBlockSize];
        Arrays.fill(buffer, sDividerChar);
        String divider = new String(buffer);
        format = divider + groupName + divider + "\n" + format;
        buffer = new char[groupName.length()];
        Arrays.fill(buffer, sDividerChar);
        format = format + "\n" + divider + divider + new String(buffer);
        return format;
    }

    public static void d() {
        SimpleLog.printLog(1, null, true);
    }

    public static void e() {
        SimpleLog.printLog(0, null, true);
    }

    public static void i() {
        SimpleLog.printLog(3, null, true);
    }

    public static void v() {
        SimpleLog.printLog(4, null, true);
    }

    public static void w() {
        SimpleLog.printLog(2, null, true);
    }

    public static void wtf() {
        SimpleLog.printLog(5, null, true);
    }

    public static void d(Object object) {
        SimpleLog.printLog(1, object != null ? object.toString() : null, false);
    }

    public static void e(Object object) {
        SimpleLog.printLog(0, object != null ? object.toString() : null, false);
    }

    public static void i(Object object) {
        SimpleLog.printLog(3, object != null ? object.toString() : null, false);
    }

    public static void v(Object object) {
        SimpleLog.printLog(4, object != null ? object.toString() : null, false);
    }

    public static void w(Object object) {
        SimpleLog.printLog(2, object != null ? object.toString() : null, false);
    }

    public static void wtf(Object object) {
        SimpleLog.printLog(5, object != null ? object.toString() : null, false);
    }

    public static void fd(Object object) {
        SimpleLog.printLog(1, object != null ? object.toString() : null, true);
    }

    public static void fe(Object object) {
        SimpleLog.printLog(0, object != null ? object.toString() : null, true);
    }

    public static void fi(Object object) {
        SimpleLog.printLog(3, object != null ? object.toString() : null, true);
    }

    public static void fv(Object object) {
        SimpleLog.printLog(4, object != null ? object.toString() : null, true);
    }

    public static void fw(Object object) {
        SimpleLog.printLog(2, object != null ? object.toString() : null, true);
    }

    public static void fwtf(Object object) {
        SimpleLog.printLog(5, object != null ? object.toString() : null, true);
    }

    public static void d(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatGroup(format, args), false);
    }

    public static void e(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatGroup(format, args), false);
    }

    public static void i(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatGroup(format, args), false);
    }

    public static void v(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatGroup(format, args), false);
    }

    public static void w(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatGroup(format, args), false);
    }

    public static void wtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatGroup(format, args), false);
    }

    public static void fd(String format, Object ... args) {
        SimpleLog.printLog(1, SimpleLog.formatGroup(format, args), true);
    }

    public static void fe(String format, Object ... args) {
        SimpleLog.printLog(0, SimpleLog.formatGroup(format, args), true);
    }

    public static void fi(String format, Object ... args) {
        SimpleLog.printLog(3, SimpleLog.formatGroup(format, args), true);
    }

    public static void fv(String format, Object ... args) {
        SimpleLog.printLog(4, SimpleLog.formatGroup(format, args), true);
    }

    public static void fw(String format, Object ... args) {
        SimpleLog.printLog(2, SimpleLog.formatGroup(format, args), true);
    }

    public static void fwtf(String format, Object ... args) {
        SimpleLog.printLog(5, SimpleLog.formatGroup(format, args), true);
    }

    public static void d(Group group) {
        SimpleLog.printLog(1, SimpleLog.formatGroup(group), false);
    }

    public static void e(Group group) {
        SimpleLog.printLog(0, SimpleLog.formatGroup(group), false);
    }

    public static void i(Group group) {
        SimpleLog.printLog(3, SimpleLog.formatGroup(group), false);
    }

    public static void v(Group group) {
        SimpleLog.printLog(4, SimpleLog.formatGroup(group), false);
    }

    public static void w(Group group) {
        SimpleLog.printLog(2, SimpleLog.formatGroup(group), false);
    }

    public static void wtf(Group group) {
        SimpleLog.printLog(5, SimpleLog.formatGroup(group), false);
    }

    public static void fd(Group group) {
        SimpleLog.printLog(1, SimpleLog.formatGroup(group), true);
    }

    public static void fe(Group group) {
        SimpleLog.printLog(0, SimpleLog.formatGroup(group), true);
    }

    public static void fi(Group group) {
        SimpleLog.printLog(3, SimpleLog.formatGroup(group), true);
    }

    public static void fv(Group group) {
        SimpleLog.printLog(4, SimpleLog.formatGroup(group), true);
    }

    public static void fw(Group group) {
        SimpleLog.printLog(2, SimpleLog.formatGroup(group), true);
    }

    public static void fwtf(Group group) {
        SimpleLog.printLog(5, SimpleLog.formatGroup(group), true);
    }

    public static void e(Throwable throwable) {
        if (throwable == null) {
            SimpleLog.printLog(0, null, false);
            return;
        }
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        SimpleLog.printLog(0, errors.toString(), false);
    }

    public static void fe(Throwable throwable) {
        if (throwable == null) {
            SimpleLog.printLog(0, null, true);
            return;
        }
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        SimpleLog.printLog(0, errors.toString(), true);
    }

    private static void printLog(int logLevel, @Nullable String message, boolean printFunctionName) {
        int firstDollar;
        StackTraceElement element;
        String tag;
        int lastDot;
        if (mLogLevel < logLevel) {
            return;
        }
        if (message == null) {
            message = "";
        }
        if ((lastDot = (tag = (element = Thread.currentThread().getStackTrace()[4]).getClassName()).lastIndexOf(46)) >= 0) {
            tag = tag.substring(lastDot + 1);
        }
        if ((firstDollar = tag.indexOf(36)) > 0) {
            tag = tag.substring(0, firstDollar);
        }
        message = message.replaceAll("\r", "").replaceAll("\n\n", "\n").trim();
        if (printFunctionName) {
            String method = element.getMethodName();
            message = message.isEmpty() ? method + "()" : method + "():\n" + message;
        }
        if (message.isEmpty()) {
            return;
        }
        ArrayList<String> logs = new ArrayList<String>();
        while (message.length() > 4000) {
            String temp = message.substring(0, 4000);
            int nextStartIndex = temp.lastIndexOf(10) + 1;
            if (nextStartIndex <= 0) {
                nextStartIndex = 4000;
            }
            temp = temp.substring(0, nextStartIndex).trim();
            logs.add(temp);
            message = message.substring(nextStartIndex);
        }
        logs.add(message);
        for (String s : logs) {
            switch (logLevel) {
                case 1: {
                    Log.d((String)tag, (String)s);
                    break;
                }
                case 0: {
                    Log.e((String)tag, (String)s);
                    break;
                }
                case 3: {
                    Log.i((String)tag, (String)s);
                    break;
                }
                case 4: {
                    Log.v((String)tag, (String)s);
                    break;
                }
                case 2: {
                    Log.w((String)tag, (String)s);
                    break;
                }
                case 5: {
                    Log.wtf((String)tag, (String)s);
                    break;
                }
            }
        }
    }
}

